/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

@BugPattern(name="AutoFactoryAtInject", summary="@AutoFactory and @Inject should not be used in the same type.", explanation="@AutoFactory classes should not be @Inject-ed, inject the generated factory instead. Classes that are annotated with @AutoFactory are intended to be constructed by invoking the factory method on the generated factory. Typically this is because some of the necessary constructor arguments are not part of the binding graph. Generated @AutoFactory classes are automatically marked @Inject - prefer to inject that instead.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR)
public class AutoFactoryAtInject
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<Tree> HAS_AUTO_FACTORY_ANNOTATION = Matchers.hasAnnotation((String)"com.google.auto.factory.AutoFactory");

    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (!InjectMatchers.IS_APPLICATION_OF_AT_INJECT.matches((Tree)annotationTree, state)) {
            return Description.NO_MATCH;
        }
        Tree annotatedTree = this.getCurrentlyAnnotatedNode(state);
        if (!annotatedTree.getKind().equals((Object)Tree.Kind.METHOD) || !Matchers.methodIsConstructor().matches((Tree)((MethodTree)annotatedTree), state)) {
            return Description.NO_MATCH;
        }
        ClassTree classTree = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        ImmutableList potentiallyAnnotatedTrees = new ImmutableList.Builder().add((Object)classTree).addAll((Iterable)ASTHelpers.getConstructors((ClassTree)classTree)).build();
        for (Tree potentiallyAnnotatedTree : potentiallyAnnotatedTrees) {
            if (!HAS_AUTO_FACTORY_ANNOTATION.matches(potentiallyAnnotatedTree, state)) continue;
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.delete((Tree)annotationTree));
        }
        return Description.NO_MATCH;
    }

    private Tree getCurrentlyAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

