/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.HashSet;

@BugPattern(name="RemoveUnusedImports", summary="Unused imports", explanation="This import is unused.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, documentSuppression=false)
public final class RemoveUnusedImports
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree compilationUnitTree, VisitorState state) {
        final ImmutableSetMultimap<ImportTree, Symbol> importedSymbols = RemoveUnusedImports.getImportedSymbols(compilationUnitTree, state);
        if (importedSymbols.isEmpty()) {
            return Description.NO_MATCH;
        }
        final HashSet unusedImports = new HashSet(importedSymbols.keySet());
        new TreeSymbolScanner(JavacTrees.instance(state.context), state.getTypes()).scan((Tree)compilationUnitTree, new SymbolSink(){

            @Override
            public boolean keepScanning() {
                return !unusedImports.isEmpty();
            }

            @Override
            public void accept(Symbol symbol) {
                unusedImports.removeAll((Collection<?>)importedSymbols.inverse().get((Object)symbol));
            }
        });
        if (unusedImports.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (ImportTree unusedImport : unusedImports) {
            fixBuilder.delete((Tree)unusedImport);
        }
        return this.describeMatch((Tree)unusedImports.iterator().next(), (Fix)fixBuilder.build());
    }

    private static ImmutableSetMultimap<ImportTree, Symbol> getImportedSymbols(CompilationUnitTree compilationUnitTree, VisitorState state) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            builder.putAll((Object)importTree, RemoveUnusedImports.getImportedSymbols(importTree, state));
        }
        return builder.build();
    }

    private static ImmutableSet<Symbol> getImportedSymbols(ImportTree importTree, VisitorState state) {
        if (importTree.isStatic()) {
            StaticImports.StaticImportInfo staticImportInfo = StaticImports.tryCreate(importTree, state);
            return staticImportInfo == null ? ImmutableSet.of() : staticImportInfo.members();
        }
        Symbol importedSymbol = ASTHelpers.getSymbol((Tree)importTree.getQualifiedIdentifier());
        return importedSymbol == null ? ImmutableSet.of() : ImmutableSet.of((Object)importedSymbol);
    }

    private static final class TreeSymbolScanner
    extends TreePathScanner<Void, SymbolSink> {
        final DocTreeSymbolScanner docTreeSymbolScanner;
        final JavacTrees trees;
        final Types types;

        private TreeSymbolScanner(JavacTrees trees, Types types) {
            this.types = types;
            this.docTreeSymbolScanner = new DocTreeSymbolScanner();
            this.trees = trees;
        }

        @Override
        public Void visitImport(ImportTree importTree, SymbolSink usedSymbols) {
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, SymbolSink sink) {
            if (tree == null) {
                return null;
            }
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            if (symbol == null) {
                return null;
            }
            sink.accept(symbol.baseSymbol());
            return null;
        }

        @Override
        public Void scan(Tree tree, SymbolSink sink) {
            if (!sink.keepScanning()) {
                return null;
            }
            if (tree == null) {
                return null;
            }
            this.scanJavadoc(sink);
            return (Void)super.scan(tree, sink);
        }

        private void scanJavadoc(SymbolSink sink) {
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), commentTree), sink);
        }

        final class DocTreeSymbolScanner
        extends DocTreePathScanner<Void, SymbolSink> {
            DocTreeSymbolScanner() {
            }

            @Override
            public Void visitReference(ReferenceTree referenceTree, final SymbolSink sink) {
                Symbol symbolForReference = (Symbol)TreeSymbolScanner.this.trees.getElement(this.getCurrentPath());
                JCTree base = ((DCTree.DCReference)referenceTree).qualifierExpression;
                while (base instanceof JCTree.JCFieldAccess) {
                    base = ((JCTree.JCFieldAccess)base).selected;
                }
                if (base instanceof JCTree.JCIdent) {
                    sink.accept(((JCTree.JCIdent)base).sym);
                }
                if (symbolForReference instanceof Symbol.MethodSymbol) {
                    for (Symbol.VarSymbol parameter : ((Symbol.MethodSymbol)symbolForReference).getParameters()) {
                        parameter.type.accept(new Types.SimpleVisitor<Void, Void>(){

                            @Override
                            public Void visitArrayType(Type.ArrayType type, Void unused) {
                                type.getComponentType().accept(this, null);
                                return null;
                            }

                            @Override
                            public Void visitType(Type type, Void unused) {
                                sink.accept(TreeSymbolScanner.this.types.erasure((Type)type).tsym);
                                return null;
                            }
                        }, null);
                    }
                }
                return null;
            }
        }
    }

    private static interface SymbolSink {
        public boolean keepScanning();

        public void accept(Symbol var1);
    }
}

