/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZipFileIndexCache {
    private final Map<File, ZipFileIndex> map = new HashMap<File, ZipFileIndex>();
    private static ZipFileIndexCache sharedInstance;

    public static synchronized ZipFileIndexCache getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ZipFileIndexCache();
        }
        return sharedInstance;
    }

    public static ZipFileIndexCache instance(Context context) {
        ZipFileIndexCache zipFileIndexCache = context.get(ZipFileIndexCache.class);
        if (zipFileIndexCache == null) {
            zipFileIndexCache = new ZipFileIndexCache();
            context.put(ZipFileIndexCache.class, zipFileIndexCache);
        }
        return zipFileIndexCache;
    }

    public List<ZipFileIndex> getZipFileIndexes() {
        return this.getZipFileIndexes(false);
    }

    public synchronized List<ZipFileIndex> getZipFileIndexes(boolean bl) {
        ArrayList<ZipFileIndex> arrayList = new ArrayList<ZipFileIndex>();
        arrayList.addAll(this.map.values());
        if (bl) {
            for (ZipFileIndex zipFileIndex : arrayList) {
                if (zipFileIndex.isOpen()) continue;
                arrayList.remove(zipFileIndex);
            }
        }
        return arrayList;
    }

    public synchronized ZipFileIndex getZipFileIndex(File file, RelativePath.RelativeDirectory relativeDirectory, boolean bl, String string, boolean bl2) throws IOException {
        ZipFileIndex zipFileIndex = this.getExistingZipIndex(file);
        if (zipFileIndex == null || zipFileIndex != null && file.lastModified() != zipFileIndex.zipFileLastModified) {
            zipFileIndex = new ZipFileIndex(file, relativeDirectory, bl2, bl, string);
            this.map.put(file, zipFileIndex);
        }
        return zipFileIndex;
    }

    public synchronized ZipFileIndex getExistingZipIndex(File file) {
        return this.map.get(file);
    }

    public synchronized void clearCache() {
        this.map.clear();
    }

    public synchronized void clearCache(long l) {
        for (File file : this.map.keySet()) {
            long l2;
            ZipFileIndex zipFileIndex = this.map.get(file);
            if (zipFileIndex == null || (l2 = zipFileIndex.lastReferenceTimeStamp + l) >= zipFileIndex.lastReferenceTimeStamp && System.currentTimeMillis() <= l2) continue;
            this.map.remove(file);
        }
    }

    public synchronized void removeFromCache(File file) {
        this.map.remove(file);
    }

    public synchronized void setOpenedIndexes(List<ZipFileIndex> list) throws IllegalStateException {
        if (this.map.isEmpty()) {
            String string = "Setting opened indexes should be called only when the ZipFileCache is empty. Call JavacFileManager.flush() before calling this method.";
            throw new IllegalStateException(string);
        }
        for (ZipFileIndex zipFileIndex : list) {
            this.map.put(zipFileIndex.zipFile, zipFileIndex);
        }
    }
}

