/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;

public class SymbolMetadata {
    private static final List<Attribute.Compound> DECL_NOT_STARTED = List.of(null);
    private static final List<Attribute.Compound> DECL_IN_PROGRESS = List.of(null);
    private List<Attribute.Compound> attributes = DECL_NOT_STARTED;
    private List<Attribute.TypeCompound> type_attributes = List.nil();
    private List<Attribute.TypeCompound> init_type_attributes = List.nil();
    private List<Attribute.TypeCompound> clinit_type_attributes = List.nil();
    private final Symbol sym;

    public SymbolMetadata(Symbol symbol) {
        this.sym = symbol;
    }

    public List<Attribute.Compound> getDeclarationAttributes() {
        return this.filterDeclSentinels(this.attributes);
    }

    public List<Attribute.TypeCompound> getTypeAttributes() {
        return this.type_attributes;
    }

    public List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.init_type_attributes;
    }

    public List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.clinit_type_attributes;
    }

    public void setDeclarationAttributes(List<Attribute.Compound> list) {
        Assert.check(this.pendingCompletion() || !this.isStarted());
        if (list == null) {
            throw new NullPointerException();
        }
        this.attributes = list;
    }

    public void setTypeAttributes(List<Attribute.TypeCompound> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.type_attributes = list;
    }

    public void setInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.init_type_attributes = list;
    }

    public void setClassInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.clinit_type_attributes = list;
    }

    public void setAttributes(SymbolMetadata symbolMetadata) {
        if (symbolMetadata == null) {
            throw new NullPointerException();
        }
        this.setDeclarationAttributes(symbolMetadata.getDeclarationAttributes());
        this.setTypeAttributes(symbolMetadata.getTypeAttributes());
        this.setInitTypeAttributes(symbolMetadata.getInitTypeAttributes());
        this.setClassInitTypeAttributes(symbolMetadata.getClassInitTypeAttributes());
    }

    public SymbolMetadata reset() {
        this.attributes = DECL_IN_PROGRESS;
        return this;
    }

    public boolean isEmpty() {
        return !this.isStarted() || this.pendingCompletion() || this.attributes.isEmpty();
    }

    public boolean isTypesEmpty() {
        return this.type_attributes.isEmpty();
    }

    public boolean pendingCompletion() {
        return this.attributes == DECL_IN_PROGRESS;
    }

    public SymbolMetadata append(List<Attribute.Compound> list) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!list.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? list : this.attributes.appendList(list);
        }
        return this;
    }

    public SymbolMetadata appendUniqueTypes(List<Attribute.TypeCompound> list) {
        if (!list.isEmpty()) {
            if (this.type_attributes.isEmpty()) {
                this.type_attributes = list;
            } else {
                for (Attribute.TypeCompound typeCompound : list) {
                    if (this.type_attributes.contains(typeCompound)) continue;
                    this.type_attributes = this.type_attributes.append(typeCompound);
                }
            }
        }
        return this;
    }

    public SymbolMetadata appendInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (!list.isEmpty()) {
            this.init_type_attributes = this.init_type_attributes.isEmpty() ? list : this.init_type_attributes.appendList(list);
        }
        return this;
    }

    public SymbolMetadata appendClassInitTypeAttributes(List<Attribute.TypeCompound> list) {
        if (!list.isEmpty()) {
            this.clinit_type_attributes = this.clinit_type_attributes.isEmpty() ? list : this.clinit_type_attributes.appendList(list);
        }
        return this;
    }

    public SymbolMetadata prepend(List<Attribute.Compound> list) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!list.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? list : this.attributes.prependList(list);
        }
        return this;
    }

    private List<Attribute.Compound> filterDeclSentinels(List<Attribute.Compound> list) {
        return list == DECL_IN_PROGRESS || list == DECL_NOT_STARTED ? List.nil() : list;
    }

    private boolean isStarted() {
        return this.attributes != DECL_NOT_STARTED;
    }
}

