/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class ClientCodeWrapper {
    Map<Class<?>, Boolean> trustedClasses = new HashMap();

    public static ClientCodeWrapper instance(Context context) {
        ClientCodeWrapper clientCodeWrapper = context.get(ClientCodeWrapper.class);
        if (clientCodeWrapper == null) {
            clientCodeWrapper = new ClientCodeWrapper(context);
        }
        return clientCodeWrapper;
    }

    protected ClientCodeWrapper(Context context) {
    }

    public JavaFileManager wrap(JavaFileManager javaFileManager) {
        if (this.isTrusted(javaFileManager)) {
            return javaFileManager;
        }
        return new WrappedJavaFileManager(javaFileManager);
    }

    public FileObject wrap(FileObject fileObject) {
        if (this.isTrusted(fileObject)) {
            return fileObject;
        }
        return new WrappedFileObject(fileObject);
    }

    FileObject unwrap(FileObject fileObject) {
        if (fileObject instanceof WrappedFileObject) {
            return ((WrappedFileObject)fileObject).clientFileObject;
        }
        return fileObject;
    }

    public JavaFileObject wrap(JavaFileObject javaFileObject) {
        if (this.isTrusted(javaFileObject)) {
            return javaFileObject;
        }
        return new WrappedJavaFileObject(javaFileObject);
    }

    public Iterable<JavaFileObject> wrapJavaFileObjects(Iterable<? extends JavaFileObject> iterable) {
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        for (JavaFileObject javaFileObject : iterable) {
            arrayList.add(this.wrap(javaFileObject));
        }
        return Collections.unmodifiableList(arrayList);
    }

    JavaFileObject unwrap(JavaFileObject javaFileObject) {
        if (javaFileObject instanceof WrappedJavaFileObject) {
            return (JavaFileObject)((WrappedJavaFileObject)javaFileObject).clientFileObject;
        }
        return javaFileObject;
    }

    public <T> DiagnosticListener<T> wrap(DiagnosticListener<T> diagnosticListener) {
        if (this.isTrusted(diagnosticListener)) {
            return diagnosticListener;
        }
        return new WrappedDiagnosticListener<T>(diagnosticListener);
    }

    TaskListener wrap(TaskListener taskListener) {
        if (this.isTrusted(taskListener)) {
            return taskListener;
        }
        return new WrappedTaskListener(taskListener);
    }

    TaskListener unwrap(TaskListener taskListener) {
        if (taskListener instanceof WrappedTaskListener) {
            return ((WrappedTaskListener)taskListener).clientTaskListener;
        }
        return taskListener;
    }

    Collection<TaskListener> unwrap(Collection<? extends TaskListener> collection) {
        ArrayList<TaskListener> arrayList = new ArrayList<TaskListener>(collection.size());
        for (TaskListener taskListener : collection) {
            arrayList.add(this.unwrap(taskListener));
        }
        return arrayList;
    }

    private <T> Diagnostic<T> unwrap(Diagnostic<T> diagnostic) {
        if (diagnostic instanceof JCDiagnostic) {
            JCDiagnostic jCDiagnostic = (JCDiagnostic)diagnostic;
            return new DiagnosticSourceUnwrapper(jCDiagnostic);
        }
        return diagnostic;
    }

    protected boolean isTrusted(Object object) {
        Class<?> clazz = object.getClass();
        Boolean bl = this.trustedClasses.get(clazz);
        if (bl == null) {
            bl = clazz.getName().startsWith("com.sun.tools.javac.") || clazz.isAnnotationPresent(Trusted.class);
            this.trustedClasses.put(clazz, bl);
        }
        return bl;
    }

    private String wrappedToString(Class<?> clazz, Object object) {
        return clazz.getSimpleName() + "[" + object + "]";
    }

    protected class WrappedTaskListener
    implements TaskListener {
        protected TaskListener clientTaskListener;

        WrappedTaskListener(TaskListener taskListener) {
            taskListener.getClass();
            this.clientTaskListener = taskListener;
        }

        @Override
        public void started(TaskEvent taskEvent) {
            try {
                this.clientTaskListener.started(taskEvent);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public void finished(TaskEvent taskEvent) {
            try {
                this.clientTaskListener.finished(taskEvent);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientTaskListener);
        }
    }

    public class DiagnosticSourceUnwrapper
    implements Diagnostic<JavaFileObject> {
        public final JCDiagnostic d;

        DiagnosticSourceUnwrapper(JCDiagnostic jCDiagnostic) {
            this.d = jCDiagnostic;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.d.getKind();
        }

        @Override
        public JavaFileObject getSource() {
            return ClientCodeWrapper.this.unwrap(this.d.getSource());
        }

        @Override
        public long getPosition() {
            return this.d.getPosition();
        }

        @Override
        public long getStartPosition() {
            return this.d.getStartPosition();
        }

        @Override
        public long getEndPosition() {
            return this.d.getEndPosition();
        }

        @Override
        public long getLineNumber() {
            return this.d.getLineNumber();
        }

        @Override
        public long getColumnNumber() {
            return this.d.getColumnNumber();
        }

        @Override
        public String getCode() {
            return this.d.getCode();
        }

        @Override
        public String getMessage(Locale locale) {
            return this.d.getMessage(locale);
        }

        public String toString() {
            return this.d.toString();
        }
    }

    protected class WrappedDiagnosticListener<T>
    implements DiagnosticListener<T> {
        protected DiagnosticListener<T> clientDiagnosticListener;

        WrappedDiagnosticListener(DiagnosticListener<T> diagnosticListener) {
            diagnosticListener.getClass();
            this.clientDiagnosticListener = diagnosticListener;
        }

        @Override
        public void report(Diagnostic<? extends T> diagnostic) {
            try {
                this.clientDiagnosticListener.report(ClientCodeWrapper.this.unwrap(diagnostic));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientDiagnosticListener);
        }
    }

    protected class WrappedJavaFileObject
    extends WrappedFileObject
    implements JavaFileObject {
        WrappedJavaFileObject(JavaFileObject javaFileObject) {
            super(javaFileObject);
        }

        @Override
        public JavaFileObject.Kind getKind() {
            try {
                return ((JavaFileObject)this.clientFileObject).getKind();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            try {
                return ((JavaFileObject)this.clientFileObject).isNameCompatible(string, kind);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public NestingKind getNestingKind() {
            try {
                return ((JavaFileObject)this.clientFileObject).getNestingKind();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public Modifier getAccessLevel() {
            try {
                return ((JavaFileObject)this.clientFileObject).getAccessLevel();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientFileObject);
        }
    }

    protected class WrappedFileObject
    implements FileObject {
        protected FileObject clientFileObject;

        WrappedFileObject(FileObject fileObject) {
            fileObject.getClass();
            this.clientFileObject = fileObject;
        }

        @Override
        public URI toUri() {
            try {
                return this.clientFileObject.toUri();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public String getName() {
            try {
                return this.clientFileObject.getName();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            try {
                return this.clientFileObject.openInputStream();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            try {
                return this.clientFileObject.openOutputStream();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public Reader openReader(boolean bl) throws IOException {
            try {
                return this.clientFileObject.openReader(bl);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public CharSequence getCharContent(boolean bl) throws IOException {
            try {
                return this.clientFileObject.getCharContent(bl);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public Writer openWriter() throws IOException {
            try {
                return this.clientFileObject.openWriter();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public long getLastModified() {
            try {
                return this.clientFileObject.getLastModified();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public boolean delete() {
            try {
                return this.clientFileObject.delete();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientFileObject);
        }
    }

    protected class WrappedJavaFileManager
    implements JavaFileManager {
        protected JavaFileManager clientJavaFileManager;

        WrappedJavaFileManager(JavaFileManager javaFileManager) {
            javaFileManager.getClass();
            this.clientJavaFileManager = javaFileManager;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            try {
                return this.clientJavaFileManager.getClassLoader(location);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
            try {
                return ClientCodeWrapper.this.wrapJavaFileObjects(this.clientJavaFileManager.list(location, string, set, bl));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
            try {
                return this.clientJavaFileManager.inferBinaryName(location, ClientCodeWrapper.this.unwrap(javaFileObject));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
            try {
                return this.clientJavaFileManager.isSameFile(ClientCodeWrapper.this.unwrap(fileObject), ClientCodeWrapper.this.unwrap(fileObject2));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public boolean handleOption(String string, Iterator<String> iterator) {
            try {
                return this.clientJavaFileManager.handleOption(string, iterator);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            try {
                return this.clientJavaFileManager.hasLocation(location);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getJavaFileForInput(location, string, kind));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getJavaFileForOutput(location, string, kind, ClientCodeWrapper.this.unwrap(fileObject)));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getFileForInput(location, string, string2));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getFileForOutput(location, string, string2, ClientCodeWrapper.this.unwrap(fileObject)));
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.clientJavaFileManager.flush();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.clientJavaFileManager.close();
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        @Override
        public int isSupportedOption(String string) {
            try {
                return this.clientJavaFileManager.isSupportedOption(string);
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Error | RuntimeException throwable) {
                throw new ClientCodeException(throwable);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientJavaFileManager);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Trusted {
    }
}

