/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.operation.ClearNearCacheOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapClearNearCacheRequest
extends TargetClientRequest
implements Portable,
SecureRequest {
    private String name;
    private Address target;

    public MapClearNearCacheRequest() {
    }

    public MapClearNearCacheRequest(String name, Address target) {
        this.name = name;
        this.target = target;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 53;
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected Operation prepareOperation() {
        return new ClearNearCacheOperation(this.name);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.operationService.createInvocationBuilder(this.getServiceName(), op, this.target);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        this.target.writeData(writer.getRawDataOutput());
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.target = new Address();
        this.target.readData(reader.getRawDataInput());
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "remove");
    }
}

