/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.bugpatterns.inject.dagger.Util;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(name="UseBinds", summary="@Binds is a more efficient and declarative mechanism for delegating a binding.", explanation="A @Provides or @Produces method that returns its single parameter has long been Dagger's only mechanism for delegating a binding. Since the delegation is implemented via a user-defined method there is a disproportionate amount of overhead for such a conceptually simple operation. @Binds was introduced to provide a declarative way of delegating from one binding to another in a way that allows for minimal overhead in the implementation. @Binds should always be preferred over @Provides or @Produces for delegation.", category=BugPattern.Category.DAGGER, severity=BugPattern.SeverityLevel.SUGGESTION)
public class UseBinds
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> SIMPLE_METHOD = new Matcher<MethodTree>(){

        public boolean matches(MethodTree t, VisitorState state) {
            List<? extends VariableTree> parameters = t.getParameters();
            if (parameters.size() != 1) {
                return false;
            }
            VariableTree onlyParameter = (VariableTree)Iterables.getOnlyElement(parameters);
            BlockTree body = t.getBody();
            if (body == null) {
                return false;
            }
            List<? extends StatementTree> statements = body.getStatements();
            if (statements.size() != 1) {
                return false;
            }
            StatementTree onlyStatement = (StatementTree)Iterables.getOnlyElement(statements);
            if (!onlyStatement.getKind().equals((Object)Tree.Kind.RETURN)) {
                return false;
            }
            Symbol returnedSymbol = ASTHelpers.getSymbol((Tree)((ReturnTree)onlyStatement).getExpression());
            if (returnedSymbol == null) {
                return false;
            }
            return ASTHelpers.getSymbol((VariableTree)onlyParameter).equals(returnedSymbol);
        }
    };
    private static final Matcher<MethodTree> CAN_BE_A_BINDS_METHOD = Matchers.allOf((Matcher[])new Matcher[]{DaggerAnnotations.isBindingMethod(), SIMPLE_METHOD});

    public Description matchMethod(MethodTree method, VisitorState state) {
        if (!CAN_BE_A_BINDS_METHOD.matches((Tree)method, state)) {
            return Description.NO_MATCH;
        }
        JCTree.JCClassDecl enclosingClass = (JCTree.JCClassDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCClassDecl.class);
        if (!Util.IS_DAGGER_2_MODULE.matches((Tree)enclosingClass, state)) {
            return Description.NO_MATCH;
        }
        if (enclosingClass.getExtendsClause() != null) {
            return this.fixByDelegating();
        }
        for (Tree member : enclosingClass.getMembers()) {
            MethodTree siblingMethod;
            Set<Modifier> siblingFlags;
            if (!member.getKind().equals((Object)Tree.Kind.METHOD) || ASTHelpers.getSymbol((Tree)member).isConstructor() || (siblingFlags = (siblingMethod = (MethodTree)member).getModifiers().getFlags()).contains((Object)Modifier.STATIC) || siblingFlags.contains((Object)Modifier.ABSTRACT) || CAN_BE_A_BINDS_METHOD.matches((Tree)siblingMethod, state)) continue;
            return this.fixByDelegating();
        }
        return this.fixByModifyingMethod(state, enclosingClass, method);
    }

    private Description fixByModifyingMethod(VisitorState state, JCTree.JCClassDecl enclosingClass, MethodTree method) {
        return this.describeMatch(method, (Fix)SuggestedFix.builder().addImport("dagger.Binds").merge(this.convertMethodToBinds(method, state)).merge(Util.makeConcreteClassAbstract(enclosingClass, state)).build());
    }

    private SuggestedFix.Builder convertMethodToBinds(MethodTree method, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        JCTree.JCModifiers modifiers = ((JCTree.JCMethodDecl)method).getModifiers();
        ImmutableList.Builder modifierStringsBuilder = new ImmutableList.Builder().add((Object)"@Binds");
        for (JCTree.JCAnnotation annotation : modifiers.annotations) {
            Name annotationQualifiedName = ASTHelpers.getSymbol((Tree)annotation).getQualifiedName();
            if (annotationQualifiedName.contentEquals("dagger.Provides") || annotationQualifiedName.contentEquals("dagger.producers.Produces")) {
                String typeName;
                List arguments = annotation.getArguments();
                if (arguments.isEmpty()) continue;
                JCTree.JCExpression argument = (JCTree.JCExpression)Iterables.getOnlyElement((Iterable)arguments);
                Preconditions.checkState((boolean)argument.getKind().equals((Object)Tree.Kind.ASSIGNMENT));
                JCTree.JCAssign assignment = (JCTree.JCAssign)argument;
                Preconditions.checkState((boolean)ASTHelpers.getSymbol((Tree)assignment.getVariable()).getSimpleName().contentEquals("type"));
                switch (typeName = ASTHelpers.getSymbol((Tree)assignment.getExpression()).getSimpleName().toString()) {
                    case "SET": {
                        modifierStringsBuilder.add((Object)"@IntoSet");
                        fix.addImport("dagger.multibindings.IntoSet");
                        break;
                    }
                    case "SET_VALUES": {
                        modifierStringsBuilder.add((Object)"@ElementsIntoSet");
                        fix.addImport("dagger.multibindings.ElementsIntoSet");
                        break;
                    }
                    case "MAP": {
                        modifierStringsBuilder.add((Object)"@IntoMap");
                        fix.addImport("dagger.multibindings.IntoMap");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown type name: " + typeName));
                    }
                }
                continue;
            }
            modifierStringsBuilder.add((Object)state.getSourceForNode((Tree)annotation));
        }
        EnumSet<Flags.Flag> methodFlags = Flags.asFlagSet(modifiers.flags);
        methodFlags.remove((Object)Flags.Flag.STATIC);
        methodFlags.remove((Object)Flags.Flag.FINAL);
        methodFlags.add(Flags.Flag.ABSTRACT);
        for (Flags.Flag flag : methodFlags) {
            modifierStringsBuilder.add((Object)flag.toString());
        }
        fix.replace((Tree)modifiers, Joiner.on((char)' ').join((Iterable)modifierStringsBuilder.build()));
        fix.replace((Tree)method.getBody(), ";");
        return fix;
    }

    private Description fixByDelegating() {
        return Description.NO_MATCH;
    }
}

