/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeGenerator;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.Platform;
import com.google.common.collect.testing.TestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.FeatureUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtIncompatible
public abstract class PerCollectionSizeTestSuiteBuilder<B extends PerCollectionSizeTestSuiteBuilder<B, G, T, E>, G extends TestContainerGenerator<T, E>, T, E>
extends FeatureSpecificTestSuiteBuilder<B, G> {
    private static final Logger logger = Logger.getLogger(PerCollectionSizeTestSuiteBuilder.class.getName());

    @Override
    public TestSuite createTestSuite() {
        this.checkCanCreate();
        String name = this.getName();
        Set<Feature<Feature<?>>> features = Helpers.copyToSet(this.getFeatures());
        List<Class<? extends AbstractTester>> testers = this.getTesters();
        logger.fine(" Testing: " + name);
        Set<Feature<Feature<Feature<?>>>> sizesToTest = Helpers.copyToSet(CollectionSize.values());
        sizesToTest.retainAll(features);
        features.removeAll(sizesToTest);
        FeatureUtil.addImpliedFeatures(sizesToTest);
        sizesToTest.retainAll(Arrays.asList(CollectionSize.ZERO, CollectionSize.ONE, CollectionSize.SEVERAL));
        logger.fine("   Sizes: " + PerCollectionSizeTestSuiteBuilder.formatFeatureSet(sizesToTest));
        if (sizesToTest.isEmpty()) {
            throw new IllegalStateException(name + ": no CollectionSizes specified (check the argument to " + "FeatureSpecificTestSuiteBuilder.withFeatures().)");
        }
        TestSuite suite = new TestSuite(name);
        for (Feature<?> feature : sizesToTest) {
            String oneSizeName = Platform.format("%s [collection size: %s]", name, feature.toString().toLowerCase());
            OneSizeGenerator oneSizeGenerator = new OneSizeGenerator((TestContainerGenerator)this.getSubjectGenerator(), (CollectionSize)feature);
            Set<Feature<?>> oneSizeFeatures = Helpers.copyToSet(features);
            oneSizeFeatures.add(feature);
            Set<Method> oneSizeSuppressedTests = this.getSuppressedTests();
            OneSizeTestSuiteBuilder oneSizeBuilder = (OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)new OneSizeTestSuiteBuilder(testers).named(oneSizeName)).usingGenerator(oneSizeGenerator)).withFeatures(oneSizeFeatures)).withSetUp(this.getSetUp())).withTearDown(this.getTearDown())).suppressing(oneSizeSuppressedTests);
            TestSuite oneSizeSuite = oneSizeBuilder.createTestSuite();
            suite.addTest((Test)oneSizeSuite);
            for (TestSuite derivedSuite : this.createDerivedSuites(oneSizeBuilder)) {
                oneSizeSuite.addTest((Test)derivedSuite);
            }
        }
        return suite;
    }

    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<T, E>> parentBuilder) {
        return new ArrayList<TestSuite>();
    }

    private static final class OneSizeTestSuiteBuilder<T, E>
    extends FeatureSpecificTestSuiteBuilder<OneSizeTestSuiteBuilder<T, E>, OneSizeGenerator<T, E>> {
        private final List<Class<? extends AbstractTester>> testers;

        public OneSizeTestSuiteBuilder(List<Class<? extends AbstractTester>> testers) {
            this.testers = testers;
        }

        @Override
        protected List<Class<? extends AbstractTester>> getTesters() {
            return this.testers;
        }
    }
}

