/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.model.Const;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConstantPool {
    short nextEntry = 1;
    private final Map<String, Short> utf8Pool = new HashMap<String, Short>();
    private final Map<Short, Short> classInfoPool = new HashMap<Short, Short>();
    private final Map<Short, Short> stringPool = new HashMap<Short, Short>();
    private final Map<Integer, Short> integerPool = new HashMap<Integer, Short>();
    private final Map<Double, Short> doublePool = new HashMap<Double, Short>();
    private final Map<Float, Short> floatPool = new HashMap<Float, Short>();
    private final Map<Long, Short> longPool = new HashMap<Long, Short>();
    private final List<Entry> constants = new ArrayList<Entry>();

    public ImmutableList<Entry> constants() {
        return ImmutableList.copyOf(this.constants);
    }

    private static short width(Kind kind) {
        switch (kind) {
            case CLASS_INFO: 
            case STRING: 
            case INTEGER: 
            case UTF8: 
            case FLOAT: {
                return 1;
            }
            case LONG: 
            case DOUBLE: {
                return 2;
            }
        }
        throw new AssertionError((Object)kind);
    }

    short classInfo(String value) {
        Objects.requireNonNull(value);
        short utf8 = this.utf8(value);
        if (this.classInfoPool.containsKey(utf8)) {
            return this.classInfoPool.get(utf8);
        }
        short index = this.insert(new Entry(Kind.CLASS_INFO, new Const.ShortValue(utf8)));
        this.classInfoPool.put(utf8, index);
        return index;
    }

    short utf8(String value) {
        Objects.requireNonNull(value);
        if (this.utf8Pool.containsKey(value)) {
            return this.utf8Pool.get(value);
        }
        short index = this.insert(new Entry(Kind.UTF8, new Const.StringValue(value)));
        this.utf8Pool.put(value, index);
        return index;
    }

    short integer(int value) {
        if (this.integerPool.containsKey(value)) {
            return this.integerPool.get(value);
        }
        short index = this.insert(new Entry(Kind.INTEGER, new Const.IntValue(value)));
        this.integerPool.put(value, index);
        return index;
    }

    short longInfo(long value) {
        if (this.longPool.containsKey(value)) {
            return this.longPool.get(value);
        }
        short index = this.insert(new Entry(Kind.LONG, new Const.LongValue(value)));
        this.longPool.put(value, index);
        return index;
    }

    short doubleInfo(double value) {
        if (this.doublePool.containsKey(value)) {
            return this.doublePool.get(value);
        }
        short index = this.insert(new Entry(Kind.DOUBLE, new Const.DoubleValue(value)));
        this.doublePool.put(value, index);
        return index;
    }

    short floatInfo(float value) {
        if (this.floatPool.containsKey(Float.valueOf(value))) {
            return this.floatPool.get(Float.valueOf(value));
        }
        short index = this.insert(new Entry(Kind.FLOAT, new Const.FloatValue(value)));
        this.floatPool.put(Float.valueOf(value), index);
        return index;
    }

    short string(String value) {
        Objects.requireNonNull(value);
        short utf8 = this.utf8(value);
        if (this.stringPool.containsKey(utf8)) {
            return this.stringPool.get(utf8);
        }
        short index = this.insert(new Entry(Kind.STRING, new Const.ShortValue(utf8)));
        this.stringPool.put(utf8, index);
        return index;
    }

    private short insert(Entry key) {
        short entry = this.nextEntry;
        this.constants.add(key);
        this.nextEntry = (short)(this.nextEntry + ConstantPool.width(key.kind()));
        return entry;
    }

    static enum Kind {
        CLASS_INFO(7),
        STRING(8),
        INTEGER(3),
        DOUBLE(6),
        FLOAT(4),
        LONG(5),
        UTF8(1);

        private final short tag;

        private Kind(int tag) {
            this.tag = (short)tag;
        }

        public short tag() {
            return this.tag;
        }
    }

    static class Entry {
        private final Kind kind;
        private final Const.Value value;

        Entry(Kind kind, Const.Value value) {
            this.kind = kind;
            this.value = value;
        }

        public Kind kind() {
            return this.kind;
        }

        public Const.Value value() {
            return this.value;
        }
    }
}

