/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.sym.ClassSymbol;

public interface ImportScope {
    public LookupResult lookup(LookupKey var1, ResolveFunction var2);

    default public ImportScope append(final ImportScope next) {
        return new ImportScope(){

            @Override
            public LookupResult lookup(LookupKey lookupKey, ResolveFunction resolve) {
                LookupResult result = next.lookup(lookupKey, resolve);
                if (result != null) {
                    return result;
                }
                return ImportScope.this.lookup(lookupKey, resolve);
            }
        };
    }

    public static ImportScope fromScope(final Scope scope) {
        return new ImportScope(){

            @Override
            public LookupResult lookup(LookupKey lookupKey, ResolveFunction resolve) {
                return scope.lookup(lookupKey);
            }
        };
    }

    default public CompoundScope toScope(final ResolveFunction resolve) {
        return CompoundScope.base(new Scope(){

            @Override
            public LookupResult lookup(LookupKey lookupKey) {
                return ImportScope.this.lookup(lookupKey, resolve);
            }
        });
    }

    @FunctionalInterface
    public static interface ResolveFunction {
        public ClassSymbol resolveOne(ClassSymbol var1, String var2);

        default public ClassSymbol resolve(LookupResult result) {
            ClassSymbol sym = (ClassSymbol)result.sym();
            for (String bit : result.remaining()) {
                if ((sym = this.resolveOne(sym, bit)) != null) continue;
                return null;
            }
            return sym;
        }
    }
}

