/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyVariableNamer;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.TypeNames;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

class SourceFiles {
    private static final Joiner CLASS_FILE_NAME_JOINER = Joiner.on((char)'_');
    static final Ordering<DependencyRequest> DEPENDENCY_ORDERING = new Ordering<DependencyRequest>(){

        public int compare(DependencyRequest left, DependencyRequest right) {
            return ComparisonChain.start().compare((Comparable)((Object)left.requestElement().getKind()), (Comparable)((Object)right.requestElement().getKind())).compare((Comparable)((Object)left.kind()), (Comparable)((Object)right.kind())).compare((Comparable)((Object)left.requestElement().getSimpleName().toString()), (Comparable)((Object)right.requestElement().getSimpleName().toString())).result();
        }
    };

    static ImmutableMap<BindingKey, FrameworkField> generateBindingFieldsForDependencies(Binding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"binding must be unresolved: %s", (Object[])new Object[]{binding});
        ImmutableMap.Builder bindingFields = ImmutableMap.builder();
        for (FrameworkDependency frameworkDependency : FrameworkDependency.frameworkDependenciesForBinding(binding)) {
            bindingFields.put((Object)frameworkDependency.bindingKey(), (Object)FrameworkField.create(ClassName.get(frameworkDependency.frameworkClass()), TypeName.get(frameworkDependency.bindingKey().key().type()), SourceFiles.fieldNameForDependency(frameworkDependency)));
        }
        return bindingFields.build();
    }

    private static String fieldNameForDependency(FrameworkDependency frameworkDependency) {
        ImmutableSet dependencyNames = FluentIterable.from(frameworkDependency.dependencyRequests()).transform((Function)new DependencyVariableNamer()).toSet();
        if (dependencyNames.size() == 1) {
            return (String)Iterables.getOnlyElement((Iterable)dependencyNames);
        }
        UnmodifiableIterator namesIterator = dependencyNames.iterator();
        String first = (String)namesIterator.next();
        StringBuilder compositeNameBuilder = new StringBuilder(first);
        while (namesIterator.hasNext()) {
            compositeNameBuilder.append("And").append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, (String)namesIterator.next()));
        }
        return compositeNameBuilder.toString();
    }

    static CodeBlock frameworkTypeUsageStatement(CodeBlock frameworkTypeMemberSelect, DependencyRequest.Kind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return CodeBlock.of("$T.lazy($L)", TypeNames.DOUBLE_CHECK, frameworkTypeMemberSelect);
            }
            case INSTANCE: 
            case FUTURE: {
                return CodeBlock.of("$L.get()", frameworkTypeMemberSelect);
            }
            case PROVIDER: 
            case PRODUCER: 
            case MEMBERS_INJECTOR: {
                return CodeBlock.of("$L", frameworkTypeMemberSelect);
            }
            case PROVIDER_OF_LAZY: {
                return CodeBlock.of("$T.create($L)", TypeNames.PROVIDER_OF_LAZY, frameworkTypeMemberSelect);
            }
        }
        throw new AssertionError();
    }

    static ClassName generatedClassNameForBinding(Binding binding) {
        switch (binding.bindingType()) {
            case PROVISION: 
            case PRODUCTION: {
                ContributionBinding contribution = (ContributionBinding)binding;
                Preconditions.checkArgument((!contribution.isSyntheticBinding() ? 1 : 0) != 0);
                ClassName enclosingClassName = ClassName.get(contribution.bindingTypeElement());
                switch (contribution.bindingKind()) {
                    case INJECTION: 
                    case PROVISION: 
                    case IMMEDIATE: 
                    case FUTURE_PRODUCTION: {
                        String string = SourceFiles.classFileName(enclosingClassName);
                        String string2 = SourceFiles.factoryPrefix(contribution);
                        return enclosingClassName.topLevelClassName().peerClass(new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).append("Factory").toString());
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return SourceFiles.membersInjectorNameForType(((MembersInjectionBinding)binding).membersInjectedType());
            }
        }
        throw new AssertionError();
    }

    static TypeName parameterizedGeneratedTypeNameForBinding(Binding binding) {
        ClassName className = SourceFiles.generatedClassNameForBinding(binding);
        ImmutableList<TypeName> typeParameters = SourceFiles.bindingTypeParameters(binding);
        if (typeParameters.isEmpty()) {
            return className;
        }
        return ParameterizedTypeName.get(className, (TypeName[])FluentIterable.from(typeParameters).toArray(TypeName.class));
    }

    private static Optional<TypeMirror> typeMirrorForBindingTypeParameters(Binding binding) throws AssertionError {
        switch (binding.bindingType()) {
            case PROVISION: 
            case PRODUCTION: {
                ContributionBinding contributionBinding = (ContributionBinding)binding;
                switch (contributionBinding.bindingKind()) {
                    case INJECTION: {
                        return Optional.of((Object)contributionBinding.key().type());
                    }
                    case PROVISION: {
                        return Optional.of((Object)contributionBinding.bindingTypeElement().asType());
                    }
                    case IMMEDIATE: 
                    case FUTURE_PRODUCTION: {
                        throw new UnsupportedOperationException();
                    }
                }
                return Optional.absent();
            }
            case MEMBERS_INJECTION: {
                return Optional.of((Object)binding.key().type());
            }
        }
        throw new AssertionError();
    }

    static ImmutableList<TypeName> bindingTypeParameters(Binding binding) {
        Optional<TypeMirror> typeMirror = SourceFiles.typeMirrorForBindingTypeParameters(binding);
        if (!typeMirror.isPresent()) {
            return ImmutableList.of();
        }
        TypeName bindingTypeName = TypeName.get((TypeMirror)typeMirror.get());
        return bindingTypeName instanceof ParameterizedTypeName ? ImmutableList.copyOf(((ParameterizedTypeName)bindingTypeName).typeArguments) : ImmutableList.of();
    }

    static ClassName membersInjectorNameForType(TypeElement typeElement) {
        return SourceFiles.siblingClassName(typeElement, "_MembersInjector");
    }

    static String classFileName(ClassName className) {
        return CLASS_FILE_NAME_JOINER.join(className.simpleNames());
    }

    static ClassName generatedMonitoringModuleName(TypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_MonitoringModule");
    }

    static ClassName generatedProductionExecutorModuleName(TypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_ProductionExecutorModule");
    }

    private static ClassName siblingClassName(TypeElement typeElement, String suffix) {
        ClassName className = ClassName.get(typeElement);
        String string = String.valueOf(SourceFiles.classFileName(className));
        String string2 = String.valueOf(suffix);
        return className.topLevelClassName().peerClass(string2.length() != 0 ? string.concat(string2) : new String(string));
    }

    private static String factoryPrefix(ContributionBinding binding) {
        switch (binding.bindingKind()) {
            case INJECTION: {
                return "";
            }
            case PROVISION: 
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, binding.bindingElement().getSimpleName().toString());
            }
        }
        throw new IllegalArgumentException();
    }

    static ImmutableList<TypeVariableName> bindingTypeElementTypeVariableNames(Binding binding) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeParameterElement typeParameterElement : binding.bindingTypeElement().getTypeParameters()) {
            builder.add((Object)TypeVariableName.get(typeParameterElement));
        }
        return builder.build();
    }

    private SourceFiles() {
    }
}

