/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AutoValue_FrameworkField;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetType;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;

abstract class FrameworkField {
    private static final ElementVisitor<String, Binding> BINDING_ELEMENT_NAME = new ElementKindVisitor6<String, Binding>(){

        @Override
        protected String defaultAction(Element e, Binding p) {
            String string = String.valueOf(p);
            throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Unexpected binding ").append(string).toString());
        }

        @Override
        public String visitExecutableAsConstructor(ExecutableElement e, Binding p) {
            return (String)this.visit(e.getEnclosingElement(), p);
        }

        @Override
        public String visitExecutableAsMethod(ExecutableElement e, Binding p) {
            return e.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement e, Binding p) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
        }
    };

    FrameworkField() {
    }

    static FrameworkField create(ClassName frameworkClassName, TypeName valueTypeName, String fieldName) {
        String string;
        String suffix = frameworkClassName.simpleName();
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(frameworkClassName, valueTypeName);
        if (fieldName.endsWith(suffix)) {
            string = fieldName;
        } else {
            String string2 = String.valueOf(fieldName);
            String string3 = String.valueOf(suffix);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        return new AutoValue_FrameworkField(parameterizedTypeName, string);
    }

    static FrameworkField forResolvedBindings(ResolvedBindings resolvedBindings, Optional<ClassName> frameworkClass) {
        return FrameworkField.create((ClassName)frameworkClass.or((Object)ClassName.get(resolvedBindings.frameworkClass())), TypeName.get(FrameworkField.fieldValueType(resolvedBindings)), FrameworkField.frameworkFieldName(resolvedBindings));
    }

    private static TypeMirror fieldValueType(ResolvedBindings resolvedBindings) {
        if (resolvedBindings.isMultibindingContribution()) {
            switch (resolvedBindings.contributionType()) {
                case MAP: {
                    return MapType.from(resolvedBindings.key()).unwrappedValueType(resolvedBindings.frameworkClass());
                }
                case SET: {
                    return SetType.from(resolvedBindings.key()).elementType();
                }
            }
        }
        return resolvedBindings.key().type();
    }

    private static String frameworkFieldName(ResolvedBindings resolvedBindings) {
        ContributionBinding binding;
        if (resolvedBindings.bindingKey().kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && !(binding = resolvedBindings.contributionBinding()).isSyntheticBinding()) {
            return BINDING_ELEMENT_NAME.visit(binding.bindingElement(), binding);
        }
        return BindingVariableNamer.name(resolvedBindings.binding());
    }

    abstract ParameterizedTypeName type();

    abstract String name();
}

