/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.internal.codegen.AutoValue_FrameworkDependency;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.SourceFiles;
import java.util.Collection;
import javax.lang.model.element.Element;

abstract class FrameworkDependency {
    FrameworkDependency() {
    }

    abstract BindingKey bindingKey();

    abstract Class<?> frameworkClass();

    abstract ImmutableSet<DependencyRequest> dependencyRequests();

    static ImmutableSet<FrameworkDependency> frameworkDependenciesForBinding(Binding binding) {
        DependencyRequestMapper dependencyRequestMapper = DependencyRequestMapper.forBindingType(binding.bindingType());
        ImmutableSet.Builder frameworkDependencies = ImmutableSet.builder();
        for (Collection requests : FrameworkDependency.groupByUnresolvedKey(binding)) {
            frameworkDependencies.add((Object)new AutoValue_FrameworkDependency((BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requests).transform(DependencyRequest.BINDING_KEY_FUNCTION).toSet()), dependencyRequestMapper.getFrameworkClass(requests), (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf((Collection)requests)));
        }
        return frameworkDependencies.build();
    }

    static ImmutableMap<DependencyRequest, FrameworkDependency> indexByDependencyRequest(Iterable<FrameworkDependency> dependencies) {
        ImmutableMap.Builder frameworkDependencyMap = ImmutableMap.builder();
        for (FrameworkDependency dependency : dependencies) {
            for (DependencyRequest request : dependency.dependencyRequests()) {
                frameworkDependencyMap.put((Object)request, (Object)dependency);
            }
        }
        return frameworkDependencyMap.build();
    }

    private static ImmutableList<Collection<DependencyRequest>> groupByUnresolvedKey(Binding binding) {
        if (!binding.unresolved().isPresent()) {
            return FrameworkDependency.groupByKey(binding, (Function<DependencyRequest, DependencyRequest>)Functions.identity());
        }
        final ImmutableMap resolvedDependencies = Maps.uniqueIndex(binding.implicitDependencies(), (Function)new Function<DependencyRequest, Element>(){

            public Element apply(DependencyRequest dependencyRequest) {
                return dependencyRequest.requestElement();
            }
        });
        return FrameworkDependency.groupByKey((Binding)binding.unresolved().get(), new Function<DependencyRequest, DependencyRequest>(){

            public DependencyRequest apply(DependencyRequest unresolvedRequest) {
                return (DependencyRequest)resolvedDependencies.get((Object)unresolvedRequest.requestElement());
            }
        });
    }

    private static ImmutableList<Collection<DependencyRequest>> groupByKey(Binding binding, Function<DependencyRequest, DependencyRequest> transformer) {
        ImmutableSetMultimap.Builder dependenciesByKeyBuilder = ImmutableSetMultimap.builder();
        for (DependencyRequest dependency : binding.implicitDependencies()) {
            dependenciesByKeyBuilder.put((Object)dependency.bindingKey(), transformer.apply((Object)dependency));
        }
        return ImmutableList.copyOf((Collection)dependenciesByKeyBuilder.orderValuesBy(SourceFiles.DEPENDENCY_ORDERING).build().asMap().values());
    }
}

