/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.Types;

final class ConfigurationAnnotations {
    private static final String MODULES_ATTRIBUTE = "modules";
    private static final String DEPENDENCIES_ATTRIBUTE = "dependencies";
    private static final String INCLUDES_ATTRIBUTE = "includes";
    private static final String INJECTS_ATTRIBUTE = "injects";
    private static final AnnotationValueVisitor<ImmutableList<TypeMirror>, String> TO_LIST_OF_TYPES = new SimpleAnnotationValueVisitor6<ImmutableList<TypeMirror>, String>(){

        @Override
        public ImmutableList<TypeMirror> visitArray(List<? extends AnnotationValue> vals, String elementName) {
            return FluentIterable.from(vals).transform((Function)new Function<AnnotationValue, TypeMirror>(){

                public TypeMirror apply(AnnotationValue typeValue) {
                    return (TypeMirror)TO_TYPE.visit(typeValue);
                }
            }).toList();
        }

        @Override
        protected ImmutableList<TypeMirror> defaultAction(Object o, String elementName) {
            String string = String.valueOf(o);
            throw new IllegalArgumentException(new StringBuilder(18 + String.valueOf(elementName).length() + String.valueOf(string).length()).append(elementName).append(" is not an array: ").append(string).toString());
        }
    };
    private static final AnnotationValueVisitor<TypeMirror, Void> TO_TYPE = new SimpleAnnotationValueVisitor6<TypeMirror, Void>(){

        @Override
        public TypeMirror visitType(TypeMirror t, Void p) {
            return t;
        }

        @Override
        protected TypeMirror defaultAction(Object o, Void p) {
            throw new TypeNotPresentException(o.toString(), null);
        }
    };

    static ImmutableList<TypeMirror> getComponentModules(AnnotationMirror componentAnnotation) {
        Preconditions.checkNotNull((Object)componentAnnotation);
        return ConfigurationAnnotations.convertClassArrayToListOfTypes(componentAnnotation, MODULES_ATTRIBUTE);
    }

    static ImmutableList<TypeMirror> getComponentDependencies(AnnotationMirror componentAnnotation) {
        Preconditions.checkNotNull((Object)componentAnnotation);
        return ConfigurationAnnotations.convertClassArrayToListOfTypes(componentAnnotation, DEPENDENCIES_ATTRIBUTE);
    }

    static ImmutableList<TypeMirror> getModuleIncludes(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return ConfigurationAnnotations.convertClassArrayToListOfTypes(moduleAnnotation, INCLUDES_ATTRIBUTE);
    }

    static ImmutableList<TypeMirror> getModuleInjects(AnnotationMirror moduleAnnotation) {
        Preconditions.checkNotNull((Object)moduleAnnotation);
        return ConfigurationAnnotations.convertClassArrayToListOfTypes(moduleAnnotation, INJECTS_ATTRIBUTE);
    }

    static Optional<DeclaredType> getNullableType(Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            return Optional.of((Object)annotationMirror.getAnnotationType());
        }
        return Optional.absent();
    }

    static ImmutableList<TypeMirror> convertClassArrayToListOfTypes(AnnotationMirror annotationMirror, String elementName) {
        return TO_LIST_OF_TYPES.visit(AnnotationMirrors.getAnnotationValue(annotationMirror, elementName), elementName);
    }

    @Deprecated
    static ImmutableSet<TypeElement> getTransitiveModules(Types types, Elements elements, Iterable<TypeElement> seedModules) {
        TypeMirror objectType = elements.getTypeElement(Object.class.getCanonicalName()).asType();
        ArrayDeque<TypeElement> moduleQueue = new ArrayDeque<TypeElement>();
        Iterables.addAll(moduleQueue, seedModules);
        LinkedHashSet moduleElements = Sets.newLinkedHashSet();
        TypeElement moduleElement = (TypeElement)moduleQueue.poll();
        while (moduleElement != null) {
            Optional moduleMirror = MoreElements.getAnnotationMirror(moduleElement, Module.class).or(MoreElements.getAnnotationMirror(moduleElement, ProducerModule.class));
            if (moduleMirror.isPresent()) {
                ImmutableSet.Builder moduleDependenciesBuilder = ImmutableSet.builder();
                moduleDependenciesBuilder.addAll(MoreTypes.asTypeElements(ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)moduleMirror.get())));
                ConfigurationAnnotations.addIncludesFromSuperclasses(types, moduleElement, (ImmutableSet.Builder<TypeElement>)moduleDependenciesBuilder, objectType);
                ImmutableSet moduleDependencies = moduleDependenciesBuilder.build();
                moduleElements.add(moduleElement);
                for (TypeElement dependencyType : moduleDependencies) {
                    if (moduleElements.contains(dependencyType)) continue;
                    moduleQueue.add(dependencyType);
                }
            }
            moduleElement = (TypeElement)moduleQueue.poll();
        }
        return ImmutableSet.copyOf((Collection)moduleElements);
    }

    static ImmutableList<DeclaredType> enclosedBuilders(TypeElement typeElement, Class<? extends Annotation> annotation) {
        ImmutableList.Builder builders = ImmutableList.builder();
        for (TypeElement element : ElementFilter.typesIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(element, annotation)) continue;
            builders.add((Object)MoreTypes.asDeclared(element.asType()));
        }
        return builders.build();
    }

    private static void addIncludesFromSuperclasses(Types types, TypeElement element, ImmutableSet.Builder<TypeElement> builder, TypeMirror objectType) {
        TypeMirror superclass = element.getSuperclass();
        while (!types.isSameType(objectType, superclass) && superclass.getKind().equals((Object)TypeKind.DECLARED)) {
            element = MoreElements.asType(types.asElement(superclass));
            Optional moduleMirror = MoreElements.getAnnotationMirror(element, Module.class).or(MoreElements.getAnnotationMirror(element, ProducerModule.class));
            if (moduleMirror.isPresent()) {
                builder.addAll(MoreTypes.asTypeElements(ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)moduleMirror.get())));
            }
            superclass = element.getSuperclass();
        }
    }

    private ConfigurationAnnotations() {
    }
}

