/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.Replacement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Message;

@Immutable
public final class Formatter {
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    private final JavaFormatterOptions options;

    public Formatter() {
        this(new JavaFormatterOptions(JavaFormatterOptions.JavadocFormatter.NONE, JavaFormatterOptions.Style.GOOGLE, JavaFormatterOptions.SortImports.NO));
    }

    public Formatter(JavaFormatterOptions options) {
        this.options = options;
    }

    static void format(JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options, List<FormatterDiagnostic> errors) {
        ASTParser parser = ASTParser.newParser(8);
        parser.setSource(javaInput.getText().toCharArray());
        Hashtable parserOptions = JavaCore.getOptions();
        JavaCore.setComplianceOptions("1.8", parserOptions);
        parser.setCompilerOptions(parserOptions);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        javaInput.setCompilationUnit(unit);
        if (unit.getMessages().length > 0) {
            for (Message message : unit.getMessages()) {
                errors.add(javaInput.createDiagnostic(message.getStartPosition(), message.getMessage()));
            }
            return;
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput, errors);
        new JavaInputAstVisitor(builder, options.indentationMultiplier()).visit(unit);
        builder.sync(javaInput.getText().length());
        builder.drain();
        Doc doc = new DocBuilder().withOps((List<Op>)builder.build()).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.maxLineLength(), new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write((CharSequence)this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        JavaInput javaInput = new JavaInput("<stdin>", input);
        JavaOutput javaOutput = new JavaOutput(javaInput, new JavaCommentsHelper(this.options));
        ArrayList<FormatterDiagnostic> errors = new ArrayList<FormatterDiagnostic>();
        Formatter.format(javaInput, javaOutput, this.options, errors);
        if (!errors.isEmpty()) {
            throw new FormatterException(errors);
        }
        StringBuilder result = new StringBuilder(input.length());
        TreeRangeSet lineRangeSet = TreeRangeSet.create();
        lineRangeSet.add(Range.all());
        try {
            javaOutput.writeMerged(result, (RangeSet<Integer>)lineRangeSet);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"IOException impossible for StringWriter");
        }
        return result.toString();
    }

    public String formatSource(String input, List<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput("<stdin>", input);
        JavaOutput javaOutput = new JavaOutput(javaInput, new JavaCommentsHelper(this.options));
        ArrayList<FormatterDiagnostic> errors = new ArrayList<FormatterDiagnostic>();
        Formatter.format(javaInput, javaOutput, this.options, errors);
        if (!errors.isEmpty()) {
            throw new FormatterException(errors);
        }
        StringBuilder result = new StringBuilder(input.length());
        RangeSet<Integer> tokenRangeSet = Formatter.characterRangesToTokenRanges(javaInput, characterRanges);
        try {
            javaOutput.writeMerged(result, tokenRangeSet);
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"IOException impossible for StringWriter");
        }
        return result.toString();
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, List<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput("<stdin>", input);
        JavaOutput javaOutput = new JavaOutput(javaInput, new JavaCommentsHelper(this.options));
        ArrayList<FormatterDiagnostic> errors = new ArrayList<FormatterDiagnostic>();
        Formatter.format(javaInput, javaOutput, this.options, errors);
        if (!errors.isEmpty()) {
            throw new FormatterException(errors);
        }
        RangeSet<Integer> tokenRangeSet = Formatter.characterRangesToTokenRanges(javaInput, characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }

    private static RangeSet<Integer> characterRangesToTokenRanges(JavaInput javaInput, List<Range<Integer>> characterRanges) throws FormatterException {
        TreeRangeSet tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range characterRange = characterRange0.canonical(DiscreteDomain.integers());
            tokenRangeSet.add(javaInput.characterRangeToTokenRange((Integer)characterRange.lowerEndpoint(), (Integer)characterRange.upperEndpoint() - (Integer)characterRange.lowerEndpoint()));
        }
        return tokenRangeSet;
    }
}

