/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ascii;

import com.hazelcast.internal.ascii.TextCommand;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.WriteHandler;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TextWriteHandler
implements WriteHandler<TextCommand> {
    private final TcpIpConnection connection;
    private final Map<Long, TextCommand> responses = new ConcurrentHashMap<Long, TextCommand>(100);
    private long currentRequestId;

    public TextWriteHandler(TcpIpConnection connection) {
        this.connection = connection;
    }

    public void enqueue(TextCommand response) {
        long requestId = response.getRequestId();
        if (requestId == -1L) {
            this.connection.write(response);
        } else if (this.currentRequestId == requestId) {
            this.connection.write(response);
            ++this.currentRequestId;
            this.processWaitingResponses();
        } else {
            this.responses.put(requestId, response);
        }
    }

    private void processWaitingResponses() {
        TextCommand response = this.responses.remove(this.currentRequestId);
        while (response != null) {
            this.connection.write(response);
            ++this.currentRequestId;
            response = this.responses.remove(this.currentRequestId);
        }
    }

    @Override
    public boolean onWrite(TextCommand textCommand, ByteBuffer dst) throws Exception {
        return textCommand.writeTo(dst);
    }
}

