/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class SimpleAnnotationMirror
implements AnnotationMirror {
    private final DeclaredType type;

    private SimpleAnnotationMirror(DeclaredType type) {
        this.type = type;
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.type;
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return ImmutableMap.of();
    }

    public String toString() {
        String string = String.valueOf(this.type);
        return new StringBuilder(1 + String.valueOf(string).length()).append("@").append(string).toString();
    }

    static AnnotationMirror of(TypeElement element) {
        Preconditions.checkArgument((boolean)element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE));
        Preconditions.checkArgument((boolean)element.getEnclosedElements().isEmpty());
        return new SimpleAnnotationMirror(MoreTypes.asDeclared(element.asType()));
    }
}

