/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.KeepAliveManager;
import io.grpc.netty.AbstractNettyHandler;
import io.grpc.netty.CancelClientStreamCommand;
import io.grpc.netty.ClientTransportLifecycleManager;
import io.grpc.netty.CreateStreamCommand;
import io.grpc.netty.FixedHttp2ConnectionDecoder;
import io.grpc.netty.ForcefulCloseCommand;
import io.grpc.netty.GracefulCloseCommand;
import io.grpc.netty.GrpcHttp2HeadersDecoder;
import io.grpc.netty.NettyClientStream;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.SendPingCommand;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyClientHandler
extends AbstractNettyHandler {
    private static final Logger logger = Logger.getLogger(NettyClientHandler.class.getName());
    static final Object NOOP_MESSAGE = new Object();
    private static final Status EXHAUSTED_STREAMS_STATUS = Status.UNAVAILABLE.withDescription("Stream IDs have been exhausted");
    private static final long USER_PING_PAYLOAD = 1111L;
    private final Http2Connection.PropertyKey streamKey;
    private final ClientTransportLifecycleManager lifecycleManager;
    private final KeepAliveManager keepAliveManager;
    private final Ticker ticker;
    private WriteQueue clientWriteQueue;
    private Http2Ping ping;
    private Attributes attributes = Attributes.EMPTY;

    static NettyClientHandler newHandler(ClientTransportLifecycleManager lifecycleManager, @Nullable KeepAliveManager keepAliveManager, int flowControlWindow, int maxHeaderListSize, Ticker ticker, Runnable tooManyPingsRunnable) {
        Preconditions.checkArgument((maxHeaderListSize > 0 ? 1 : 0) != 0, (Object)"maxHeaderListSize must be positive");
        GrpcHttp2HeadersDecoder.GrpcHttp2ClientHeadersDecoder headersDecoder = new GrpcHttp2HeadersDecoder.GrpcHttp2ClientHeadersDecoder(maxHeaderListSize);
        DefaultHttp2FrameReader frameReader = new DefaultHttp2FrameReader((Http2HeadersDecoder)headersDecoder);
        DefaultHttp2FrameWriter frameWriter = new DefaultHttp2FrameWriter();
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        return NettyClientHandler.newHandler((Http2Connection)connection, (Http2FrameReader)frameReader, (Http2FrameWriter)frameWriter, lifecycleManager, keepAliveManager, flowControlWindow, maxHeaderListSize, ticker, tooManyPingsRunnable);
    }

    @VisibleForTesting
    static NettyClientHandler newHandler(Http2Connection connection, Http2FrameReader frameReader, Http2FrameWriter frameWriter, ClientTransportLifecycleManager lifecycleManager, KeepAliveManager keepAliveManager, int flowControlWindow, int maxHeaderListSize, Ticker ticker, Runnable tooManyPingsRunnable) {
        Preconditions.checkNotNull((Object)connection, (Object)"connection");
        Preconditions.checkNotNull((Object)frameReader, (Object)"frameReader");
        Preconditions.checkNotNull((Object)lifecycleManager, (Object)"lifecycleManager");
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        Preconditions.checkArgument((maxHeaderListSize > 0 ? 1 : 0) != 0, (Object)"maxHeaderListSize must be positive");
        Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
        Preconditions.checkNotNull((Object)tooManyPingsRunnable, (Object)"tooManyPingsRunnable");
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, NettyClientHandler.class);
        frameReader = new Http2InboundFrameLogger(frameReader, frameLogger);
        frameWriter = new Http2OutboundFrameLogger(frameWriter, frameLogger);
        StreamBufferingEncoder encoder = new StreamBufferingEncoder((Http2ConnectionEncoder)new DefaultHttp2ConnectionEncoder(connection, frameWriter));
        connection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController(connection, 0.5f, true));
        FixedHttp2ConnectionDecoder decoder = new FixedHttp2ConnectionDecoder(connection, (Http2ConnectionEncoder)encoder, frameReader);
        Http2Settings settings = new Http2Settings();
        settings.pushEnabled(false);
        settings.initialWindowSize(flowControlWindow);
        settings.maxConcurrentStreams(0L);
        settings.maxHeaderListSize((long)maxHeaderListSize);
        return new NettyClientHandler(decoder, encoder, settings, lifecycleManager, keepAliveManager, ticker, tooManyPingsRunnable);
    }

    private NettyClientHandler(Http2ConnectionDecoder decoder, StreamBufferingEncoder encoder, Http2Settings settings, ClientTransportLifecycleManager lifecycleManager, KeepAliveManager keepAliveManager, Ticker ticker, final Runnable tooManyPingsRunnable) {
        super(decoder, (Http2ConnectionEncoder)encoder, settings);
        this.lifecycleManager = lifecycleManager;
        this.keepAliveManager = keepAliveManager;
        this.ticker = ticker;
        this.decoder().frameListener((Http2FrameListener)new FrameListener());
        Http2Connection connection = encoder.connection();
        this.streamKey = connection.newKey();
        connection.addListener((Http2Connection.Listener)new Http2ConnectionAdapter(){

            public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
                byte[] debugDataBytes = ByteBufUtil.getBytes((ByteBuf)debugData);
                NettyClientHandler.this.goingAway(NettyClientHandler.this.statusFromGoAway(errorCode, debugDataBytes));
                if (errorCode == Http2Error.ENHANCE_YOUR_CALM.code()) {
                    String data = new String(debugDataBytes, CharsetUtil.UTF_8);
                    logger.log(Level.WARNING, "Received GOAWAY with ENHANCE_YOUR_CALM. Debug data: {1}", data);
                    if ("too_many_pings".equals(data)) {
                        tooManyPingsRunnable.run();
                    }
                }
            }

            public void onStreamAdded(Http2Stream stream) {
                NettyClientHandler.this.lifecycleManager.notifyInUse(true);
            }

            public void onStreamRemoved(Http2Stream stream) {
                if (NettyClientHandler.this.connection().numActiveStreams() == 0) {
                    NettyClientHandler.this.lifecycleManager.notifyInUse(false);
                }
            }

            public void onStreamActive(Http2Stream stream) {
                if (NettyClientHandler.this.keepAliveManager != null && NettyClientHandler.this.connection().numActiveStreams() == 1) {
                    NettyClientHandler.this.keepAliveManager.onTransportActive();
                }
            }

            public void onStreamClosed(Http2Stream stream) {
                if (NettyClientHandler.this.keepAliveManager != null && NettyClientHandler.this.connection().numActiveStreams() == 0) {
                    NettyClientHandler.this.keepAliveManager.onTransportIdle();
                }
            }
        });
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CreateStreamCommand) {
            this.createStream((CreateStreamCommand)msg, promise);
        } else if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)msg, promise);
        } else if (msg instanceof CancelClientStreamCommand) {
            this.cancelStream(ctx, (CancelClientStreamCommand)msg, promise);
        } else if (msg instanceof SendPingCommand) {
            this.sendPingFrame(ctx, (SendPingCommand)msg, promise);
        } else if (msg instanceof GracefulCloseCommand) {
            this.gracefulClose(ctx, (GracefulCloseCommand)msg, promise);
        } else if (msg instanceof ForcefulCloseCommand) {
            this.forcefulClose(ctx, (ForcefulCloseCommand)msg, promise);
        } else if (msg == NOOP_MESSAGE) {
            ctx.write((Object)Unpooled.EMPTY_BUFFER, promise);
        } else {
            throw new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
        }
    }

    void startWriteQueue(Channel channel) {
        this.clientWriteQueue = new WriteQueue(channel);
    }

    WriteQueue getWriteQueue() {
        return this.clientWriteQueue;
    }

    void returnProcessedBytes(Http2Stream stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onHeadersRead(int streamId, Http2Headers headers, boolean endStream) {
        NettyClientStream.TransportState stream = this.clientStream(this.requireHttp2Stream(streamId));
        stream.transportHeadersReceived(headers, endStream);
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onDataReceived();
        }
    }

    private void onDataRead(int streamId, ByteBuf data, int padding, boolean endOfStream) {
        this.flowControlPing().onDataRead(data.readableBytes(), padding);
        NettyClientStream.TransportState stream = this.clientStream(this.requireHttp2Stream(streamId));
        stream.transportDataReceived(data, endOfStream);
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onDataReceived();
        }
    }

    private void onRstStreamRead(int streamId, long errorCode) {
        NettyClientStream.TransportState stream = this.clientStream(this.connection().stream(streamId));
        if (stream != null) {
            Status status = GrpcUtil.Http2Error.statusForCode((long)((int)errorCode)).augmentDescription("Received Rst Stream");
            stream.transportReportStatus(status, false, new Metadata());
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onDataReceived();
            }
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        logger.fine("Network channel being closed by the application.");
        this.lifecycleManager.notifyShutdown(Status.UNAVAILABLE.withDescription("Transport closed for unknown reason"));
        super.close(ctx, promise);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            logger.fine("Network channel is closed");
            this.lifecycleManager.notifyShutdown(Status.UNAVAILABLE.withDescription("Network closed for unknown reason"));
            this.cancelPing(this.lifecycleManager.getShutdownThrowable());
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream stream) throws Http2Exception {
                    NettyClientStream.TransportState clientStream = NettyClientHandler.this.clientStream(stream);
                    if (clientStream != null) {
                        clientStream.transportReportStatus(NettyClientHandler.this.lifecycleManager.getShutdownStatus(), false, new Metadata());
                    }
                    return true;
                }
            });
        }
        finally {
            super.channelInactive(ctx);
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportTermination();
            }
        }
    }

    @Override
    public void handleProtocolNegotiationCompleted(Attributes attributes) {
        this.attributes = attributes;
        super.handleProtocolNegotiationCompleted(attributes);
    }

    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.FINE, "Caught a connection error", cause);
        this.lifecycleManager.notifyShutdown(Utils.statusFromThrowable(cause));
        super.onConnectionError(ctx, cause, http2Ex);
    }

    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        NettyClientStream.TransportState stream = this.clientStream(this.connection().stream(http2Ex.streamId()));
        if (stream != null) {
            stream.transportReportStatus(Utils.statusFromThrowable(cause), false, new Metadata());
        } else {
            logger.log(Level.FINE, "Stream error for unknown stream " + http2Ex.streamId(), cause);
        }
        super.onStreamError(ctx, cause, http2Ex);
    }

    protected boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && ((StreamBufferingEncoder)this.encoder()).numBufferedStreams() == 0;
    }

    private void createStream(CreateStreamCommand command, final ChannelPromise promise) throws Exception {
        int streamId;
        if (this.lifecycleManager.getShutdownThrowable() != null) {
            promise.setFailure(this.lifecycleManager.getShutdownThrowable());
            return;
        }
        try {
            streamId = this.incrementAndGetNextStreamId();
        }
        catch (StatusException e) {
            promise.setFailure((Throwable)e);
            if (!this.connection().goAwaySent()) {
                logger.fine("Stream IDs have been exhausted for this connection. Initiating graceful shutdown of the connection.");
                this.lifecycleManager.notifyShutdown(e.getStatus());
                this.close(this.ctx(), this.ctx().newPromise());
            }
            return;
        }
        final NettyClientStream.TransportState stream = command.stream();
        Http2Headers headers = command.headers();
        stream.setId(streamId);
        ChannelPromise tempPromise = this.ctx().newPromise();
        this.encoder().writeHeaders(this.ctx(), streamId, headers, 0, command.isGet(), tempPromise).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    Http2Stream http2Stream = NettyClientHandler.this.connection().stream(streamId);
                    if (http2Stream != null) {
                        stream.getStatsTraceContext().clientOutboundHeaders();
                        http2Stream.setProperty(NettyClientHandler.this.streamKey, (Object)stream);
                        stream.setHttp2Stream(http2Stream);
                    }
                    promise.setSuccess();
                } else {
                    Throwable cause = future.cause();
                    if (cause instanceof StreamBufferingEncoder.Http2GoAwayException) {
                        StreamBufferingEncoder.Http2GoAwayException e = (StreamBufferingEncoder.Http2GoAwayException)cause;
                        NettyClientHandler.this.lifecycleManager.notifyShutdown(NettyClientHandler.this.statusFromGoAway(e.errorCode(), e.debugData()));
                        promise.setFailure(NettyClientHandler.this.lifecycleManager.getShutdownThrowable());
                    } else {
                        promise.setFailure(cause);
                    }
                }
            }
        });
    }

    private void cancelStream(ChannelHandlerContext ctx, CancelClientStreamCommand cmd, ChannelPromise promise) {
        NettyClientStream.TransportState stream = cmd.stream();
        stream.transportReportStatus(cmd.reason(), true, new Metadata());
        this.encoder().writeRstStream(ctx, stream.id(), Http2Error.CANCEL.code(), promise);
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) {
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendPingFrame(ChannelHandlerContext ctx, SendPingCommand msg, ChannelPromise promise) {
        ClientTransport.PingCallback callback = msg.callback();
        Executor executor = msg.executor();
        if (this.ping != null) {
            promise.setSuccess();
            this.ping.addCallback(callback, executor);
            return;
        }
        promise.setSuccess();
        promise = this.ctx().newPromise();
        long data = 1111L;
        ByteBuf buffer = ctx.alloc().buffer(8);
        buffer.writeLong(data);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        this.ping = new Http2Ping(data, stopwatch);
        this.ping.addCallback(callback, executor);
        this.encoder().writePing(ctx, false, buffer, promise);
        ctx.flush();
        final Http2Ping finalPing = this.ping;
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Throwable cause = future.cause();
                    if (cause instanceof ClosedChannelException && (cause = NettyClientHandler.this.lifecycleManager.getShutdownThrowable()) == null) {
                        cause = Status.UNKNOWN.withDescription("Ping failed but for unknown reason.").withCause(future.cause()).asException();
                    }
                    finalPing.failed(cause);
                    if (NettyClientHandler.this.ping == finalPing) {
                        NettyClientHandler.this.ping = null;
                    }
                }
            }
        });
    }

    private void gracefulClose(ChannelHandlerContext ctx, GracefulCloseCommand msg, ChannelPromise promise) throws Exception {
        this.lifecycleManager.notifyShutdown(msg.getStatus());
        this.flush(ctx);
        this.close(ctx, promise);
    }

    private void forcefulClose(final ChannelHandlerContext ctx, final ForcefulCloseCommand msg, ChannelPromise promise) throws Exception {
        this.lifecycleManager.notifyShutdown(Status.UNAVAILABLE.withDescription("Channel requested transport to shut down"));
        this.close(ctx, promise);
        this.connection().forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream stream) throws Http2Exception {
                NettyClientStream.TransportState clientStream = NettyClientHandler.this.clientStream(stream);
                if (clientStream != null) {
                    clientStream.transportReportStatus(msg.getStatus(), true, new Metadata());
                    NettyClientHandler.this.resetStream(ctx, stream.id(), Http2Error.CANCEL.code(), ctx.newPromise());
                }
                stream.close();
                return true;
            }
        });
    }

    private void goingAway(Status status) {
        this.lifecycleManager.notifyShutdown(status);
        final Status goAwayStatus = this.lifecycleManager.getShutdownStatus();
        final int lastKnownStream = this.connection().local().lastStreamKnownByPeer();
        try {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream stream) throws Http2Exception {
                    if (stream.id() > lastKnownStream) {
                        NettyClientStream.TransportState clientStream = NettyClientHandler.this.clientStream(stream);
                        if (clientStream != null) {
                            clientStream.transportReportStatus(goAwayStatus, false, new Metadata());
                        }
                        stream.close();
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cancelPing(Throwable t) {
        if (this.ping != null) {
            this.ping.failed(t);
            this.ping = null;
        }
    }

    private Status statusFromGoAway(long errorCode, byte[] debugData) {
        Status status = GrpcUtil.Http2Error.statusForCode((long)((int)errorCode)).augmentDescription("Received Goaway");
        if (debugData != null && debugData.length > 0) {
            String msg = new String(debugData, CharsetUtil.UTF_8);
            status = status.augmentDescription(msg);
        }
        return status;
    }

    private NettyClientStream.TransportState clientStream(Http2Stream stream) {
        return stream == null ? null : (NettyClientStream.TransportState)stream.getProperty(this.streamKey);
    }

    private int incrementAndGetNextStreamId() throws StatusException {
        int nextStreamId = this.connection().local().incrementAndGetNextStreamId();
        if (nextStreamId < 0) {
            logger.fine("Stream IDs have been exhausted for this connection. Initiating graceful shutdown of the connection.");
            throw EXHAUSTED_STREAMS_STATUS.asException();
        }
        return nextStreamId;
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private class FrameListener
    extends Http2FrameAdapter {
        private boolean firstSettings = true;

        private FrameListener() {
        }

        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
            if (this.firstSettings) {
                this.firstSettings = false;
                NettyClientHandler.this.lifecycleManager.notifyReady();
            }
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            NettyClientHandler.this.onDataRead(streamId, data, padding, endOfStream);
            return padding;
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            NettyClientHandler.this.onHeadersRead(streamId, headers, endStream);
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            NettyClientHandler.this.onRstStreamRead(streamId, errorCode);
        }

        public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            Http2Ping p = NettyClientHandler.this.ping;
            if (data.getLong(data.readerIndex()) == (long)NettyClientHandler.this.flowControlPing().payload()) {
                NettyClientHandler.this.flowControlPing().updateWindow();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("Window: %d", NettyClientHandler.this.decoder().flowController().initialWindowSize(NettyClientHandler.this.connection().connectionStream())));
                }
            } else if (p != null) {
                long ackPayload = data.readLong();
                if (p.payload() == ackPayload) {
                    p.complete();
                    NettyClientHandler.this.ping = null;
                } else {
                    logger.log(Level.WARNING, String.format("Received unexpected ping ack. Expecting %d, got %d", p.payload(), ackPayload));
                }
            } else {
                logger.warning("Received unexpected ping ack. No ping outstanding");
            }
            if (NettyClientHandler.this.keepAliveManager != null) {
                NettyClientHandler.this.keepAliveManager.onDataReceived();
            }
        }

        public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            if (NettyClientHandler.this.keepAliveManager != null) {
                NettyClientHandler.this.keepAliveManager.onDataReceived();
            }
        }
    }
}

