/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.util.Map;

@BugPattern(name="HardCodedSdCardPath", altNames={"SdCardPath"}, summary="Hardcoded reference to /sdcard", category=BugPattern.Category.ANDROID, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class HardCodedSdCardPath
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    static final String SDCARD = "Environment.getExternalStorageDirectory().getPath()";
    static final String DATA = "Context.getFilesDir().getPath()";
    static final ImmutableMap<String, String> PATH_TABLE = new ImmutableMap.Builder().put((Object)"/sdcard", (Object)"Environment.getExternalStorageDirectory().getPath()").put((Object)"/mnt/sdcard", (Object)"Environment.getExternalStorageDirectory().getPath()").put((Object)"/system/media/sdcard", (Object)"Environment.getExternalStorageDirectory().getPath()").put((Object)"file://sdcard", (Object)"Environment.getExternalStorageDirectory().getPath()").put((Object)"file:///sdcard", (Object)"Environment.getExternalStorageDirectory().getPath()").put((Object)"/data/data", (Object)"Context.getFilesDir().getPath()").put((Object)"/data/user", (Object)"Context.getFilesDir().getPath()").build();

    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        if (tree.getKind() != Tree.Kind.STRING_LITERAL) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isJUnitTestCode((VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String literal = (String)tree.getValue();
        if (literal == null) {
            return Description.NO_MATCH;
        }
        for (Map.Entry entry : PATH_TABLE.entrySet()) {
            String hardCodedPath = (String)entry.getKey();
            if (!literal.startsWith(hardCodedPath)) continue;
            String correctPath = (String)entry.getValue();
            String remainderPath = literal.substring(hardCodedPath.length());
            SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
            if (remainderPath.isEmpty()) {
                suggestedFix.replace((Tree)tree, correctPath);
            } else {
                suggestedFix.replace((Tree)tree, correctPath + " + \"" + remainderPath + "\"");
            }
            if (correctPath.equals(SDCARD)) {
                suggestedFix.addImport("android.os.Environment");
            } else {
                suggestedFix.addImport("android.content.Context");
            }
            return this.describeMatch(tree, (Fix)suggestedFix.build());
        }
        return Description.NO_MATCH;
    }
}

