/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ThrowNull", category=BugPattern.Category.JDK, summary="Throwing 'null' always results in a NullPointerException being thrown.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ThrowNull
extends BugChecker
implements BugChecker.ThrowTreeMatcher {
    public Description matchThrow(ThrowTree tree, VisitorState state) {
        return tree.getExpression().getKind() == Tree.Kind.NULL_LITERAL ? this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree.getExpression(), (String)"new NullPointerException()")) : Description.NO_MATCH;
    }
}

