/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Fact;
import com.google.common.truth.StackTraceCleaner;
import com.google.common.truth.Truth;
import difflib.DiffUtils;
import difflib.Patch;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.junit.ComparisonFailure;
import org.junit.rules.TestRule;

final class Platform {
    static final String EXPECT_FAILURE_WARNING_IF_GWT = "";

    private Platform() {
    }

    static boolean isInstanceOfType(Object instance, Class<?> clazz) {
        return clazz.isInstance(instance);
    }

    static boolean containsMatch(String actual, String regex) {
        return Pattern.compile(regex).matcher(actual).find();
    }

    static Throwable[] getSuppressed(Throwable throwable) {
        try {
            Method getSuppressed = throwable.getClass().getMethod("getSuppressed", new Class[0]);
            return (Throwable[])getSuppressed.invoke((Object)throwable, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return new Throwable[0];
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void cleanStackTrace(Throwable throwable) {
        StackTraceCleaner.cleanStackTrace(throwable);
    }

    @NullableDecl
    static ImmutableList<Fact> makeDiff(String expected, String actual) {
        ImmutableList<String> actualLines;
        Patch diff;
        ImmutableList<String> expectedLines = Platform.splitLines(expected);
        List unifiedDiff = DiffUtils.generateUnifiedDiff((String)"expected", (String)"actual", expectedLines, (Patch)(diff = DiffUtils.diff(expectedLines, actualLines = Platform.splitLines(actual))), (int)3);
        if (unifiedDiff.isEmpty()) {
            return ImmutableList.of((Object)Fact.fact("diff", "(line contents match, but line-break characters differ)"));
        }
        unifiedDiff = unifiedDiff.subList(2, unifiedDiff.size());
        String result = Joiner.on((String)"\n").join(unifiedDiff);
        if (result.length() > expected.length() && result.length() > actual.length()) {
            return null;
        }
        return ImmutableList.of((Object)Fact.fact("diff", result));
    }

    private static ImmutableList<String> splitLines(String s) {
        return ImmutableList.copyOf((Iterable)Splitter.onPattern((String)"\r?\n").split((CharSequence)s));
    }

    static String doubleToString(double value) {
        return Double.toString(value);
    }

    static String floatToString(float value) {
        return Float.toString(value);
    }

    static String getStackTraceAsString(Throwable throwable) {
        return Throwables.getStackTraceAsString((Throwable)throwable);
    }

    static boolean isAndroid() {
        return System.getProperties().getProperty("java.runtime.name").contains("Android");
    }

    static interface JUnitTestRule
    extends TestRule {
    }

    static abstract class PlatformComparisonFailure
    extends ComparisonFailure {
        private final String message;
        @NullableDecl
        private final Throwable cause;
        @NullableDecl
        private final String suffix;
        private final ComparisonFailureMessageStrategy messageStrategy;

        PlatformComparisonFailure(@NullableDecl String message, @NullableDecl String expected, @NullableDecl String actual, @NullableDecl String suffix, @NullableDecl Throwable cause, ComparisonFailureMessageStrategy messageStrategy) {
            super(message, expected, actual);
            this.message = message;
            this.suffix = suffix;
            this.cause = cause;
            this.messageStrategy = messageStrategy;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        public final String getMessage() {
            String body = this.messageStrategy == ComparisonFailureMessageStrategy.INCLUDE_COMPARISON_FAILURE_GENERATED_MESSAGE ? super.getMessage() : this.message;
            return Truth.appendSuffixIfNotNull(body, this.suffix);
        }

        public final Throwable getCause() {
            return this.cause;
        }

        public final String toString() {
            return this.getLocalizedMessage();
        }
    }

    static enum ComparisonFailureMessageStrategy {
        OMIT_COMPARISON_FAILURE_GENERATED_MESSAGE,
        INCLUDE_COMPARISON_FAILURE_GENERATED_MESSAGE;

    }
}

