/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.SimpleTopLevelIndex;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.zip.Zip;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CtSymClassBinder {
    public static @Nullable ClassPath bind(String version) throws IOException {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        Path ctSym = javaHome.resolve("lib/ct.sym");
        if (!Files.exists(ctSym, new LinkOption[0])) {
            throw new IllegalStateException("lib/ct.sym does not exist in " + javaHome);
        }
        final HashMap<ClassSymbol, BytecodeBoundClass> map = new HashMap<ClassSymbol, BytecodeBoundClass>();
        HashMap<ModuleSymbol, ModuleInfo> modules = new HashMap<ModuleSymbol, ModuleInfo>();
        Env<ClassSymbol, BytecodeBoundClass> benv = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)map.get(sym);
            }
        };
        for (Zip.Entry ze : new Zip.ZipIterable(ctSym)) {
            int idx;
            String name = ze.name();
            if (!name.endsWith(".sig") || (idx = name.indexOf(47)) == -1 || !ze.name().substring(0, idx).contains(version)) continue;
            if (name.substring(name.lastIndexOf(47) + 1).equals("module-info.sig")) {
                ModuleInfo moduleInfo = BytecodeBinder.bindModuleInfo(name, CtSymClassBinder.toByteArrayOrDie(ze));
                modules.put(new ModuleSymbol(moduleInfo.name()), moduleInfo);
                continue;
            }
            ClassSymbol sym = new ClassSymbol(name.substring(idx + 1, name.length() - ".sig".length()));
            map.putIfAbsent(sym, new BytecodeBoundClass(sym, CtSymClassBinder.toByteArrayOrDie(ze), benv, ctSym + "!" + ze.name()));
        }
        if (map.isEmpty()) {
            return null;
        }
        final SimpleEnv env = new SimpleEnv(ImmutableMap.copyOf(map));
        final SimpleEnv moduleEnv = new SimpleEnv(ImmutableMap.copyOf(modules));
        final TopLevelIndex index = SimpleTopLevelIndex.of((Iterable<ClassSymbol>)env.asMap().keySet());
        return new ClassPath(){

            @Override
            public Env<ClassSymbol, BytecodeBoundClass> env() {
                return env;
            }

            @Override
            public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
                return moduleEnv;
            }

            @Override
            public TopLevelIndex index() {
                return index;
            }
        };
    }

    private static Supplier<byte[]> toByteArrayOrDie(final Zip.Entry ze) {
        return Suppliers.memoize((Supplier)new Supplier<byte[]>(){

            public byte[] get() {
                return ze.data();
            }
        });
    }
}

