/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.client;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.AutoFlushWriter;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.client.SjavacClient;
import com.sun.tools.sjavac.comp.SjavacImpl;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.server.Sjavac;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ClientMain {
    public static int run(String[] args) {
        return ClientMain.run(args, new AutoFlushWriter(new OutputStreamWriter(System.out)), new AutoFlushWriter(new OutputStreamWriter(System.err)));
    }

    public static int run(String[] args, Writer out, Writer err) {
        Options options;
        Log.setLogForCurrentThread(new Log(out, err));
        try {
            options = Options.parseArgs(args);
        }
        catch (IllegalArgumentException e) {
            Log.error(e.getMessage());
            return Main.Result.CMDERR.exitCode;
        }
        Log.setLogLevel(options.getLogLevel());
        Log.debug("==========================================================");
        Log.debug("Launching sjavac client with the following parameters:");
        Log.debug("    " + options.getStateArgsString());
        Log.debug("==========================================================");
        boolean useServer = options.getServerConf() != null;
        Sjavac sjavac = useServer ? new SjavacClient(options) : new SjavacImpl();
        Main.Result result = sjavac.compile(args);
        if (!useServer) {
            sjavac.shutdown();
        }
        return result.exitCode;
    }
}

