/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.strings;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

class FastStringCodec
implements ObjectCodec<String> {
    private static final long UNSUPPORTED_STRING_VALUE_OFFSET = -1L;
    private static final Unsafe theUnsafe = FastStringCodec.getUnsafe();
    private static final long STRING_VALUE_OFFSET = FastStringCodec.getStringValueOffset();
    private static final String EMPTY_STRING = "";

    static boolean isAvailable() {
        return STRING_VALUE_OFFSET != -1L;
    }

    FastStringCodec() {
        Preconditions.checkState((boolean)FastStringCodec.isAvailable(), (Object)"FastStringCodec isn't available!");
    }

    @Override
    public Class<String> getEncodedClass() {
        return String.class;
    }

    @Override
    public void serialize(String string, CodedOutputStream codedOut) throws IOException {
        codedOut.writeStringNoTag(string);
    }

    @Override
    public String deserialize(CodedInputStream codedIn) throws IOException {
        int length = codedIn.readInt32();
        if (length == 0) {
            return EMPTY_STRING;
        }
        char[] maybeDecoded = new char[length];
        for (int i = 0; i < length; ++i) {
            byte b = codedIn.readRawByte();
            if ((b & 0x80) != 0) {
                int j;
                byte[] decodeFrom = new byte[length];
                for (j = 0; j < i; ++j) {
                    decodeFrom[j] = (byte)maybeDecoded[j];
                }
                decodeFrom[i] = b;
                for (j = i + 1; j < length; ++j) {
                    decodeFrom[j] = codedIn.readRawByte();
                }
                return new String(decodeFrom, StandardCharsets.UTF_8);
            }
            maybeDecoded[i] = (char)b;
        }
        try {
            String result = (String)theUnsafe.allocateInstance(String.class);
            theUnsafe.putObject(result, STRING_VALUE_OFFSET, maybeDecoded);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create string", e);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> unsafeClass = Unsafe.class;
                    for (Field f : unsafeClass.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object fieldValue = f.get(null);
                        if (!unsafeClass.isInstance(fieldValue)) continue;
                        return (Unsafe)unsafeClass.cast(fieldValue);
                    }
                    throw new AssertionError((Object)"Failed to find sun.misc.Unsafe instance");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new AssertionError("Unable to get sun.misc.Unsafe", pae);
        }
    }

    private static long getStringValueOffset() {
        try {
            Field valueField = String.class.getDeclaredField("value");
            Class<?> valueFieldType = valueField.getType();
            if (valueFieldType.equals(char[].class)) {
                return theUnsafe.objectFieldOffset(valueField);
            }
            return -1L;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new AssertionError("Failed to find String's 'value' field/offset", e);
        }
    }
}

