/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@BugPattern(name="InvalidPatternSyntax", summary="Invalid syntax used for a regular expression", explanation="This error is triggered by calls to regex-accepting methods with invalid string literals.  These calls would cause a PatternSyntaxException at runtime.\n\nWe deliberately do not check java.util.regex.Pattern#compile as many of its users are deliberately testing the regex compiler or using a vacuously true regex.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class InvalidPatternSyntax
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String MESSAGE_BASE = "Invalid syntax used for a regular expression: ";
    private static final Matcher<ExpressionTree> BAD_REGEX_LITERAL = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            Object value = ((JCTree.JCExpression)tree).type.constValue();
            return value instanceof String && !this.isValidSyntax((String)value);
        }

        private boolean isValidSyntax(String regex) {
            if (".".equals(regex)) {
                return false;
            }
            try {
                Pattern.compile(regex);
                return true;
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
    };
    private static final Matcher<MethodInvocationTree> BAD_REGEX_USAGE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("java.lang.String").withSignature("matches(java.lang.String)"), MethodMatchers.instanceMethod().onDescendantOf("java.lang.String").withSignature("replaceAll(java.lang.String,java.lang.String)"), MethodMatchers.instanceMethod().onDescendantOf("java.lang.String").withSignature("replaceFirst(java.lang.String,java.lang.String)"), MethodMatchers.instanceMethod().onDescendantOf("java.lang.String").withSignature("split(java.lang.String)"), MethodMatchers.instanceMethod().onDescendantOf("java.lang.String").withSignature("split(java.lang.String,int)"), MethodMatchers.staticMethod().onClass("java.util.regex.Pattern").named("matches"), MethodMatchers.staticMethod().onClass("com.google.common.base.Splitter").named("onPattern")}), Matchers.argument((int)0, BAD_REGEX_LITERAL)});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!BAD_REGEX_USAGE.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder descriptionBuilder = this.buildDescription(methodInvocationTree);
        ExpressionTree arg = methodInvocationTree.getArguments().get(0);
        String value = (String)((JCTree.JCExpression)arg).type.constValue();
        String reasonInvalid = "";
        if (".".equals(value)) {
            descriptionBuilder.addFix((Fix)SuggestedFix.replace((Tree)arg, (String)"\"\\\\.\""));
            reasonInvalid = "\".\" is a valid but useless regex";
        } else {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                reasonInvalid = e.getMessage();
            }
        }
        descriptionBuilder.setMessage(MESSAGE_BASE + reasonInvalid);
        return descriptionBuilder.build();
    }
}

