/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Timestamps;
import java.text.ParseException;
import java.util.Comparator;

public final class Durations {
    static final long DURATION_SECONDS_MIN = -315576000000L;
    static final long DURATION_SECONDS_MAX = 315576000000L;
    public static final Duration MIN_VALUE = Duration.newBuilder().setSeconds(-315576000000L).setNanos(-999999999).build();
    public static final Duration MAX_VALUE = Duration.newBuilder().setSeconds(315576000000L).setNanos(999999999).build();
    private static final Comparator<Duration> COMPARATOR = new Comparator<Duration>(){

        @Override
        public int compare(Duration duration, Duration duration2) {
            Durations.checkValid(duration);
            Durations.checkValid(duration2);
            int n = Long.compare(duration.getSeconds(), duration2.getSeconds());
            return n != 0 ? n : Integer.compare(duration.getNanos(), duration2.getNanos());
        }
    };

    private Durations() {
    }

    public static Comparator<Duration> comparator() {
        return COMPARATOR;
    }

    public static int compare(Duration duration, Duration duration2) {
        return COMPARATOR.compare(duration, duration2);
    }

    public static boolean isValid(Duration duration) {
        return Durations.isValid(duration.getSeconds(), duration.getNanos());
    }

    public static boolean isValid(long l, int n) {
        if (l < -315576000000L || l > 315576000000L) {
            return false;
        }
        if ((long)n < -999999999L || (long)n >= 1000000000L) {
            return false;
        }
        return l >= 0L && n >= 0 || l <= 0L && n <= 0;
    }

    public static Duration checkValid(Duration duration) {
        int n;
        long l = duration.getSeconds();
        if (!Durations.isValid(l, n = duration.getNanos())) {
            throw new IllegalArgumentException(String.format("Duration is not valid. See proto definition for valid values. Seconds (%s) must be in range [-315,576,000,000, +315,576,000,000]. Nanos (%s) must be in range [-999,999,999, +999,999,999]. Nanos must have the same sign as seconds", l, n));
        }
        return duration;
    }

    public static String toString(Duration duration) {
        Durations.checkValid(duration);
        long l = duration.getSeconds();
        int n = duration.getNanos();
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L || n < 0) {
            stringBuilder.append("-");
            l = -l;
            n = -n;
        }
        stringBuilder.append(l);
        if (n != 0) {
            stringBuilder.append(".");
            stringBuilder.append(Timestamps.formatNanos(n));
        }
        stringBuilder.append("s");
        return stringBuilder.toString();
    }

    public static Duration parse(String string) throws ParseException {
        int n;
        if (string.isEmpty() || string.charAt(string.length() - 1) != 's') {
            throw new ParseException("Invalid duration string: " + string, 0);
        }
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            string = string.substring(1);
        }
        String string2 = string.substring(0, string.length() - 1);
        String string3 = "";
        int n2 = string2.indexOf(46);
        if (n2 != -1) {
            string3 = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
        }
        long l = Long.parseLong(string2);
        int n3 = n = string3.isEmpty() ? 0 : Timestamps.parseNanos(string3);
        if (l < 0L) {
            throw new ParseException("Invalid duration string: " + string, 0);
        }
        if (bl) {
            l = -l;
            n = -n;
        }
        try {
            return Durations.normalizedDuration(l, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    public static Duration fromSeconds(long l) {
        return Durations.normalizedDuration(l, 0);
    }

    public static long toSeconds(Duration duration) {
        return Durations.checkValid(duration).getSeconds();
    }

    public static Duration fromMillis(long l) {
        return Durations.normalizedDuration(l / 1000L, (int)(l % 1000L * 1000000L));
    }

    public static long toMillis(Duration duration) {
        Durations.checkValid(duration);
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)duration.getSeconds(), (long)1000L), (long)((long)duration.getNanos() / 1000000L));
    }

    public static Duration fromMicros(long l) {
        return Durations.normalizedDuration(l / 1000000L, (int)(l % 1000000L * 1000L));
    }

    public static long toMicros(Duration duration) {
        Durations.checkValid(duration);
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)duration.getSeconds(), (long)1000000L), (long)((long)duration.getNanos() / 1000L));
    }

    public static Duration fromNanos(long l) {
        return Durations.normalizedDuration(l / 1000000000L, (int)(l % 1000000000L));
    }

    public static long toNanos(Duration duration) {
        Durations.checkValid(duration);
        return LongMath.checkedAdd((long)LongMath.checkedMultiply((long)duration.getSeconds(), (long)1000000000L), (long)duration.getNanos());
    }

    public static Duration add(Duration duration, Duration duration2) {
        Durations.checkValid(duration);
        Durations.checkValid(duration2);
        return Durations.normalizedDuration(LongMath.checkedAdd((long)duration.getSeconds(), (long)duration2.getSeconds()), IntMath.checkedAdd((int)duration.getNanos(), (int)duration2.getNanos()));
    }

    public static Duration subtract(Duration duration, Duration duration2) {
        Durations.checkValid(duration);
        Durations.checkValid(duration2);
        return Durations.normalizedDuration(LongMath.checkedSubtract((long)duration.getSeconds(), (long)duration2.getSeconds()), IntMath.checkedSubtract((int)duration.getNanos(), (int)duration2.getNanos()));
    }

    static Duration normalizedDuration(long l, int n) {
        if ((long)n <= -1000000000L || (long)n >= 1000000000L) {
            l = LongMath.checkedAdd((long)l, (long)((long)n / 1000000000L));
            n = (int)((long)n % 1000000000L);
        }
        if (l > 0L && n < 0) {
            n = (int)((long)n + 1000000000L);
            --l;
        }
        if (l < 0L && n > 0) {
            n = (int)((long)n - 1000000000L);
            ++l;
        }
        Duration duration = Duration.newBuilder().setSeconds(l).setNanos(n).build();
        return Durations.checkValid(duration);
    }
}

