/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.operations;

import com.hazelcast.concurrent.lock.LockDataSerializerHook;
import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public abstract class BaseLockOperation
extends AbstractOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    public static final int ANY_THREAD = 0;
    protected ObjectNamespace namespace;
    protected Data key;
    protected long threadId;
    protected long leaseTime = -1L;
    protected transient Object response;
    private transient boolean asyncBackup;
    private long referenceCallId;

    public BaseLockOperation() {
    }

    protected BaseLockOperation(ObjectNamespace namespace, Data key, long threadId) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
    }

    protected BaseLockOperation(ObjectNamespace namespace, Data key, long threadId, long timeout) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
        this.setWaitTimeout(timeout);
    }

    public BaseLockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
        this.leaseTime = leaseTime;
        this.setWaitTimeout(timeout);
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    protected final LockStoreImpl getLockStore() {
        LockServiceImpl service = (LockServiceImpl)this.getService();
        return service.getLockStore(this.getPartitionId(), this.namespace);
    }

    public final int getSyncBackupCount() {
        if (this.asyncBackup) {
            return 0;
        }
        return this.getLockStore().getBackupCount();
    }

    public final int getAsyncBackupCount() {
        LockStoreImpl lockStore = this.getLockStore();
        if (this.asyncBackup) {
            return lockStore.getBackupCount() + lockStore.getAsyncBackupCount();
        }
        return lockStore.getAsyncBackupCount();
    }

    public final void setAsyncBackup(boolean asyncBackup) {
        this.asyncBackup = asyncBackup;
    }

    @Override
    protected void onSetCallId() {
        if (this.referenceCallId == 0L) {
            this.referenceCallId = this.getCallId();
        }
    }

    protected final void setReferenceCallId(long refCallId) {
        this.referenceCallId = refCallId;
    }

    protected final long getReferenceCallId() {
        return this.referenceCallId != 0L ? this.referenceCallId : this.getCallId();
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    public final Data getKey() {
        return this.key;
    }

    @Override
    public int getFactoryId() {
        return LockDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.namespace);
        out.writeData(this.key);
        out.writeLong(this.threadId);
        out.writeLong(this.leaseTime);
        out.writeLong(this.referenceCallId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.namespace = (ObjectNamespace)in.readObject();
        this.key = in.readData();
        this.threadId = in.readLong();
        this.leaseTime = in.readLong();
        this.referenceCallId = in.readLong();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", namespace=").append(this.namespace);
    }
}

