/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.deps;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.lower.Lower;
import com.google.turbine.proto.DepsProto;
import java.io.BufferedInputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Dependencies {
    public static DepsProto.Dependencies collectDeps(Optional<String> targetLabel, ClassPath bootclasspath, Binder.BindingResult bound, Lower.Lowered lowered) {
        DepsProto.Dependencies.Builder deps = DepsProto.Dependencies.newBuilder();
        Set<ClassSymbol> closure = Dependencies.superTypeClosure(bound, lowered);
        Dependencies.addPackageInfos(closure, bound);
        LinkedHashSet<String> jars = new LinkedHashSet<String>();
        for (ClassSymbol sym : closure) {
            BytecodeBoundClass info = bound.classPathEnv().get(sym);
            if (info == null) continue;
            String jarFile = info.jarFile();
            if (bootclasspath.env().get(sym) != null) continue;
            jars.add(jarFile);
        }
        for (String jarFile : jars) {
            deps.addDependency(DepsProto.Dependency.newBuilder().setPath(jarFile).setKind(DepsProto.Dependency.Kind.EXPLICIT));
        }
        deps.setSuccess(true);
        if (targetLabel.isPresent()) {
            deps.setRuleLabel((String)targetLabel.get());
        }
        return deps.build();
    }

    private static Set<ClassSymbol> superTypeClosure(Binder.BindingResult bound, Lower.Lowered lowered) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(bound.units())).append(bound.classPathEnv());
        LinkedHashSet<ClassSymbol> closure = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : lowered.symbols()) {
            Dependencies.addSuperTypes(closure, env, sym);
        }
        return closure;
    }

    private static void addSuperTypes(Set<ClassSymbol> closure, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym) {
        if (!closure.add(sym)) {
            return;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return;
        }
        if (info.superclass() != null) {
            Dependencies.addSuperTypes(closure, env, info.superclass());
        }
        for (ClassSymbol i : info.interfaces()) {
            Dependencies.addSuperTypes(closure, env, i);
        }
    }

    private static void addPackageInfos(Set<ClassSymbol> closure, Binder.BindingResult bound) {
        LinkedHashSet<ClassSymbol> packages = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : closure) {
            int idx = sym.binaryName().lastIndexOf(47);
            if (idx == -1) continue;
            packages.add(new ClassSymbol(sym.binaryName().substring(0, idx) + "/package-info"));
        }
        for (ClassSymbol pkg : packages) {
            if (bound.classPathEnv().get(pkg) == null) continue;
            closure.add(pkg);
        }
    }

    public static Collection<String> reduceClasspath(ImmutableList<String> transitiveClasspath, ImmutableMap<String, String> directJarsToTargets, ImmutableList<String> depsArtifacts) {
        if (directJarsToTargets.isEmpty()) {
            return transitiveClasspath;
        }
        HashSet<String> reduced = new HashSet<String>((Collection<String>)directJarsToTargets.keySet());
        for (String path : depsArtifacts) {
            DepsProto.Dependencies.Builder deps = DepsProto.Dependencies.newBuilder();
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
                deps.mergeFrom(is);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            block16: for (DepsProto.Dependency dep : deps.build().getDependencyList()) {
                switch (dep.getKind()) {
                    case EXPLICIT: 
                    case IMPLICIT: {
                        reduced.add(dep.getPath());
                        continue block16;
                    }
                    case INCOMPLETE: 
                    case UNUSED: {
                        continue block16;
                    }
                }
                throw new AssertionError((Object)dep.getKind());
            }
        }
        return Collections2.filter(transitiveClasspath, (Predicate)Predicates.in(reduced));
    }
}

