/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.JobException;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPException;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.QNm;
import org.basex.server.LoginException;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class BaseXServlet
extends HttpServlet {
    private String username;
    private StaticOptions.AuthMethod auth;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        HTTPContext hc = HTTPContext.get();
        try {
            hc.init(config.getServletContext());
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
        Iterator ex = Collections.list(config.getInitParameterNames()).iterator();
        while (ex.hasNext()) {
            String n;
            String name = n = (String)ex.next();
            String value = config.getInitParameter(name);
            if (!name.startsWith("org.basex.")) continue;
            if ((name = name.substring("org.basex.".length())).equalsIgnoreCase(StaticOptions.USER.name())) {
                this.username = value;
                continue;
            }
            if (!name.equalsIgnoreCase(StaticOptions.AUTHMETHOD.name())) continue;
            this.auth = StaticOptions.AuthMethod.valueOf((String)value);
        }
        Context ctx = hc.context();
        if (ctx.soptions.get(StaticOptions.LOGTRACE).booleanValue()) {
            ctx.setExternal((Object)ctx.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HTTPConnection conn = new HTTPConnection(request, response, this.auth);
        try {
            conn.authenticate(this.username);
            this.run(conn);
            if (!Prop.debug) return;
        }
        catch (HTTPException ex22) {
            conn.error(ex22.getStatus(), Util.message((Throwable)ex22));
            if (!Prop.debug) return;
            Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
            for (String name : Collections.list(request.getHeaderNames())) {
                Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
            }
            Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
            for (String name : response.getHeaderNames()) {
                Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
            }
            return;
            catch (LoginException ex2222) {
                conn.error(401, Util.message((Throwable)ex2222));
                if (!Prop.debug) return;
                Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
                for (String name : Collections.list(request.getHeaderNames())) {
                    Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
                }
                Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
                for (String name : response.getHeaderNames()) {
                    Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
                }
                return;
                catch (QueryException ex322) {
                    int code = 500;
                    boolean full = conn.context.soptions.get(StaticOptions.RESTXQERRORS);
                    QNm qname = ex322.qname();
                    if (Token.eq((byte[])qname.uri(), (byte[])QueryText.REST_URI)) {
                        Value value = ex322.value();
                        if (value instanceof ANum) {
                            ANum num = (ANum)value;
                            code = (int)num.itr();
                        }
                        full = false;
                    }
                    conn.error(code, full ? Util.message((Throwable)ex322) : ex322.getLocalizedMessage());
                    if (!Prop.debug) return;
                    Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
                    for (String name : Collections.list(request.getHeaderNames())) {
                        Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
                    }
                    Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
                    for (String name : response.getHeaderNames()) {
                        Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
                    }
                    return;
                    catch (IOException ex422) {
                        boolean full2 = conn.context.soptions.get(StaticOptions.RESTXQERRORS);
                        conn.error(500, full2 ? Util.message((Throwable)ex422) : ex422.getLocalizedMessage());
                        if (!Prop.debug) return;
                        Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
                        for (String name : Collections.list(request.getHeaderNames())) {
                            Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
                        }
                        Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
                        for (String name : response.getHeaderNames()) {
                            Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
                        }
                        return;
                        catch (JobException ex522) {
                            conn.stop(ex522);
                            if (!Prop.debug) return;
                            Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
                            for (String name : Collections.list(request.getHeaderNames())) {
                                Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
                            }
                            Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
                            for (String name : response.getHeaderNames()) {
                                Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
                            }
                            return;
                            catch (Exception ex6) {
                                try {
                                    String message = Util.bug((Throwable)ex6);
                                    Util.errln((Object)message, (Object[])new Object[0]);
                                    conn.error(500, Util.info((Object)"Unexpected error: %", (Object[])new Object[]{message}));
                                    if (!Prop.debug) return;
                                }
                                catch (Throwable throwable) {
                                    if (!Prop.debug) throw throwable;
                                    Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
                                    for (String name : Collections.list(request.getHeaderNames())) {
                                        Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
                                    }
                                    Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
                                    for (String name : response.getHeaderNames()) {
                                        Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
                                    }
                                    throw throwable;
                                }
                                Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
                                for (String name : Collections.list(request.getHeaderNames())) {
                                    Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
                                }
                                Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
                                for (String name : response.getHeaderNames()) {
                                    Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
                                }
                                return;
                            }
                        }
                    }
                }
            }
        }
        Util.errln((Object)("Request: " + request.getMethod() + " " + String.valueOf(request.getRequestURL())), (Object[])new Object[0]);
        for (String name : Collections.list(request.getHeaderNames())) {
            Util.errln((Object)("* " + name + ": " + request.getHeader(name)), (Object[])new Object[0]);
        }
        Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
        for (String name : response.getHeaderNames()) {
            Util.errln((Object)("* " + name + ": " + response.getHeader(name)), (Object[])new Object[0]);
        }
        return;
    }

    protected abstract void run(HTTPConnection var1) throws Exception;
}

