/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Iterator;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.TreeSlice;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.LeafNode;
import org.basex.query.value.seq.tree.PartialLeafNode;
import org.basex.query.value.seq.tree.SmallSeq;
import org.basex.query.value.seq.tree.TreeSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Util;

public final class BigSeq
extends TreeSeq {
    final Item[] left;
    final FingerTree<Item, Item> middle;
    final Item[] right;

    BigSeq(Item[] left, FingerTree<Item, Item> middle, Item[] right, Type type) {
        super((long)left.length + middle.size() + (long)right.length, type);
        this.left = left;
        this.middle = middle;
        this.right = right;
        assert (left.length >= 4 && left.length <= 19 && right.length >= 4 && right.length <= 19);
    }

    BigSeq(Item[] left, Item[] right, Type type) {
        this(left, FingerTree.empty(), right, type);
    }

    @Override
    public Item itemAt(long index) {
        int ll = this.left.length;
        if (index < (long)ll) {
            return this.left[(int)index];
        }
        long me = this.size - (long)this.right.length;
        if (index >= me) {
            return this.right[(int)(index - me)];
        }
        return this.middle.get(index - (long)ll);
    }

    @Override
    public TreeSeq reverse(QueryContext qc) {
        int i;
        qc.checkStop();
        int ll = this.left.length;
        int rl = this.right.length;
        Item[] newLeft = new Item[rl];
        Item[] newRight = new Item[ll];
        for (i = 0; i < rl; ++i) {
            newLeft[i] = this.right[rl - 1 - i];
        }
        for (i = 0; i < ll; ++i) {
            newRight[i] = this.left[ll - 1 - i];
        }
        return new BigSeq(newLeft, this.middle.reverse(qc), newRight, this.type);
    }

    @Override
    public Value insertValue(long pos, Value value, QueryContext qc) {
        qc.checkStop();
        if (value.size() > 1L) {
            return this.copyInsert(pos, value, qc);
        }
        Item item = (Item)value;
        Type tp = this.type.union(item.type);
        int ll = this.left.length;
        if (pos <= (long)ll) {
            int p = (int)pos;
            Item[] temp = BigSeq.slice(this.left, 0, ll + 1);
            Array.copy(temp, p, ll - p, temp, p + 1);
            temp[p] = item;
            if (ll < 19) {
                return new BigSeq(temp, this.middle, this.right, tp);
            }
            int m = (ll + 1) / 2;
            return new BigSeq(BigSeq.slice(temp, 0, m), this.middle.prepend(new LeafNode(BigSeq.slice(temp, m, ll + 1))), this.right, tp);
        }
        long ms = this.middle.size();
        if (pos - (long)ll < ms) {
            return new BigSeq(this.left, this.middle.insert(pos - (long)ll, item, qc), this.right, tp);
        }
        int rl = this.right.length;
        int p = (int)(pos - (long)ll - ms);
        Item[] temp = BigSeq.slice(this.right, 0, rl + 1);
        Array.copy(temp, p, rl - p, temp, p + 1);
        temp[p] = item;
        if (rl < 19) {
            return new BigSeq(this.left, this.middle, temp, tp);
        }
        int m = (rl + 1) / 2;
        return new BigSeq(this.left, this.middle.append(new LeafNode(BigSeq.slice(temp, 0, m))), BigSeq.slice(temp, m, rl + 1), tp);
    }

    @Override
    public TreeSeq removeItem(long pos, QueryContext qc) {
        qc.checkStop();
        int ll = this.left.length;
        int rl = this.right.length;
        if (pos < (long)ll) {
            int p = (int)pos;
            if (ll > 4) {
                Item[] newLeft = new Item[ll - 1];
                Array.copy(this.left, p, newLeft);
                Array.copy(this.left, p + 1, newLeft.length - p, newLeft, p);
                return new BigSeq(newLeft, this.middle, this.right, this.type);
            }
            if (this.middle.isEmpty()) {
                int n = ll - 1 + rl;
                Item[] vals = new Item[n];
                Array.copy(this.left, p, vals);
                Array.copy(this.left, p + 1, ll - 1 - p, vals, p);
                Array.copyFromStart(this.right, rl, vals, ll - 1);
                return this.fromMerged(vals);
            }
            Item[] head = ((LeafNode)this.middle.head()).values;
            int hl = head.length;
            int n = ll - 1 + hl;
            if (hl > 8) {
                int move = (hl - 8 + 1) / 2;
                Item[] newLeft = new Item[ll - 1 + move];
                Array.copy(this.left, p, newLeft);
                Array.copy(this.left, p + 1, ll - 1 - p, newLeft, p);
                Array.copyFromStart(head, move, newLeft, ll - 1);
                Item[] newHead = BigSeq.slice(head, move, hl);
                return new BigSeq(newLeft, this.middle.replaceHead(new LeafNode(newHead)), this.right, this.type);
            }
            Item[] newLeft = new Item[n];
            Array.copy(this.left, p, newLeft);
            Array.copy(this.left, p + 1, ll - 1 - p, newLeft, p);
            Array.copyFromStart(head, hl, newLeft, ll - 1);
            return new BigSeq(newLeft, this.middle.tail(), this.right, this.type);
        }
        long ms = this.middle.size();
        long ro = (long)this.left.length + ms;
        if (pos >= ro) {
            int p = (int)(pos - ro);
            if (rl > 4) {
                Item[] newRight = new Item[rl - 1];
                Array.copy(this.right, p, newRight);
                Array.copy(this.right, p + 1, rl - 1 - p, newRight, p);
                return new BigSeq(this.left, this.middle, newRight, this.type);
            }
            if (this.middle.isEmpty()) {
                int n = ll + rl - 1;
                Item[] vals = new Item[n];
                Array.copy(this.left, ll, vals);
                Array.copyFromStart(this.right, p, vals, ll);
                Array.copy(this.right, p + 1, rl - 1 - p, vals, ll + p);
                return this.fromMerged(vals);
            }
            Item[] last = ((LeafNode)this.middle.foot()).values;
            int sl = last.length;
            int n = sl + rl - 1;
            if (sl > 8) {
                int move = (sl - 8 + 1) / 2;
                Item[] newLast = BigSeq.slice(last, 0, sl - move);
                Item[] newRight = new Item[rl - 1 + move];
                Array.copyToStart(last, sl - move, move, newRight);
                Array.copyFromStart(this.right, p, newRight, move);
                Array.copy(this.right, p + 1, rl - 1 - p, newRight, move + p);
                return new BigSeq(this.left, this.middle.replaceLast(new LeafNode(newLast)), newRight, this.type);
            }
            Item[] newRight = new Item[n];
            Array.copy(last, sl, newRight);
            Array.copyFromStart(this.right, p, newRight, sl);
            Array.copy(this.right, p + 1, rl - 1 - p, newRight, sl + p);
            return new BigSeq(this.left, this.middle.trunk(), newRight, this.type);
        }
        TreeSlice<Item, Item> slice = this.middle.remove(pos - (long)ll, qc);
        if (slice.isTree()) {
            return new BigSeq(this.left, slice.getTree(), this.right, this.type);
        }
        Item[] mid = ((PartialLeafNode)slice.getPartial()).elems;
        int ml = mid.length;
        if (ll > rl) {
            int move = (ll - 4 + 1) / 2;
            Item[] newLeft = BigSeq.slice(this.left, 0, ll - move);
            Item[] newMid = BigSeq.slice(this.left, ll - move, ll + ml);
            Array.copyFromStart(mid, ml, newMid, move);
            return new BigSeq(newLeft, FingerTree.singleton(new LeafNode(newMid)), this.right, this.type);
        }
        if (rl > 4) {
            int move = (rl - 4 + 1) / 2;
            Item[] newMid = BigSeq.slice(mid, 0, ml + move);
            Array.copyFromStart(this.right, move, newMid, ml);
            Item[] newRight = BigSeq.slice(this.right, move, rl);
            return new BigSeq(this.left, FingerTree.singleton(new LeafNode(newMid)), newRight, this.type);
        }
        int hl = ml / 2;
        int mr = ml - hl;
        Item[] newLeft = BigSeq.slice(this.left, 0, ll + hl);
        Array.copyFromStart(mid, hl, newLeft, ll);
        Item[] newRight = BigSeq.slice(this.right, -mr, rl);
        Array.copyToStart(mid, hl, mr, newRight);
        return new BigSeq(newLeft, newRight, this.type);
    }

    @Override
    protected Seq subSeq(long pos, long length, QueryContext qc) {
        Item[] newRight;
        FingerTree<Item, Item> newMiddle;
        FingerTree<Item, Item> mid1;
        Item[] newLeft;
        FingerTree<Item, Item> mid;
        int inRight;
        qc.checkStop();
        int ll = this.left.length;
        int rl = this.right.length;
        long ms = this.middle.size();
        long end = pos + length;
        if (end <= (long)ll) {
            int p = (int)pos;
            int n = (int)length;
            if (length <= 7L) {
                return new SmallSeq(BigSeq.slice(this.left, p, p + n), this.type);
            }
            int mid2 = p + n / 2;
            return new BigSeq(BigSeq.slice(this.left, p, mid2), BigSeq.slice(this.left, mid2, p + n), this.type);
        }
        long ro = (long)ll + ms;
        if (pos >= ro) {
            int p = (int)(pos - ro);
            int n = (int)length;
            if (length <= 7L) {
                return new SmallSeq(BigSeq.slice(this.right, p, p + n), this.type);
            }
            int mid3 = p + n / 2;
            return new BigSeq(BigSeq.slice(this.right, p, mid3), BigSeq.slice(this.right, mid3, p + n), this.type);
        }
        int inLeft = pos < (long)ll ? (int)((long)ll - pos) : 0;
        int n = inRight = end > ro ? (int)(end - ro) : 0;
        if (inLeft >= 4 && inRight >= 4) {
            Item[] newLeft2 = inLeft == ll ? this.left : BigSeq.slice(this.left, (int)pos, ll);
            Item[] newRight2 = inRight == rl ? this.right : BigSeq.slice(this.right, 0, inRight);
            return new BigSeq(newLeft2, this.middle, newRight2, this.type);
        }
        if (this.middle.isEmpty()) {
            Item[] out;
            if (inLeft == 0) {
                out = inRight == rl ? this.right : BigSeq.slice(this.right, 0, inRight);
            } else if (inRight == 0) {
                out = inLeft == ll ? this.left : BigSeq.slice(this.left, ll - inLeft, ll);
            } else {
                out = BigSeq.slice(this.left, ll - inLeft, ll + inRight);
                Array.copyFromStart(this.right, inRight, out, inLeft);
            }
            return this.fromMerged(out);
        }
        long inMiddle = length - (long)inLeft - (long)inRight;
        if (inMiddle == ms) {
            mid = this.middle;
        } else {
            long off = pos < (long)ll ? 0L : pos - (long)ll;
            TreeSlice<Item, Item> slice = this.middle.slice(off, inMiddle);
            if (!slice.isTree()) {
                Item[] single = ((PartialLeafNode)slice.getPartial()).elems;
                int sl = single.length;
                if (inLeft > 0) {
                    Item[] out = BigSeq.slice(this.left, (int)pos, ll + sl);
                    Array.copyFromStart(single, sl, out, inLeft);
                    return this.fromMerged(out);
                }
                if (inRight > 0) {
                    Item[] out = BigSeq.slice(single, 0, sl + inRight);
                    Array.copyFromStart(this.right, inRight, out, sl);
                    return this.fromMerged(out);
                }
                return new SmallSeq(single, this.type);
            }
            mid = slice.getTree();
        }
        int off = ll - inLeft;
        if (inLeft >= 4) {
            newLeft = inLeft == ll ? this.left : BigSeq.slice(this.left, off, ll);
            mid1 = mid;
        } else {
            Item[] head = ((LeafNode)mid.head()).values;
            if (inLeft == 0) {
                newLeft = head;
            } else {
                newLeft = BigSeq.slice(head, -inLeft, head.length);
                Array.copyToStart(this.left, off, inLeft, newLeft);
            }
            mid1 = mid.tail();
        }
        if (inRight >= 4) {
            newMiddle = mid1;
            newRight = inRight == rl ? this.right : BigSeq.slice(this.right, 0, inRight);
        } else if (!mid1.isEmpty()) {
            Item[] last = ((LeafNode)mid1.foot()).values;
            int sl = last.length;
            newMiddle = mid1.trunk();
            if (inRight == 0) {
                newRight = last;
            } else {
                newRight = BigSeq.slice(last, 0, sl + inRight);
                Array.copyFromStart(this.right, inRight, newRight, sl);
            }
        } else {
            if (inRight == 0) {
                return this.fromMerged(newLeft);
            }
            int nll = newLeft.length;
            int n2 = nll + inRight;
            Item[] out = BigSeq.slice(newLeft, 0, n2);
            Array.copyFromStart(this.right, inRight, out, nll);
            return this.fromMerged(out);
        }
        return new BigSeq(newLeft, newMiddle, newRight, this.type);
    }

    private TreeSeq fromMerged(Item[] merged) {
        int ml = merged.length;
        if (ml <= 7) {
            return new SmallSeq(merged, this.type);
        }
        int mid = ml / 2;
        return new BigSeq(BigSeq.slice(merged, 0, mid), BigSeq.slice(merged, mid, ml), this.type);
    }

    @Override
    TreeSeq concat(TreeSeq seq) {
        Type tp = this.type.union(seq.type);
        if (seq instanceof SmallSeq) {
            SmallSeq ss = (SmallSeq)seq;
            Item[] newRight = BigSeq.concat(this.right, ss.items);
            int nrl = newRight.length;
            if (nrl <= 19) {
                return new BigSeq(this.left, this.middle, newRight, tp);
            }
            int mid = nrl / 2;
            Item[] leaf = BigSeq.slice(newRight, 0, mid);
            FingerTree<Item, Item> newMid = this.middle.append(new LeafNode(leaf));
            return new BigSeq(this.left, newMid, BigSeq.slice(newRight, mid, nrl), tp);
        }
        BigSeq other = (BigSeq)seq;
        Item[] ls = this.right;
        Item[] rs = other.left;
        int ns = ls.length;
        int ne = ns + rs.length;
        int k = (ne + 15 - 1) / 15;
        int s = (ne + k - 1) / k;
        Node[] midNodes = new Node[k];
        int p = 0;
        for (int i = 0; i < k; ++i) {
            int curr = Math.min(ne - p, s);
            Item[] arr = new Item[curr];
            int j = 0;
            while (j < curr) {
                arr[j] = p < ns ? ls[p] : rs[p - ns];
                ++j;
                ++p;
            }
            midNodes[i] = new LeafNode(arr);
        }
        return new BigSeq(this.left, this.middle.concat(midNodes, ne, other.middle), other.right, tp);
    }

    @Override
    public ListIterator<Item> iterator(long start) {
        ListIterator<Item> sub;
        int startPos;
        final Item[] ls = this.left;
        final Item[] rs = this.right;
        final int ll = ls.length;
        final int rl = rs.length;
        final long ms = this.middle.size();
        if (start < (long)ll) {
            startPos = (int)start - ll;
            sub = this.middle.listIterator(0L);
        } else if (start - (long)ll < ms) {
            startPos = 0;
            sub = this.middle.listIterator(start - (long)ll);
        } else {
            startPos = (int)(start - (long)ll - ms) + 1;
            sub = this.middle.listIterator(ms);
        }
        return new ListIterator<Item>(){
            int pos;
            {
                this.pos = startPos;
            }

            @Override
            public int nextIndex() {
                return this.pos < 0 ? ll + this.pos : (this.pos > 0 ? (int)((long)ll + ms + (long)this.pos - 1L) : ll + sub.nextIndex());
            }

            @Override
            public boolean hasNext() {
                return this.pos <= rl;
            }

            @Override
            public Item next() {
                if (this.pos < 0) {
                    return ls[ll + this.pos++];
                }
                if (this.pos == 0) {
                    if (sub.hasNext()) {
                        return (Item)sub.next();
                    }
                    this.pos = 1;
                }
                return rs[this.pos++ - 1];
            }

            @Override
            public int previousIndex() {
                return this.pos < 0 ? ll + this.pos - 1 : (this.pos > 0 ? (int)((long)ll + ms + (long)this.pos - 2L) : ll + sub.previousIndex());
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > -ll;
            }

            @Override
            public Item previous() {
                if (this.pos > 0 && --this.pos > 0) {
                    return rs[this.pos - 1];
                }
                if (this.pos == 0) {
                    if (sub.hasPrevious()) {
                        return (Item)sub.previous();
                    }
                    this.pos = -1;
                    return ls[ll - 1];
                }
                return ls[ll + --this.pos];
            }

            @Override
            public void add(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void set(Item e) {
                throw Util.notExpected();
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){
            private Iterator<Item> sub;

            @Override
            public Item next() {
                long p;
                if (this.pos >= this.size) {
                    return null;
                }
                if ((p = this.pos++) < (long)BigSeq.this.left.length) {
                    return BigSeq.this.left[(int)p];
                }
                long r = this.size - (long)BigSeq.this.right.length;
                if (p >= r) {
                    return BigSeq.this.right[(int)(p - r)];
                }
                if (this.sub == null) {
                    this.sub = BigSeq.this.middle.iterator();
                }
                return this.sub.next();
            }

            @Override
            public Item get(long i) {
                return BigSeq.this.itemAt(i);
            }

            @Override
            public boolean valueIter() {
                return true;
            }

            @Override
            public BigSeq value(QueryContext qc, Expr expr) {
                return BigSeq.this;
            }
        };
    }

    @Override
    TreeSeq prepend(SmallSeq seq) {
        Type tp = this.type.union(seq.type);
        Item[] values = seq.items;
        int vl = values.length;
        int ll = this.left.length;
        int n = vl + ll;
        if (n <= 19) {
            return new BigSeq(BigSeq.concat(values, this.left), this.middle, this.right, tp);
        }
        if (vl >= 4 && 8 <= ll && ll <= 15) {
            return new BigSeq(values, this.middle.prepend(new LeafNode(this.left)), this.right, tp);
        }
        int mid = n / 2;
        int move = mid - vl;
        Item[] newLeft = BigSeq.slice(values, 0, mid);
        Array.copyFromStart(this.left, move, newLeft, vl);
        LeafNode leaf = new LeafNode(BigSeq.slice(this.left, move, ll));
        return new BigSeq(newLeft, this.middle.prepend(leaf), this.right, tp);
    }
}

