/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.And;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpIR;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Filter;
import org.basex.query.expr.If;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pipeline;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Count;
import org.basex.query.expr.gflwor.Eval;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.ForLet;
import org.basex.query.expr.gflwor.GroupBy;
import org.basex.query.expr.gflwor.GroupSpec;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.expr.gflwor.OrderBy;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.expr.gflwor.While;
import org.basex.query.expr.gflwor.Window;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnError;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.BitArray;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class GFLWOR
extends ParseExpr {
    private final LinkedList<Clause> clauses;
    private Expr rtrn;

    public GFLWOR(InputInfo info, LinkedList<Clause> clauses, Expr rtrn) {
        super(info, Types.ITEM_ZM);
        this.clauses = clauses;
        this.rtrn = rtrn;
    }

    public GFLWOR(InputInfo info, Clause clause, Expr rtrn) {
        this(info, new LinkedList<Clause>(), rtrn);
        this.clauses.add(clause);
    }

    private Eval newEval() {
        Eval eval = new StartEval();
        for (Clause clause : this.clauses) {
            eval = clause.eval(eval);
        }
        return eval;
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            private final Eval eval;
            private Iter iter;
            {
                this.eval = GFLWOR.this.newEval();
                this.iter = Empty.ITER;
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(this.iter)) == null) {
                    if (!this.eval.next(qc)) {
                        this.iter = null;
                        return null;
                    }
                    this.iter = GFLWOR.this.rtrn.iter(qc);
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Eval eval = this.newEval();
        ValueBuilder vb = new ValueBuilder(qc, this.size());
        while (eval.next(qc)) {
            vb.add(this.rtrn.value(qc));
        }
        return vb.value(this);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        ListIterator<Clause> iter = this.clauses.listIterator();
        try {
            while (iter.hasNext()) {
                ((Clause)iter.next()).compile(cc);
            }
        }
        catch (QueryException ex) {
            iter.remove();
            this.clauseError(ex, iter);
        }
        try {
            this.rtrn = this.rtrn.compile(cc);
        }
        catch (QueryException ex) {
            this.clauseError(ex, iter);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.flattenAnd();
        while (this.flattenReturn(cc) | this.flattenFor(cc) | this.unnestFLWR(cc) | this.unnestLets(cc) | this.ifToWhere(cc) | this.forToLet(cc) | this.slideLetsOut(cc) | this.inlineForLet(cc) | this.unusedClauses(cc) | this.unusedVars(cc) | this.cleanDeadVars() | this.optimizeCond(cc, true) | this.optimizeCond(cc, false) | this.optimizePos(cc) | this.optimizeOrderBy(cc)) {
        }
        this.mergeWheres(cc, true);
        this.mergeWheres(cc, false);
        Expr expr = this.simplify(cc);
        if (expr != null) {
            cc.info("simplify %: %", this::description, expr);
            return expr;
        }
        this.exprType.assign(this.rtrn, this.calcSize(true));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr;
        if (mode == CompileContext.Simplify.COUNT) {
            if (this.clauses.removeIf(OrderBy.class::isInstance)) {
                expr = this.optimize(cc);
                return cc.simplify(this, expr, mode);
            }
        }
        expr = this;
        return cc.simplify(this, expr, mode);
    }

    private Expr simplify(CompileContext cc) throws QueryException {
        long max;
        int cs = this.clauses.size();
        if (cs == 0) {
            return this.rtrn;
        }
        Expr first = this.clauses.getFirst();
        if (first instanceof Where) {
            return new If(this.info, ((Where)this.clauses.removeFirst()).expr, cs == 1 ? this.rtrn : this).optimize(cc);
        }
        if (first instanceof For) {
            GroupBy group;
            GroupSpec spec;
            Expr expr;
            For fr = (For)first;
            if (cs == 1 && fr.size() == 0L && !fr.has(Flag.NDT) && (expr = this.rtrn) instanceof VarRef) {
                VarRef vr = (VarRef)expr;
                if (vr.var == fr.var) {
                    return Empty.VALUE;
                }
            }
            if (cs == 2 && (expr = this.clauses.get(1)) instanceof GroupBy && (spec = (group = (GroupBy)expr).group()) != null) {
                Expr flwor = new GFLWOR(this.info, this.clauses.removeFirst(), spec.expr).optimize(cc);
                Expr expr2 = cc.function(Function.DISTINCT_VALUES, this.info, flwor);
                this.clauses.set(0, new For(spec.var, expr2).optimize(cc));
                return this.optimize(cc);
            }
        }
        if (first instanceof GroupBy) {
            GroupSpec spec;
            GroupBy group = (GroupBy)first;
            if (cs == 1 && (spec = group.group()) != null) {
                Expr expr = cc.function(Function.DATA, this.info, spec.expr);
                this.clauses.set(0, new For(spec.var, expr).optimize(cc));
                return this.optimize(cc);
            }
        }
        Checks<Clause> ndt = clause -> clause.has(Flag.NDT);
        Checks<Clause> varrefs = clause -> {
            for (Var var : clause.vars()) {
                if (this.rtrn.count(var) == VarUsage.NEVER) continue;
                return true;
            }
            return false;
        };
        long[] minMax = this.calcSize(false);
        long min = minMax[0];
        if (min == (max = minMax[1])) {
            if (min == 0L) {
                if (!this.has(Flag.NDT)) {
                    return Empty.VALUE;
                }
            } else if (!varrefs.any(this.clauses) && !ndt.any(this.clauses)) {
                return min == 1L ? this.rtrn : cc.replicate(this.rtrn, Itr.get(min), this.info);
            }
        }
        return this.rtrn == Empty.VALUE && !ndt.any(this.clauses) ? this.rtrn : null;
    }

    private long[] calcSize(boolean ret) {
        long[] minMax = new long[]{1L, 1L};
        for (Clause clause : this.clauses) {
            if (minMax[1] == 0L) continue;
            clause.calcSize(minMax);
        }
        if (ret && minMax[1] != 0L) {
            long size = this.rtrn.size();
            minMax[0] = minMax[0] * Math.max(size, 0L);
            if (minMax[1] > 0L) {
                minMax[1] = size >= 0L ? minMax[1] * size : -1L;
            } else if (size == 0L) {
                minMax[1] = 0L;
            }
        }
        return minMax;
    }

    private void flattenAnd() {
        ListIterator<Where> iter = this.clauses.listIterator();
        while (iter.hasNext()) {
            Clause clause = (Clause)iter.next();
            if (!(clause instanceof Where)) continue;
            Where where = (Where)clause;
            if (!(where.expr instanceof And)) continue;
            iter.remove();
            for (Expr expr : where.expr.args()) {
                iter.add(new Where(expr, where.info()));
            }
        }
    }

    private boolean forToLet(CompileContext cc) throws QueryException {
        boolean changed = false;
        int i = this.clauses.size();
        while (--i >= 0) {
            For fr;
            Clause clause = this.clauses.get(i);
            if (!(clause instanceof For) || !(fr = (For)clause).asLet(this.clauses, i, cc)) continue;
            cc.info("rewrite for to let: %", clause);
            changed = true;
        }
        return changed;
    }

    private boolean unusedVars(CompileContext cc) throws QueryException {
        boolean changed = false;
        ListIterator iter = this.clauses.listIterator();
        while (iter.hasNext()) {
            iter.next();
        }
        while (iter.hasPrevious()) {
            int pos = iter.previousIndex();
            Clause clause = (Clause)iter.previous();
            if (clause instanceof Let) {
                Let lt = (Let)clause;
                if (this.count(lt.var, pos + 1) != VarUsage.NEVER || lt.has(Flag.NDT)) continue;
                cc.info("remove unused variable: %", lt.var);
                lt.var.checkType(lt.expr);
                iter.remove();
                changed = true;
                continue;
            }
            if (!(clause instanceof For)) continue;
            For fr = (For)clause;
            long fs = fr.expr.size();
            if (fs > 1L && fr.var.declType == null && !(fr.expr instanceof SingletonSeq) && !fr.has(Flag.NDT) && this.count(fr.var, pos + 1) == VarUsage.NEVER) {
                if (fr.pos != null && this.count(fr.pos, pos) != VarUsage.NEVER) {
                    fr.expr = cc.replaceWith(fr.expr, RangeSeq.get(1L, fs, true));
                    fr.exprType.assign(AtomType.INTEGER);
                    fr.var = fr.pos;
                    fr.remove(cc, fr.pos);
                } else {
                    fr.expr = cc.replaceWith(fr.expr, SingletonSeq.get(Str.EMPTY, fs));
                    fr.exprType.assign(AtomType.STRING);
                }
                changed = true;
            }
            if (fr.score != null && this.count(fr.score, pos) == VarUsage.NEVER) {
                fr.remove(cc, fr.score);
                changed = true;
            }
            if (fr.pos == null || this.count(fr.pos, pos) != VarUsage.NEVER) continue;
            fr.remove(cc, fr.pos);
            changed = true;
        }
        return changed;
    }

    private boolean unusedClauses(CompileContext cc) {
        boolean changed = false;
        for (int c = this.clauses.size() - 1; c >= 0; --c) {
            Clause clause = this.clauses.get(c);
            if (!(clause instanceof For)) continue;
            For fr = (For)clause;
            if (fr.expr.size() != 0L || fr.empty) continue;
            for (int d = this.clauses.size() - 1; d >= c; --d) {
                this.clauses.remove(c);
            }
            this.rtrn = fr.expr;
            cc.info("simplify %: %", this::description, this);
            changed = true;
        }
        return changed;
    }

    private boolean inlineForLet(CompileContext cc) throws QueryException {
        boolean changed = false;
        int cs = this.clauses.size();
        for (int c = cs - 1; c >= 0; --c) {
            boolean last;
            ForLet fl;
            Expr inline;
            Clause clause = this.clauses.get(c);
            if (!(clause instanceof ForLet) || (inline = (fl = (ForLet)clause).inlineExpr(cc)) == null) continue;
            boolean changing = false;
            if (fl instanceof Let && !fl.has(Flag.NDT)) {
                InlineContext ic = new InlineContext(fl.var, inline, cc);
                ExprList exprs = new ExprList(cs - c);
                for (int d = c + 1; d < cs; ++d) {
                    exprs.add((Expr)this.clauses.get(d));
                }
                if (ic.inlineable((Expr[])((ExprList)((Object)exprs.add(this.rtrn))).finish())) {
                    this.inline(ic, this.clauses.listIterator(c));
                    changing = true;
                }
            }
            boolean bl = last = c + 1 == cs;
            if (!changing && (last || this.clauses.get(c + 1) instanceof ForLet && this.count(fl.var, c + 2) == VarUsage.NEVER)) {
                if (last) {
                    Expr expr = this.inline(inline, this.rtrn, fl, cc);
                    if (expr != null) {
                        this.rtrn = expr;
                        changing = true;
                    }
                } else {
                    Expr expr;
                    ForLet next = (ForLet)this.clauses.get(c + 1);
                    boolean let = fl instanceof Let;
                    boolean nextLet = next instanceof Let;
                    if ((let || (nextLet ? next.size() == 1L : ((For)next).pos == null)) && (expr = this.inline(inline, next.expr, fl, cc)) != null) {
                        next.expr = expr;
                        if (!let && nextLet) {
                            next = ((Let)next).toFor(cc);
                            this.clauses.set(c + 1, next);
                        }
                        next.optimize(cc);
                        changing = true;
                    }
                }
            }
            if (!changing) continue;
            cc.info("inline %", fl);
            this.clauses.remove(c);
            cs = this.clauses.size();
            changed = true;
        }
        return changed;
    }

    private Expr inline(Expr inline, Expr expr, ForLet fl, CompileContext cc) throws QueryException {
        InlineContext ic;
        boolean item;
        if (expr instanceof VarRef) {
            VarRef vr = (VarRef)expr;
            if (vr.var == fl.var) {
                return inline;
            }
        }
        boolean let = fl instanceof Let;
        boolean bl = item = fl.size() == 1L;
        if (let && expr.count(fl.var) == VarUsage.NEVER) {
            return cc.voidAndReturn(inline, expr, this.info);
        }
        if ((let || item) && !expr.has(Flag.CTX) && (ic = new InlineContext(fl.var, new ContextValue(this.info), cc)).inlineable(expr)) {
            Expr inlined = cc.get(inline, item, () -> ic.inline(expr));
            return let ? Pipeline.get(cc, this.info, inline, inlined) : SimpleMap.get(cc, this.info, inline, inlined);
        }
        return null;
    }

    private boolean unnestFLWR(CompileContext cc) throws QueryException {
        boolean thisRound;
        boolean changed = false;
        do {
            thisRound = false;
            ListIterator<Clause> iter = this.clauses.listIterator();
            while (iter.hasNext()) {
                Expr rest;
                Expr expr;
                GFLWOR fl;
                Clause clause = (Clause)iter.next();
                boolean isFor = clause instanceof For;
                boolean isLet = clause instanceof Let;
                if (isFor) {
                    Object object;
                    For fr = (For)clause;
                    if (!fr.empty && fr.pos == null && (object = fr.expr) instanceof GFLWOR && (fl = (GFLWOR)object).isFLW()) {
                        cc.info("flatten nested %: %", this::description, fr.var);
                        iter.remove();
                        object = fl.clauses.iterator();
                        while (object.hasNext()) {
                            Clause cls = (Clause)object.next();
                            iter.add(cls);
                        }
                        fr.expr = fl.rtrn;
                        iter.add(fr);
                        changed = true;
                        thisRound = true;
                    }
                }
                if (thisRound || !isFor && !isLet || !((expr = isFor ? ((For)clause).expr : ((Let)clause).expr) instanceof GFLWOR)) continue;
                fl = (GFLWOR)expr;
                LinkedList<Clause> cls = fl.clauses;
                if (!(cls.getFirst() instanceof Let)) continue;
                iter.remove();
                do {
                    iter.add(cls.removeFirst());
                } while (!cls.isEmpty() && cls.getFirst() instanceof Let);
                Expr expr2 = rest = fl.clauses.isEmpty() ? fl.rtrn : fl.optimize(cc);
                if (isFor) {
                    ((For)clause).expr = rest;
                } else {
                    ((Let)clause).expr = rest;
                }
                iter.add(clause);
                changed = true;
                thisRound = true;
            }
        } while (thisRound);
        return changed;
    }

    private boolean cleanDeadVars() {
        final IntObjectMap<Var> decl = new IntObjectMap<Var>();
        for (Clause clause : this.clauses) {
            for (Var var : clause.vars()) {
                decl.put(var.id, var);
            }
        }
        final BitArray used = new BitArray();
        ASTVisitor marker = new ASTVisitor(){

            @Override
            public boolean used(VarRef ref) {
                int id = ref.var.id;
                if (decl.get(id) != null) {
                    used.set(id);
                }
                return true;
            }
        };
        this.rtrn.accept(marker);
        boolean changed = false;
        int c = this.clauses.size();
        while (--c >= 0) {
            Clause clause = this.clauses.get(c);
            changed |= clause.clean(decl, used);
            clause.accept(marker);
            for (Var var : clause.vars()) {
                used.clear(var.id);
            }
        }
        return changed;
    }

    private boolean slideLetsOut(CompileContext cc) {
        boolean changed = false;
        for (int c = 1; c < this.clauses.size(); ++c) {
            Clause curr;
            Clause clause = this.clauses.get(c);
            if (!(clause instanceof Let)) continue;
            Let let = (Let)clause;
            if (clause.has(Flag.NDT, Flag.CNS)) continue;
            int insert = -1;
            int d = c;
            while (--d >= 0 && (curr = this.clauses.get(d)).skippable(let)) {
                if (!(curr instanceof For) && !(curr instanceof Window)) continue;
                insert = d;
            }
            if (insert < 0) continue;
            cc.info("hoist let clause: %", let);
            this.clauses.add(insert, this.clauses.remove(c));
            changed = true;
        }
        return changed;
    }

    private boolean optimizeCond(CompileContext cc, boolean where) throws QueryException {
        boolean changed = false;
        java.util.function.Function<Clause, Expr> get = clause -> (where ? clause instanceof Where : clause instanceof While) ? (where ? ((Where)clause).expr : ((While)clause).expr) : null;
        HashSet<ForLet> optimized = new HashSet<ForLet>();
        block0: for (int c = 0; c < this.clauses.size(); ++c) {
            Clause curr;
            Clause clause2 = this.clauses.get(c);
            Expr expr = get.apply(clause2);
            if (expr instanceof Bln) {
                cc.info("remove % from %", expr, this::description);
                changed = true;
                if (expr == Bln.TRUE) {
                    this.clauses.remove(c--);
                    continue;
                }
                this.clauses.subList(c, this.clauses.size()).clear();
                this.rtrn = Empty.VALUE;
                continue;
            }
            if (expr == null || expr.has(Flag.NDT)) continue;
            int insert = -1;
            int j = c;
            while (--j >= 0 && !(curr = this.clauses.get(j)).has(Flag.NDT) && curr.skippable(clause2)) {
                if (curr instanceof Where || curr instanceof While) continue;
                insert = j;
            }
            if (insert == -1) {
                insert = c;
            } else {
                this.clauses.add(insert, this.clauses.remove(c));
                cc.info("move where clause: %", expr);
                changed = true;
            }
            if (clause2.has(Flag.CTX)) continue;
            int i = insert;
            while (--i >= 0) {
                ForLet fl;
                block12: {
                    Expr expr2;
                    Predicate<Expr> varRef;
                    block13: {
                        Clause before = this.clauses.get(i);
                        if (get.apply(before) != null) continue;
                        if (!(before instanceof ForLet)) continue block0;
                        fl = (ForLet)before;
                        varRef = e -> {
                            if (!(e instanceof VarRef)) return false;
                            VarRef vr = (VarRef)e;
                            if (vr.var != fl.var) return false;
                            return true;
                        };
                        boolean let = before instanceof Let;
                        if (let && before.seqType().instanceOf(Types.NODE_ZO) && varRef.test(expr)) {
                            this.clauses.set(i, ((Let)before).toFor(cc).optimize(cc));
                            this.clauses.remove(insert);
                            changed = true;
                            --c;
                            continue block0;
                        }
                        if (!where) continue block0;
                        if (!let) break block12;
                        if (c + 1 != this.clauses.size()) continue block0;
                        if (varRef.test(this.rtrn)) break block12;
                        expr2 = this.rtrn;
                        if (!(expr2 instanceof Filter)) break block13;
                        Filter filter = (Filter)expr2;
                        if (varRef.test(filter.root)) break block12;
                    }
                    if (!((expr2 = this.rtrn) instanceof Path)) continue block0;
                    Path path = (Path)expr2;
                    if (!varRef.test(path.root)) continue block0;
                }
                if (!fl.toPredicate(cc, expr)) continue block0;
                optimized.add(fl);
                this.clauses.remove(insert);
                cc.info("rewrite to predicate: %", expr);
                changed = true;
                --c;
                continue block0;
            }
        }
        for (ForLet fl : optimized) {
            fl.expr = fl.expr.optimize(cc);
        }
        return changed;
    }

    private boolean optimizePos(CompileContext cc) throws QueryException {
        boolean changed = false;
        block0: for (int c = 0; c < this.clauses.size(); ++c) {
            Clause clause = this.clauses.get(c);
            if (!(clause instanceof For)) continue;
            For pos = (For)clause;
            if (pos.pos == null) continue;
            for (int d = c + 1; d < this.clauses.size(); ++d) {
                ParseExpr cmp;
                Clause cl = this.clauses.get(d);
                if (!(cl instanceof Where)) {
                    if ((cl instanceof For || cl instanceof Let) && !cl.has(Flag.NDT)) continue;
                    continue block0;
                }
                Expr expr = ((Where)cl).expr;
                if (expr instanceof CmpG) {
                    cmp = (CmpG)expr;
                    expr = CmpIR.get(cc, (CmpG)cmp, true);
                }
                if (!(expr instanceof CmpIR)) continue;
                cmp = (CmpIR)expr;
                if (!(((CmpIR)cmp).expr instanceof VarRef)) continue;
                this.clauses.remove(d);
                if (this.count(pos.pos, c) == VarUsage.NEVER) {
                    pos.addPredicate(cc, IntPos.get(((CmpIR)cmp).min, ((CmpIR)cmp).max, cmp.info()));
                    cc.info("rewrite to predicate: %", expr);
                    changed = true;
                    continue block0;
                }
                this.clauses.add(d, cl);
                continue block0;
            }
        }
        return changed;
    }

    private boolean optimizeOrderBy(CompileContext cc) throws QueryException {
        OrderBy order;
        Clause clause;
        ListIterator iter = this.clauses.listIterator();
        For fr = null;
        while (fr == null && iter.hasNext()) {
            For frr;
            clause = (Clause)iter.next();
            if (!(clause instanceof For)) continue;
            fr = frr = (For)clause;
        }
        if (fr != null && fr.vars.length == 1 && iter.hasNext() && (clause = (Clause)iter.next()) instanceof OrderBy && (order = (OrderBy)clause).merge(fr, cc)) {
            iter.remove();
            return true;
        }
        return false;
    }

    private boolean ifToWhere(CompileContext cc) throws QueryException {
        QueryFunction<Expr, If> rewritableIf = expr -> {
            if (expr instanceof If) {
                If iff = (If)expr;
                if (iff.exprs[0] == Empty.VALUE) {
                    iff.cond = cc.function(Function.NOT, this.info, iff.cond);
                    iff.swap();
                }
                if (iff.exprs[1] == Empty.VALUE) {
                    return iff;
                }
            }
            return null;
        };
        boolean changed = false;
        int c = this.clauses.size();
        while (--c >= 0) {
            Clause clause = this.clauses.get(c);
            if (!(clause instanceof For)) continue;
            For fr = (For)clause;
            If iff = rewritableIf.apply(fr.expr);
            if (iff == null || fr.empty) continue;
            fr.expr = iff.exprs[0];
            this.clauses.add(c, new Where(iff.cond, iff.info()));
            changed = true;
        }
        If iff = rewritableIf.apply(this.rtrn);
        if (iff != null) {
            this.clauses.add(new Where(iff.cond, iff.info()));
            this.rtrn = iff.exprs[0];
            changed = true;
        }
        return changed;
    }

    private boolean flattenFor(CompileContext cc) throws QueryException {
        Clause clause;
        if (!this.clauses.isEmpty() && (clause = this.clauses.getFirst()) instanceof For) {
            For fst = (For)clause;
            if (!fst.empty) {
                Expr expr = fst.expr;
                if (expr instanceof GFLWOR) {
                    GFLWOR sub = (GFLWOR)expr;
                    cc.info("flatten nested %: %", this::description, fst.var);
                    this.clauses.set(0, new For(fst.var, null, fst.score, sub.rtrn, false));
                    if (fst.pos != null) {
                        this.clauses.add(1, new Count(fst.pos));
                    }
                    this.clauses.addAll(0, sub.clauses);
                    return true;
                }
                if (this.clauses.size() > 1 && (expr = this.clauses.get(1)) instanceof Count) {
                    Count cnt = (Count)expr;
                    if (fst.pos != null) {
                        Expr ref = new VarRef(cnt.info(), fst.pos).optimize(cc);
                        this.clauses.set(1, new Let(cnt.var, ref).optimize(cc));
                    } else {
                        this.clauses.set(0, new For(fst.var, cnt.var, fst.score, fst.expr, false).optimize(cc));
                        this.clauses.remove(1);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean flattenReturn(CompileContext cc) {
        GFLWOR sub;
        Expr expr;
        if (!this.clauses.isEmpty() && (expr = this.rtrn) instanceof GFLWOR && (sub = (GFLWOR)expr).isFLW()) {
            ExprInfo exprInfo;
            Clause clause = sub.clauses.getFirst();
            if (clause instanceof ForLet) {
                ForLet fl = (ForLet)clause;
                exprInfo = fl.var;
            } else {
                exprInfo = clause;
            }
            Clause ei = exprInfo;
            cc.info("flatten nested %: %", this::description, ei);
            this.clauses.addAll(sub.clauses);
            this.rtrn = sub.rtrn;
            return true;
        }
        return false;
    }

    private boolean unnestLets(CompileContext cc) throws QueryException {
        if (!this.clauses.isEmpty()) {
            TypeCheck check;
            TypeCheck tc;
            Expr expr = this.rtrn;
            TypeCheck typeCheck = tc = expr instanceof TypeCheck ? (check = (TypeCheck)expr) : null;
            if (this.rtrn instanceof GFLWOR || tc != null && tc.expr instanceof GFLWOR) {
                GFLWOR sub = (GFLWOR)(tc == null ? this.rtrn : tc.expr);
                Clause clause = sub.clauses.getFirst();
                if (clause instanceof Let) {
                    Let let = (Let)clause;
                    cc.info("flatten nested %: %", this::description, let.var);
                    LinkedList<Clause> cls = sub.clauses;
                    do {
                        this.clauses.add(cls.removeFirst());
                    } while (!cls.isEmpty() && cls.getFirst() instanceof Let);
                    if (tc != null) {
                        tc.expr = sub.optimize(cc);
                    }
                    this.rtrn = this.rtrn.optimize(cc);
                    return true;
                }
            }
        }
        return false;
    }

    private void mergeWheres(CompileContext cc, boolean where) throws QueryException {
        ExprList list = new ExprList();
        QueryConsumer<Integer> merge = c -> {
            int ls = list.size();
            Clause clause = this.clauses.get(c - ls);
            for (int l = 1; l < ls; ++l) {
                this.clauses.remove(c - ls);
            }
            InputInfo ii = clause.info();
            Expr and = new And(ii, (Expr[])list.next()).optimize(cc);
            this.clauses.set(c - ls, (where ? new Where(and, ii) : new While(and, ii)).optimize(cc));
        };
        for (int c2 = 0; c2 < this.clauses.size(); ++c2) {
            Clause clause = this.clauses.get(c2);
            int ls = list.size();
            if (where ? clause instanceof Where : clause instanceof While) {
                list.add(where ? ((Where)clause).expr : ((While)clause).expr);
                continue;
            }
            if (ls > 1) {
                merge.accept(c2);
                c2 -= ls + 1;
                continue;
            }
            list.reset();
        }
        if (list.size() > 1) {
            merge.accept(this.clauses.size());
        }
    }

    @Override
    public boolean vacuous() {
        return this.rtrn.vacuous();
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Clause clause : this.clauses) {
            if (!clause.has(flags)) continue;
            return true;
        }
        return this.rtrn.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Clause clause : this.clauses) {
            if (clause.inlineable(ic)) continue;
            return false;
        }
        return this.rtrn.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.count(var, 0);
    }

    private VarUsage count(Var var, int index) {
        long[] minMax = new long[]{1L, 1L};
        VarUsage uses = VarUsage.NEVER;
        ListIterator<Clause> iter = this.clauses.listIterator(index);
        while (iter.hasNext()) {
            Clause clause = iter.next();
            uses = uses.plus(clause.count(var).times(minMax[1]));
            clause.calcSize(minMax);
        }
        return uses.plus(this.rtrn.count(var).times(minMax[1]));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return this.inline(ic, this.clauses.listIterator()) ? this.optimize(ic.cc) : null;
    }

    private boolean inline(InlineContext ic, ListIterator<Clause> iter) throws QueryException {
        boolean changed = false;
        while (iter.hasNext()) {
            Clause clause = iter.next();
            try {
                Expr inlined = ic.inlineOrNull(clause);
                if (inlined == null) continue;
                iter.set((Clause)inlined);
                changed = true;
            }
            catch (QueryException ex) {
                iter.remove();
                return this.clauseError(ex, iter);
            }
        }
        try {
            Expr inlined = ic.inlineOrNull(this.rtrn);
            if (inlined != null) {
                this.rtrn = inlined;
                changed = true;
            }
        }
        catch (QueryException ex) {
            return this.clauseError(ex, iter);
        }
        return changed;
    }

    private boolean clauseError(QueryException ex, ListIterator<Clause> iter) throws QueryException {
        while (iter.hasPrevious()) {
            Clause b4 = iter.previous();
            if (!(b4 instanceof For) && !(b4 instanceof Window) && !(b4 instanceof Where) && !(b4 instanceof While)) continue;
            iter.next();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            this.rtrn = FnError.get(ex, this.rtrn);
            return true;
        }
        throw ex;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        LinkedList<Clause> cls = new LinkedList<Clause>();
        for (Clause clause : this.clauses) {
            cls.add((Clause)clause.copy(cc, (IntObjectMap)vm));
        }
        return this.copyType(new GFLWOR(this.info, cls, this.rtrn.copy(cc, vm)));
    }

    private boolean isFLW() {
        return ((Checks<Clause>)clause -> clause instanceof For || clause instanceof Let || clause instanceof Where || clause instanceof While).all(this.clauses);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return ((Checks<Clause>)clause -> clause.accept(visitor)).all(this.clauses) && this.rtrn.accept(visitor);
    }

    @Override
    public void checkUp() throws QueryException {
        for (Clause clause : this.clauses) {
            clause.checkUp();
        }
        this.rtrn.checkUp();
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        long[] minMax = new long[]{1L, 1L};
        for (Clause clause : this.clauses) {
            clause.calcSize(minMax);
            if (minMax[1] >= 0L && minMax[1] <= 1L) continue;
            return;
        }
        this.rtrn.markTailCalls(cc);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Clause clause : this.clauses) {
            size += clause.exprSize();
        }
        return this.rtrn.exprSize() + size;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        if (tc.seqType().occ != Occ.ZERO_OR_MORE) {
            return null;
        }
        Expr r = tc.check(this.rtrn, cc);
        if (r == null) {
            return this;
        }
        this.rtrn = r;
        return this.optimize(cc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof GFLWOR)) return false;
        GFLWOR gflwor = (GFLWOR)obj;
        if (!this.clauses.equals(gflwor.clauses)) return false;
        if (!this.rtrn.equals(gflwor.rtrn)) return false;
        return true;
    }

    @Override
    public String description() {
        return "FLWOR expression";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.clauses.toArray(Clause[]::new), this.rtrn);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("(").tokens(this.clauses.toArray()).token("return").token(this.rtrn).token(')');
    }

    private static final class StartEval
    extends Eval {
        private boolean more;

        private StartEval() {
        }

        @Override
        public boolean next(QueryContext qc) {
            if (this.more) {
                return false;
            }
            this.more = true;
            return true;
        }
    }
}

