/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CName;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FNSpace;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjectMap;

public final class CNSpace
extends CName {
    public CNSpace(InputInfo info, boolean computed, Expr name, Expr value) {
        super(info, Types.NAMESPACE_NODE_O, computed, name, new Expr[]{value});
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        byte[] nm;
        this.name = this.name.simplifyFor(CompileContext.Simplify.STRING, cc);
        if (this.name instanceof Value && (nm = this.ncname(true, cc.qc)) != null) {
            this.name = Str.get(nm);
        }
        this.optValue(cc);
        return this;
    }

    @Override
    public FNSpace item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] nm = this.ncname(true, qc);
        if (nm.length != 0 && !XMLToken.isNCName(nm)) {
            throw QueryError.INVNSPREFIX_X.get(this.info, new Object[]{nm});
        }
        byte[] value = this.atomValue(qc, true);
        if (Token.eq(nm, Token.XML) ^ Token.eq(value, QueryText.XML_URI)) {
            throw QueryError.CNXML.get(this.info, new Object[0]);
        }
        if (Token.eq(nm, Token.XMLNS)) {
            throw QueryError.CNINV_X.get(this.info, new Object[]{nm});
        }
        if (Token.eq(value, QueryText.XMLNS_URI) || value.length == 0) {
            throw QueryError.CNINVNS_X.get(this.info, new Object[]{value});
        }
        return new FNSpace(nm, value);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CNSpace(this.info, this.computed, this.name.copy(cc, vm), this.exprs[0].copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CNSpace && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        this.toString(qs, "namespace");
    }
}

