/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.util.Util;

public final class DialogLine
extends BaseXDialog {
    private final BaseXTextField line;
    private final BaseXBack buttons;
    private final BaseXLabel info;

    public DialogLine(GUI gui, int curr) {
        super(gui, Text.GO_TO_LINE);
        this.line = new BaseXTextField(this, Integer.toString(curr));
        this.line.addKeyListener(this.keys);
        this.info = new BaseXLabel(" ");
        BaseXBack p = new BaseXBack(new BorderLayout(0, 8));
        p.add((Component)this.line, "North");
        p.add((Component)this.info, "Center");
        this.set(p, "Center");
        this.buttons = this.newButtons(Text.B_OK, Text.B_CANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.finish();
    }

    @Override
    public void action(Object cmp) {
        int l = this.line();
        this.ok = l >= 0;
        this.info.setText(this.ok || this.line.getText().isEmpty() ? null : Util.info(Text.INVALID_X, Text.LINE_NUMBER), GUIConstants.Msg.ERROR);
        DialogLine.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }

    public int line() {
        try {
            return Integer.parseInt(this.line.getText());
        }
        catch (NumberFormatException ex) {
            Util.debug(ex);
            return -1;
        }
    }
}

