/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xquery.XQException;
import net.xqj.core.exception.XQExceptionImpl;

public class MessageFormatter {
    private final String[] messages;

    private MessageFormatter(InputStream in) throws XQException {
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            throw new XQExceptionImpl("Encountered an issue trying to read from a message resource bundle.", "XQJMF004", e);
        }
        this.messages = new String[properties.size()];
        Enumeration<Object> keyEnum = properties.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            int keyAsInt = Integer.parseInt(key);
            if (keyAsInt >= this.messages.length) {
                throw new XQExceptionImpl("Invalid messages file, found the message key \"" + keyAsInt + "\" but the total amount of messages is \"" + this.messages.length + "\", there must be a missing a key or keys.", "XQJMF003");
            }
            this.messages[keyAsInt] = properties.getProperty(key);
        }
        properties.clear();
        keyEnum = null;
        properties = null;
    }

    public static final MessageFormatter newInstance(InputStream in) throws XQException {
        return new MessageFormatter(in);
    }

    public final String formatMessage(int key, Object[] arguments) {
        if (key < this.messages.length && key >= 0) {
            try {
                return MessageFormat.format(this.messages[key], arguments);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to format message \"" + key + "\" in Resouce Message Bundle.", e);
            }
        }
        throw new RuntimeException("The key \"" + key + "\" was not found in the Resouce Message Bundle.");
    }
}

