/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import org.basex.core.CommonOptions;
import org.basex.io.IOUrl;
import org.basex.io.in.TextInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.ParseFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class FnUnparsedTextAvailable
extends ParseFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        try {
            return Bln.get(this.doc(qc) == Bln.TRUE);
        }
        catch (QueryException ex) {
            if (!ex.matches(QueryError.ErrType.XPTY)) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr source = this.arg(0);
        if (source == Empty.VALUE) {
            return this.value(cc.qc);
        }
        if (cc.dynamic && source instanceof Value) {
            try {
                this.input = this.toIO(this.toString(source, cc.qc), false);
                if (!(this.input instanceof IOUrl)) {
                    return this.value(cc.qc);
                }
            }
            catch (QueryException ex) {
                Util.debug(ex);
            }
        }
        return this;
    }

    @Override
    Value parse(TextInput ti, Options options, QueryContext qc) throws IOException {
        try {
            while (ti.read() != -1) {
            }
            return Bln.TRUE;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return Bln.FALSE;
        }
    }

    @Override
    public final QueryError error() {
        return QueryError.RESINPUT_X;
    }

    @Override
    protected final Options options(QueryContext qc) throws QueryException {
        Expr options = this.arg(1);
        ParseOptions po = new ParseOptions();
        if (options instanceof XQMap) {
            XQMap map = (XQMap)options;
            this.toOptions(map, po, qc);
        } else {
            po.set(ParseOptions.ENCODING, this.toStringOrNull(options, qc));
        }
        return po;
    }

    public static final class ParseOptions
    extends Options {
        public static final BooleanOption NORMALIZE_NEWLINES = CommonOptions.NORMALIZE_NEWLINES;
        public static final StringOption ENCODING = CommonOptions.ENCODING;
    }
}

