/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
2007 Andy Jefferson - javadocs, lock/unlock/has methods
    ...
**********************************************************************/
package org.datanucleus;

import java.util.Map;

/**
 * Manager of connections for an OMF, allowing ManagedConnection pooling, enlistment in transaction.
 * The pool caches one connection per ObjectManager.
 * The "allocateConnection" method can create connections and enlist them (like most normal persistence operations need)
 * or create a connection and return it without enlisting it into a transaction, for example the connections used to
 * generate object identity, create the database schema or obtaining the schema metadata.
 * 
 * Connections can be locked per ObjectManager basis. Locking of connections is used to
 * handle the connection over to the user application. A locked connection denies any further
 * access to the datastore, until the user application unlock it.
 *
 * @version $Revision: 1.13 $
 */
public interface ConnectionManager
{
    /**
     * Allocate a connection using the specified factory (unless we already have one cached for this ObjectManager).
     * @param factory The ConnectionFactory to create any new connection with
     * @param om The ObjectManager
     * @param options Any options for allocating the connection (e.g isolation)
     * @return The ManagedConnection
     */
    public ManagedConnection allocateConnection(ConnectionFactory factory, final ObjectManager om, Map options);
}