/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class JavaUtils {
    private static boolean versionInitialised = false;
    private static int majorVersion = 1;
    private static int minorVersion = 0;
    private static int isJRE15 = -1;
    private static int isJRE16 = -1;

    public static boolean isJRE1_5OrAbove() {
        if (isJRE15 == -1) {
            try {
                Class.forName("java.util.Queue");
                isJRE15 = 1;
            }
            catch (Exception e) {
                isJRE15 = 0;
            }
        }
        return isJRE15 == 1;
    }

    public static boolean isJRE1_6OrAbove() {
        if (isJRE16 == -1) {
            try {
                Class.forName("java.util.Deque");
                isJRE16 = 1;
            }
            catch (Exception e) {
                isJRE16 = 0;
            }
        }
        return isJRE16 == 1;
    }

    public static int getJREMajorVersion() {
        if (!versionInitialised) {
            JavaUtils.initialiseJREVersion();
        }
        return majorVersion;
    }

    public static int getJREMinorVersion() {
        if (!versionInitialised) {
            JavaUtils.initialiseJREVersion();
        }
        return minorVersion;
    }

    private static void initialiseJREVersion() {
        try {
            Method version = Runtime.class.getMethod("version", new Class[0]);
            Object value = version.invoke(null, new Object[0]);
            majorVersion = (Integer)value.getClass().getMethod("major", new Class[0]).invoke(value, new Object[0]);
            minorVersion = (Integer)value.getClass().getMethod("minor", new Class[0]).invoke(value, new Object[0]);
            versionInitialised = true;
            return;
        }
        catch (ReflectiveOperationException version) {
            String version2 = System.getProperty("java.version");
            StringTokenizer tokeniser = new StringTokenizer(version2, ".");
            String token = tokeniser.nextToken();
            try {
                Integer ver = new Integer(token);
                majorVersion = ver;
                token = tokeniser.nextToken();
                ver = new Integer(token);
                minorVersion = ver;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            versionInitialised = true;
            return;
        }
    }

    public static boolean isGreaterEqualsThan(String version) {
        boolean greaterEquals = false;
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = new Integer(token);
            int majorVersion = ver;
            token = tokeniser.nextToken();
            ver = new Integer(token);
            int minorVersion = ver;
            if (JavaUtils.getJREMajorVersion() > majorVersion) {
                return true;
            }
            if (JavaUtils.getJREMajorVersion() == majorVersion && JavaUtils.getJREMinorVersion() >= minorVersion) {
                greaterEquals = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return greaterEquals;
    }

    public static boolean isEqualsThan(String version) {
        boolean equals = false;
        StringTokenizer tokeniser = new StringTokenizer(version, ".");
        String token = tokeniser.nextToken();
        try {
            Integer ver = new Integer(token);
            int majorVersion = ver;
            token = tokeniser.nextToken();
            ver = new Integer(token);
            int minorVersion = ver;
            if (JavaUtils.getJREMajorVersion() == majorVersion && JavaUtils.getJREMinorVersion() == minorVersion) {
                equals = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return equals;
    }
}

