/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.query;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.query.DatastoreQuery;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

class ProjectionResultTransformer
implements Utils.Function<Entity, Object> {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private final Utils.Function<Entity, Object> entityToPojoFunc;
    private final ExecutionContext ec;
    private final List<String> projectionFields;
    private final List<String> projectionAliases;
    private final String candidateAlias;
    private final Class resultClass;
    private final Map<String, Field> resultClassFieldsByName = new HashMap<String, Field>();

    ProjectionResultTransformer(Utils.Function<Entity, Object> entityToPojoFunc, ExecutionContext ec, String candidateAlias, Class resultClass, List<String> projectionFields, List<String> projectionAliases) {
        this.entityToPojoFunc = entityToPojoFunc;
        this.ec = ec;
        this.projectionFields = projectionFields;
        this.projectionAliases = projectionAliases;
        this.candidateAlias = candidateAlias;
        this.resultClass = resultClass;
        if (resultClass != null && !QueryUtils.resultClassIsSimple((String)resultClass.getName())) {
            this.populateDeclaredFieldsForUserType(resultClass, this.resultClassFieldsByName);
        }
    }

    @Override
    public Object apply(Entity from) {
        PersistenceCapable pc = (PersistenceCapable)this.entityToPojoFunc.apply(from);
        ObjectProvider op = this.ec.findObjectProvider((Object)pc);
        ArrayList<Object> values = Utils.newArrayList(new Object[0]);
        for (String projectionField : this.projectionFields) {
            ObjectProvider currentOP = op;
            DatastoreManager storeMgr = (DatastoreManager)this.ec.getStoreManager();
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            List<String> fieldNames = ProjectionResultTransformer.getTuples(projectionField, this.candidateAlias);
            Object curValue = null;
            boolean shouldBeDone = false;
            for (String fieldName : fieldNames) {
                if (shouldBeDone) {
                    throw new RuntimeException("Unable to extract field " + projectionField + " from " + op.getClassMetaData().getFullClassName() + ".  This is most likely an App Engine bug.");
                }
                DatastoreTable table = storeMgr.getDatastoreClass(currentOP.getClassMetaData().getFullClassName(), clr);
                JavaTypeMapping typeMapping = table.getMappingForSimpleFieldName(fieldName);
                if (typeMapping instanceof EmbeddedMapping) {
                    typeMapping = table.getMappingForSimpleFieldName(fieldName);
                } else {
                    shouldBeDone = true;
                }
                AbstractMemberMetaData curMemberMetaData = typeMapping.getMemberMetaData();
                curValue = currentOP.provideField(curMemberMetaData.getAbsoluteFieldNumber());
                if (curValue == null) break;
                currentOP = this.ec.findObjectProvider(curValue);
            }
            values.add(curValue);
        }
        if (this.resultClass != null) {
            Object[] valueArray = values.toArray(new Object[values.size()]);
            return this.getResultObjectForValues(valueArray);
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return values.toArray(new Object[values.size()]);
    }

    private Object getResultObjectForValues(Object[] values) {
        if (QueryUtils.resultClassIsSimple((String)this.resultClass.getName())) {
            if (values.length == 1 && (values[0] == null || this.resultClass.isAssignableFrom(values[0].getClass()))) {
                return values[0];
            }
            if (values.length == 1 && !this.resultClass.isAssignableFrom(values[0].getClass())) {
                String msg = LOCALISER.msg("021202", (Object)this.resultClass.getName(), (Object)values[0].getClass().getName());
                NucleusLogger.QUERY.error((Object)msg);
                throw new NucleusUserException(msg);
            }
            throw new NucleusUserException("Result class is simple, but field value " + values + " not convertible into that");
        }
        Class[] resultFieldTypes = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            resultFieldTypes[i] = values[i].getClass();
        }
        Object obj = QueryUtils.createResultObjectUsingArgumentedConstructor((Class)this.resultClass, (Object[])values, (Class[])resultFieldTypes);
        if (obj != null) {
            return obj;
        }
        String[] resultFieldNames = this.projectionAliases.toArray(new String[this.projectionAliases.size()]);
        obj = QueryUtils.createResultObjectUsingDefaultConstructorAndSetters((Class)this.resultClass, (String[])resultFieldNames, this.resultClassFieldsByName, (Object[])values);
        return obj;
    }

    private void populateDeclaredFieldsForUserType(Class cls, Map resultClassFieldsByName) {
        for (int i = 0; i < cls.getDeclaredFields().length; ++i) {
            if (resultClassFieldsByName.put(cls.getDeclaredFields()[i].getName().toUpperCase(), cls.getDeclaredFields()[i]) == null) continue;
            throw new NucleusUserException(LOCALISER.msg("021210", (Object)cls.getDeclaredFields()[i].getName()));
        }
        if (cls.getSuperclass() != null) {
            this.populateDeclaredFieldsForUserType(cls.getSuperclass(), resultClassFieldsByName);
        }
    }

    private static List<String> getTuples(String dotDelimitedFieldName, String alias) {
        List<String> tuples = Arrays.asList(dotDelimitedFieldName.split("\\."));
        return DatastoreQuery.getTuples(tuples, alias);
    }
}

