/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.appengine.DatastoreFKMapping;
import org.datanucleus.store.appengine.DatastoreProperty;
import org.datanucleus.store.appengine.KeyMapping;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.AbstractMappingManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMappingFactory;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;

class DatastoreMappingManager
extends AbstractMappingManager {
    DatastoreMappingManager(MappedStoreManager mappedStoreManager) {
        super(mappedStoreManager);
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping javaTypeMapping, AbstractMemberMetaData abstractMemberMetaData, int ignored, DatastoreField datastoreField) {
        return this.createDatastoreMapping(javaTypeMapping, datastoreField);
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, DatastoreField prop, String javaType) {
        return this.createDatastoreMapping(mapping, prop);
    }

    private DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, DatastoreField prop) {
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(DatastoreFKMapping.class, (JavaTypeMapping)mapping, (MappedStoreManager)this.storeMgr, (DatastoreField)prop);
        if (prop != null) {
            prop.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    public DatastoreField createDatastoreField(JavaTypeMapping mapping, String javaType, int datastoreFieldIndex) {
        ColumnMetaData[] colmds;
        ColumnMetaData colmd;
        AbstractMemberMetaData fmd = mapping.getMemberMetaData();
        int roleForField = mapping.getRoleForMember();
        DatastoreContainerObject datastoreContainer = mapping.getDatastoreContainer();
        AbstractMemberMetaData columnContainer = fmd;
        if (roleForField == 3 || roleForField == 4) {
            columnContainer = fmd.getElementMetaData();
        } else if (roleForField == 5) {
            columnContainer = fmd.getKeyMetaData();
        } else if (roleForField == 6) {
            columnContainer = fmd.getValueMetaData();
        }
        if (columnContainer != null && columnContainer.getColumnMetaData() != null && columnContainer.getColumnMetaData().length > datastoreFieldIndex) {
            colmd = columnContainer.getColumnMetaData()[datastoreFieldIndex];
            colmds = columnContainer.getColumnMetaData();
        } else {
            colmd = new ColumnMetaData();
            colmd.setName(fmd.getColumn());
            if (columnContainer != null) {
                columnContainer.addColumn(colmd);
                colmds = columnContainer.getColumnMetaData();
            } else {
                colmds = new ColumnMetaData[]{colmd};
            }
        }
        MappedStoreManager storeMgr = datastoreContainer.getStoreManager();
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            if (roleForField == 2) {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName());
                int i = 0;
                while (datastoreContainer.hasDatastoreField(identifier)) {
                    identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName() + "_" + i);
                    ++i;
                }
            } else if (roleForField == 3) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 3);
            } else if (roleForField == 4) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 4);
            } else if (roleForField == 5) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 5);
            } else if (roleForField == 6) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 6);
            }
            colmd.setName(identifier.getIdentifierName());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmds[datastoreFieldIndex].getName(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1);
        }
        DatastoreProperty prop = (DatastoreProperty)datastoreContainer.addDatastoreField(javaType, identifier, mapping, (MetaData)colmd);
        if (fmd.isPrimaryKey()) {
            prop.setAsPrimaryKey();
        }
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            prop.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                throw new UnsupportedOperationException("User-defined default not supported.");
            }
        }
        return prop;
    }

    public DatastoreField createDatastoreField(JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        DatastoreField prop;
        AbstractMemberMetaData fmd = mapping.getMemberMetaData();
        DatastoreContainerObject datastoreContainer = mapping.getDatastoreContainer();
        MappedStoreManager storeMgr = datastoreContainer.getStoreManager();
        if (colmd == null) {
            colmd = new ColumnMetaData();
            colmd.setName(fmd.getColumn());
            fmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        if (colmd.getName() == null) {
            DatastoreIdentifier identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName());
            int i = 0;
            while (datastoreContainer.hasDatastoreField(identifier)) {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getIdentifierName());
            prop = datastoreContainer.addDatastoreField(javaType, identifier, mapping, (MetaData)colmd);
        } else {
            prop = datastoreContainer.addDatastoreField(javaType, idFactory.newDatastoreFieldIdentifier(colmd.getName(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1), mapping, (MetaData)colmd);
        }
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            prop.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                throw new UnsupportedOperationException("User-defined default not supported.");
            }
        }
        return prop;
    }

    public DatastoreField createDatastoreField(AbstractMemberMetaData fmd, DatastoreContainerObject datastoreContainer, JavaTypeMapping mapping, ColumnMetaData colmd, DatastoreField reference, ClassLoaderResolver clr) {
        MappedStoreManager storeMgr = datastoreContainer.getStoreManager();
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
            identifier = idFactory.newForeignKeyFieldIdentifier(relatedMmds != null ? relatedMmds[0] : null, fmd, reference.getIdentifier(), storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), 1);
            colmd.setName(identifier.getIdentifierName());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmd.getName(), false, -1);
        }
        DatastoreField prop = datastoreContainer.addDatastoreField(fmd.getType().getName(), identifier, mapping, (MetaData)colmd);
        reference.copyConfigurationTo(prop);
        if (fmd.isPrimaryKey()) {
            prop.setAsPrimaryKey();
        }
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            prop.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                throw new UnsupportedOperationException("User-defined default not supported.");
            }
        }
        return prop;
    }

    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr, String vendorId) {
    }

    public void registerDatastoreMapping(String javaTypeName, Class datastoreMappingType, String jdbcType, String sqlType, boolean dflt) {
    }

    protected Class getOverrideMappingClass(Class mappingClass, AbstractMemberMetaData fmd, int roleForField) {
        if (roleForField == 2 && fmd.isPrimaryKey() && mappingClass.equals(SerialisedMapping.class) && fmd.getType().equals(Key.class)) {
            return KeyMapping.class;
        }
        if (mappingClass.equals(EmbeddedPCMapping.class)) {
            return DatastoreEmbeddedPCMapping.class;
        }
        return mappingClass;
    }

    public static final class DatastoreEmbeddedPCMapping
    extends EmbeddedPCMapping {
        public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
            if (fmd.getEmbeddedMetaData() == null) {
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(fmd.getName());
                fmd.setEmbeddedMetaData(embmd);
                embmd.populate(clr, null);
                embmd.initialise(clr);
            }
            super.initialize(dba, fmd, container, clr);
        }
    }
}

