/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.googleapi;

import com.google.cloud.sql.Driver;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.tool.Sql;
import com.google.cloud.sql.tool.googleapi.OAuth2ConnectionFactory;
import com.google.cloud.sql.tool.googleapi.Version;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SqlTool {
    private static String CONNECTION_FACTORY = OAuth2ConnectionFactory.class.getName();
    private static String DRIVER = Driver.class.getName();

    public static void main(String[] originalArgs) {
        List<String> nonFlagArgs = SqlTool.nonFlagArgs(originalArgs);
        List<String> flagArgs = SqlTool.flagArgs(originalArgs);
        boolean verbose = flagArgs.contains("--verbose");
        if (flagArgs.contains("--help") || flagArgs.contains("--version")) {
            SqlTool.showHelpAndExit();
        } else if (nonFlagArgs.isEmpty()) {
            SqlTool.showHelpAndExit();
        }
        ArrayList<String> args = Util.newArrayList();
        args.add("--driver=" + DRIVER);
        args.add("--url=" + SqlTool.makeUrl(nonFlagArgs));
        args.add("--connection_factory=" + CONNECTION_FACTORY);
        args.add("--server=https://www.googleapis.com/sql/v1/");
        args.addAll(SqlTool.flagArgs(originalArgs));
        if (verbose) {
            System.err.println("args = " + ((Object)args).toString());
        }
        Sql.main(args.toArray(new String[args.size()]));
    }

    private static List<String> nonFlagArgs(String[] args) {
        ArrayList<String> result = Util.newArrayList();
        for (String arg : args) {
            if (arg.startsWith("--")) continue;
            result.add(arg);
        }
        return result;
    }

    private static List<String> flagArgs(String[] args) {
        ArrayList<String> result = Util.newArrayList();
        for (String arg : args) {
            if (!arg.startsWith("--")) continue;
            result.add(arg);
        }
        return result;
    }

    private static String makeUrl(List<String> args) {
        Iterator<String> iter = args.iterator();
        StringBuilder url = new StringBuilder("jdbc:google:rdbms://").append(iter.next());
        if (iter.hasNext()) {
            url.append('/').append(iter.next());
        }
        return url.toString();
    }

    public static void showHelpAndExit() {
        System.out.println("Google SQL Service tool. Release " + Version.getVersion());
        System.out.println("Usage: \n");
        System.out.println("\t<sql_googleapi> <instance> [database]");
        System.exit(0);
    }
}

