/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserException;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgTable;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AlterTableParser {
    public static void parse(PgDatabase database, String statement, boolean outputIgnoredStatements) {
        Parser parser = new Parser(statement);
        parser.expect("ALTER", "TABLE");
        parser.expectOptional("ONLY");
        String tableName = parser.parseIdentifier();
        String schemaName = ParserUtils.getSchemaName(tableName, database);
        PgSchema schema = database.getSchema(schemaName);
        if (schema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), schemaName, statement));
        }
        String objectName = ParserUtils.getObjectName(tableName);
        PgTable table = schema.getTable(objectName);
        if (table == null) {
            PgView view = schema.getView(objectName);
            if (view != null) {
                AlterTableParser.parseView(parser, view, outputIgnoredStatements, tableName, database);
                return;
            }
            PgSequence sequence = schema.getSequence(objectName);
            if (sequence != null) {
                AlterTableParser.parseSequence(parser, sequence, outputIgnoredStatements, tableName, database);
                return;
            }
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindObject"), tableName, statement));
        }
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("ALTER")) {
                AlterTableParser.parseAlterColumn(parser, table);
            } else if (parser.expectOptional("CLUSTER", "ON")) {
                table.setClusterIndexName(ParserUtils.getObjectName(parser.parseIdentifier()));
            } else if (parser.expectOptional("OWNER", "TO")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + tableName + " OWNER TO " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else if (parser.expectOptional("ADD")) {
                if (parser.expectOptional("FOREIGN", "KEY")) {
                    AlterTableParser.parseAddForeignKey(parser, table);
                } else if (parser.expectOptional("CONSTRAINT")) {
                    AlterTableParser.parseAddConstraint(parser, table, schema);
                } else {
                    parser.throwUnsupportedCommand();
                }
            } else if (parser.expectOptional("ENABLE")) {
                AlterTableParser.parseEnable(parser, outputIgnoredStatements, tableName, database);
            } else if (parser.expectOptional("DISABLE")) {
                AlterTableParser.parseDisable(parser, outputIgnoredStatements, tableName, database);
            } else {
                parser.throwUnsupportedCommand();
            }
            if (parser.expectOptional(";")) break;
            parser.expect(",");
        }
    }

    private static void parseEnable(Parser parser, boolean outputIgnoredStatements, String tableName, PgDatabase database) {
        if (parser.expectOptional("REPLICA")) {
            if (parser.expectOptional("TRIGGER")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + tableName + " ENABLE REPLICA TRIGGER " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else if (parser.expectOptional("RULE")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + tableName + " ENABLE REPLICA RULE " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else {
                parser.throwUnsupportedCommand();
            }
        } else if (parser.expectOptional("ALWAYS")) {
            if (parser.expectOptional("TRIGGER")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + tableName + " ENABLE ALWAYS TRIGGER " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else if (parser.expectOptional("RULE")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + tableName + " ENABLE RULE " + parser.parseIdentifier() + ';');
                } else {
                    parser.parseIdentifier();
                }
            } else {
                parser.throwUnsupportedCommand();
            }
        }
    }

    private static void parseDisable(Parser parser, boolean outputIgnoredStatements, String tableName, PgDatabase database) {
        if (parser.expectOptional("TRIGGER")) {
            if (outputIgnoredStatements) {
                database.addIgnoredStatement("ALTER TABLE " + tableName + " DISABLE TRIGGER " + parser.parseIdentifier() + ';');
            } else {
                parser.parseIdentifier();
            }
        } else if (parser.expectOptional("RULE")) {
            if (outputIgnoredStatements) {
                database.addIgnoredStatement("ALTER TABLE " + tableName + " DISABLE RULE " + parser.parseIdentifier() + ';');
            } else {
                parser.parseIdentifier();
            }
        } else {
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseAddConstraint(Parser parser, PgTable table, PgSchema schema) {
        String constraintName = ParserUtils.getObjectName(parser.parseIdentifier());
        PgConstraint constraint = new PgConstraint(constraintName);
        constraint.setTableName(table.getName());
        table.addConstraint(constraint);
        if (parser.expectOptional("PRIMARY", "KEY")) {
            schema.addPrimaryKey(constraint);
            constraint.setDefinition("PRIMARY KEY " + parser.getExpression());
        } else {
            constraint.setDefinition(parser.getExpression());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseAlterColumn(Parser parser, PgTable table) {
        parser.expectOptional("COLUMN");
        String columnName = ParserUtils.getObjectName(parser.parseIdentifier());
        if (parser.expectOptional("SET")) {
            if (parser.expectOptional("STATISTICS")) {
                PgColumn column = table.getColumn(columnName);
                if (column == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), columnName, table.getName(), parser.getString()));
                }
                column.setStatistics(parser.parseInteger());
                return;
            } else if (parser.expectOptional("DEFAULT")) {
                String defaultValue = parser.getExpression();
                if (!table.containsColumn(columnName)) throw new ParserException(MessageFormat.format(Resources.getString("CannotFindColumnInTable"), columnName, table.getName()));
                PgColumn column = table.getColumn(columnName);
                if (column == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), columnName, table.getName(), parser.getString()));
                }
                column.setDefaultValue(defaultValue);
                return;
            } else if (parser.expectOptional("STORAGE")) {
                PgColumn column = table.getColumn(columnName);
                if (column == null) {
                    throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTableColumn"), columnName, table.getName(), parser.getString()));
                }
                if (parser.expectOptional("PLAIN")) {
                    column.setStorage("PLAIN");
                    return;
                } else if (parser.expectOptional("EXTERNAL")) {
                    column.setStorage("EXTERNAL");
                    return;
                } else if (parser.expectOptional("EXTENDED")) {
                    column.setStorage("EXTENDED");
                    return;
                } else if (parser.expectOptional("MAIN")) {
                    column.setStorage("MAIN");
                    return;
                } else {
                    parser.throwUnsupportedCommand();
                }
                return;
            } else {
                parser.throwUnsupportedCommand();
            }
            return;
        } else {
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseAddForeignKey(Parser parser, PgTable table) {
        ArrayList<String> columnNames = new ArrayList<String>(1);
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            columnNames.add(ParserUtils.getObjectName(parser.parseIdentifier()));
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        String constraintName = ParserUtils.generateName(table.getName() + "_", columnNames, "_fkey");
        PgConstraint constraint = new PgConstraint(constraintName);
        table.addConstraint(constraint);
        constraint.setDefinition(parser.getExpression());
        constraint.setTableName(table.getName());
    }

    private static void parseView(Parser parser, PgView view, boolean outputIgnoredStatements, String viewName, PgDatabase database) {
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("ALTER")) {
                parser.expectOptional("COLUMN");
                String columnName = ParserUtils.getObjectName(parser.parseIdentifier());
                if (parser.expectOptional("SET", "DEFAULT")) {
                    String expression = parser.getExpression();
                    view.addColumnDefaultValue(columnName, expression);
                    continue;
                }
                if (parser.expectOptional("DROP", "DEFAULT")) {
                    view.removeColumnDefaultValue(columnName);
                    continue;
                }
                parser.throwUnsupportedCommand();
                continue;
            }
            if (parser.expectOptional("OWNER", "TO")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + viewName + " OWNER TO " + parser.parseIdentifier() + ';');
                    continue;
                }
                parser.parseIdentifier();
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private static void parseSequence(Parser parser, PgSequence sequence, boolean outputIgnoredStatements, String sequenceName, PgDatabase database) {
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("OWNER", "TO")) {
                if (outputIgnoredStatements) {
                    database.addIgnoredStatement("ALTER TABLE " + sequenceName + " OWNER TO " + parser.parseIdentifier() + ';');
                    continue;
                }
                parser.parseIdentifier();
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private AlterTableParser() {
    }
}

