/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharQueue;
import antlr.CharStreamException;

public abstract class InputBuffer {
    protected int nMarkers = 0;
    protected int markerOffset = 0;
    protected int numToConsume = 0;
    protected CharQueue queue = new CharQueue(1);

    public void commit() {
        --this.nMarkers;
    }

    public void consume() {
        ++this.numToConsume;
    }

    public abstract void fill(int var1) throws CharStreamException;

    public String getLAChars() {
        StringBuffer la = new StringBuffer();
        int i = this.markerOffset;
        while (i < this.queue.nbrEntries) {
            la.append(this.queue.elementAt(i));
            ++i;
        }
        return la.toString();
    }

    public String getMarkedChars() {
        StringBuffer marked = new StringBuffer();
        int i = 0;
        while (i < this.markerOffset) {
            marked.append(this.queue.elementAt(i));
            ++i;
        }
        return marked.toString();
    }

    public boolean isMarked() {
        return this.nMarkers != 0;
    }

    public char LA(int i) throws CharStreamException {
        this.fill(i);
        return this.queue.elementAt(this.markerOffset + i - 1);
    }

    public int mark() {
        this.syncConsume();
        ++this.nMarkers;
        return this.markerOffset;
    }

    public void rewind(int mark) {
        this.syncConsume();
        this.markerOffset = mark;
        --this.nMarkers;
    }

    public void reset() {
        this.nMarkers = 0;
        this.markerOffset = 0;
        this.numToConsume = 0;
        this.queue.reset();
    }

    protected void syncConsume() {
        while (this.numToConsume > 0) {
            if (this.nMarkers > 0) {
                ++this.markerOffset;
            } else {
                this.queue.removeFirst();
            }
            --this.numToConsume;
        }
    }
}

