/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.device;

import de.pleumann.antenna.device.BaseProps;
import de.pleumann.antenna.device.Group;
import de.pleumann.antenna.device.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceProps
extends BaseProps {
    protected String m_identifier;
    protected Set m_groups = new TreeSet();

    public DeviceProps(Element dev) {
        super(dev);
        NodeList props = dev.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node item = props.item(i);
            if (!(item instanceof Element)) continue;
            Element e = (Element)item;
            String tagName = e.getTagName();
            if ("identifier".equals(tagName)) {
                this.m_identifier = Util.getText(e);
                continue;
            }
            if (!"groups".equals(tagName)) continue;
            this.parseGroup(e, this.m_groups);
        }
        this.calculateIMEIKey();
        this.addVendor();
    }

    private void addVendor() {
        int i;
        String vendor = "unknown";
        String id = this.getIdentifier();
        if (id != null && (i = id.indexOf(47)) != -1) {
            vendor = id.substring(0, i);
        }
        this.m_capabilities.setProperty("Vendor", vendor);
    }

    public void addToProperties(Properties props) {
        Enumeration<Object> cap = this.m_capabilities.keys();
        while (cap.hasMoreElements()) {
            String c = (String)cap.nextElement();
            String v = (String)this.m_capabilities.get(c);
            props.setProperty(c, "'" + v + "'");
        }
        props.put("groups", this.convertSetToString(this.m_groups));
        props.put("features", this.convertSetToString(this.m_features));
        props.put(this.m_identifier, "");
    }

    private String convertSetToString(Set set) {
        StringBuffer b = new StringBuffer();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            b.append(s);
            if (!iter.hasNext()) continue;
            b.append(",");
        }
        return b.length() == 0 ? "false" : "'" + b.toString() + "'";
    }

    private void calculateIMEIKey() {
        String name = null;
        if (this.m_identifier.toLowerCase().indexOf("sony-ericsson") != -1) {
            name = "com.sonyericsson.imei";
        } else if (this.m_identifier.toLowerCase().indexOf("motorola") != -1) {
            name = "IMEI";
        } else if (this.m_identifier.toLowerCase().indexOf("siemens") != -1) {
            name = "com.siemens.IMEI";
        } else if (this.m_identifier.toLowerCase().indexOf("nokia") != -1) {
            name = this.inGroup("series40") ? "com.nokia.mid.imei" : "com.nokia.IMEI";
        }
        if (name == null) {
            name = "UNKNOWN IMEI KEY";
        }
        this.m_capabilities.setProperty("IMEI_KEY", name);
    }

    public boolean inGroup(String group) {
        return this.m_groups.contains(group != null ? group.toLowerCase() : null);
    }

    public boolean hasFeature(String feature) {
        return this.m_features.contains(feature);
    }

    public boolean hasBug(String bug) {
        return this.m_bugs.contains(bug);
    }

    public boolean supportSound(String soundFormat) {
        return this.m_soundFormats.contains(soundFormat);
    }

    public boolean supportVideo(String videoFormat) {
        return this.m_videoFormats.contains(videoFormat);
    }

    public boolean supportsPackage(String packageName) {
        return this.m_javaPackage.contains(packageName);
    }

    public boolean hasCapability(String name) {
        return this.m_capabilities.containsKey(name);
    }

    public String getCapability(String name) {
        return this.m_capabilities.getProperty(name);
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public Properties getCapabilities() {
        return this.m_capabilities;
    }

    public String getDefinesString() {
        String deviceDefines = "";
        Properties props = new Properties();
        this.addToProperties(props);
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            deviceDefines = deviceDefines + key;
            if (value.length() > 0) {
                deviceDefines = deviceDefines + "=" + value + "";
            }
            if (!keys.hasMoreElements()) continue;
            deviceDefines = deviceDefines + ",";
        }
        return deviceDefines;
    }

    public void setGroupsData(Hashtable groups, Hashtable capTable) {
        Iterator ii = this.m_groups.iterator();
        while (ii.hasNext()) {
            String groupName = (String)ii.next();
            Group group = (Group)groups.get(groupName.toLowerCase());
            if (group == null) continue;
            Properties capablities = group.constructCapabilities(groups, capTable);
            Util.addCapabilities(capablities, this.m_capabilities, capTable);
            this.m_capabilities = capablities;
            Set features = group.constructFeatureSet(groups);
            features.addAll(this.m_features);
            this.m_features = features;
        }
    }
}

