/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.WtkJad;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JadAttributes
extends Task {
    boolean m_failOnError = true;
    String m_attribName;
    String m_key;
    String m_value;
    String m_fileName;
    String m_clear;
    static Hashtable s_jad2attribMap = new Hashtable();
    private String m_encoding;

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setAttribName(String attribName) {
        this.m_attribName = attribName;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setClear(String value) {
        this.m_clear = value;
    }

    public void execute() throws BuildException {
        if (this.m_attribName == null) {
            throw new BuildException("Missing attrib name");
        }
        if ("true".equalsIgnoreCase(this.m_clear)) {
            this.log("Clearing attributes for " + this.m_attribName);
            Object old = s_jad2attribMap.remove(this.m_attribName);
            if (old == null && this.m_failOnError) {
                throw new BuildException(this.m_attribName + " not found");
            }
        } else {
            AttributesSet attribues = (AttributesSet)s_jad2attribMap.get(this.m_attribName);
            if (attribues == null) {
                this.log("Creating a new attributes set : " + this.m_attribName);
                attribues = new AttributesSet(this.m_attribName);
                s_jad2attribMap.put(this.m_attribName, attribues);
            }
            if (this.m_fileName == null) {
                if (this.m_key == null) {
                    throw new BuildException("Missing key name");
                }
                if (this.m_value == null) {
                    throw new BuildException("Missing value name");
                }
                attribues.addPair(this.m_key, this.m_value);
            } else {
                try {
                    File file = new File(this.m_fileName);
                    if (file.exists()) {
                        String[][] pairs = JadAttributes.getPairs(file, "#", this.m_encoding);
                        this.log("Loaded properties from " + file);
                        for (int i = 0; i < pairs.length; ++i) {
                            String key = pairs[i][0];
                            String value = pairs[i][1];
                            attribues.addPair(key, value);
                        }
                    } else {
                        String msg = "Missing propertis file " + file + "( not found at " + file.getAbsolutePath() + ")";
                        if (this.m_failOnError) {
                            throw new BuildException(msg);
                        }
                        this.log(msg);
                    }
                }
                catch (IOException e) {
                    if (this.m_failOnError) {
                        throw new BuildException((Throwable)e);
                    }
                    this.log("IO Error reading " + this.m_fileName + ", " + e.getMessage());
                }
            }
        }
    }

    public static boolean hasAttributesFor(String jadName) {
        return s_jad2attribMap.containsKey(jadName);
    }

    public static String[][] getAttributesFor(WtkJad caller, String jadName) {
        AttributesSet attribues = (AttributesSet)s_jad2attribMap.get(jadName);
        if (attribues == null) {
            caller.log("No JAD Attributes stored in JadAttributes for " + jadName);
            return new String[0][2];
        }
        String[][] pairs = new String[attribues.m_pairs.size()][2];
        attribues.m_pairs.copyInto((Object[])pairs);
        return pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[][] getPairs(File file, String commentPrefix, String encoding) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String[][] stringArray = JadAttributes.getPairs(in, commentPrefix, encoding);
            return stringArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    public void setFailOnError(boolean failOnError) {
        this.m_failOnError = failOnError;
    }

    public static String[][] getPairs(InputStream input, String commentPrefix, String encoding) throws IOException {
        String line;
        Vector<String[]> result = new Vector<String[]>();
        BufferedReader in = encoding == null ? new BufferedReader(new InputStreamReader(input)) : new BufferedReader(new InputStreamReader(input, encoding));
        boolean contOnNext = false;
        while ((line = in.readLine()) != null) {
            int indexOfComment = line.indexOf(commentPrefix);
            if (indexOfComment != -1) {
                line = line.substring(0, indexOfComment).trim();
            }
            if (line.length() <= 0) continue;
            int sepIndex = JadAttributes.getSepIndex(line);
            boolean willContOnNext = line.endsWith("\\");
            if (willContOnNext) {
                line = line.substring(0, line.length() - 1);
            }
            if (contOnNext) {
                String[] last = (String[])result.get(result.size() - 1);
                last[1] = last[1] + line;
                result.set(result.size() - 1, last);
            } else if (sepIndex != -1) {
                String key = JadAttributes.loadConvert(line.substring(0, sepIndex));
                String value = JadAttributes.loadConvert(line.substring(sepIndex + 1));
                result.addElement(new String[]{key, value});
            }
            contOnNext = willContOnNext;
        }
        String[][] pairs = new String[result.size()][2];
        result.copyInto((Object[])pairs);
        return pairs;
    }

    private static int getSepIndex(String line) {
        int sepIndex1 = line.indexOf(61);
        int sepIndex2 = line.indexOf(58);
        if (sepIndex1 == -1 && sepIndex2 == -1) {
            return -1;
        }
        int sepIndex = 0;
        sepIndex = sepIndex1 != -1 && sepIndex2 != -1 ? Math.min(sepIndex1, sepIndex2) : (sepIndex1 == -1 ? sepIndex2 : sepIndex1);
        return sepIndex;
    }

    private static String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    private class AttributesSet {
        String m_jadName;
        Vector m_pairs = new Vector();

        public AttributesSet(String jadName) {
            this.m_jadName = jadName;
        }

        public void addPair(String key, String value) {
            key = JadAttributes.this.getProject().replaceProperties(key);
            String value2 = JadAttributes.this.getProject().replaceProperties(value);
            if (value.equals(value2)) {
                JadAttributes.this.log(JadAttributes.this.m_attribName + " <- " + key + "=" + value);
            } else {
                JadAttributes.this.log(JadAttributes.this.m_attribName + " <- " + key + "=" + value2 + " (was " + value + ")");
            }
            this.m_pairs.addElement(new String[]{key, value2});
        }
    }
}

