/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.api;

import com.android.annotations.NonNull;
import com.google.common.annotations.Beta;

@Beta
public class Point {
    public int x;
    public int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(@NonNull Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void set(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @NonNull
    public Point copy() {
        return new Point(this.x, this.y);
    }

    @NonNull
    public Point offsetBy(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point rhs = (Point)obj;
            return this.x == rhs.x && this.y == rhs.y;
        }
        return false;
    }

    public int hashCode() {
        int h = this.x ^ this.y >> 16 & 0xFFFF ^ (this.y & 0xFFFF) << 16;
        return h;
    }

    public String toString() {
        return String.format("Point [%dx%d]", this.x, this.y);
    }
}

