/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.HeapSegment;
import com.android.ddmlib.Log;
import com.android.ddmuilib.BaseHeapPanel;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.TableHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.experimental.swt.SWTUtils;

public final class HeapPanel
extends BaseHeapPanel {
    private static final String PREFS_STATS_COL_TYPE = "heapPanel.col0";
    private static final String PREFS_STATS_COL_COUNT = "heapPanel.col1";
    private static final String PREFS_STATS_COL_SIZE = "heapPanel.col2";
    private static final String PREFS_STATS_COL_SMALLEST = "heapPanel.col3";
    private static final String PREFS_STATS_COL_LARGEST = "heapPanel.col4";
    private static final String PREFS_STATS_COL_MEDIAN = "heapPanel.col5";
    private static final String PREFS_STATS_COL_AVERAGE = "heapPanel.col6";
    private static final int NOT_SELECTED = 0;
    private static final int NOT_ENABLED = 1;
    private static final int ENABLED = 2;
    private static final int NUM_PALETTE_ENTRIES = 10;
    private static final String[] mMapLegend = new String[10];
    private static final PaletteData mMapPalette = HeapPanel.createPalette();
    private static final boolean DISPLAY_HEAP_BITMAP = false;
    private static final boolean DISPLAY_HILBERT_BITMAP = false;
    private static final int PLACEHOLDER_HILBERT_SIZE = 200;
    private static final int PLACEHOLDER_LINEAR_V_SIZE = 100;
    private static final int PLACEHOLDER_LINEAR_H_SIZE = 300;
    private static final int[] ZOOMS = new int[]{100, 50, 25};
    private static final NumberFormat sByteFormatter = NumberFormat.getInstance();
    private static final NumberFormat sLargeByteFormatter = NumberFormat.getInstance();
    private static final NumberFormat sCountFormatter = NumberFormat.getInstance();
    private Display mDisplay;
    private Composite mTop;
    private Label mUpdateStatus;
    private Table mHeapSummary;
    private Combo mDisplayMode;
    private Composite mDisplayBase;
    private StackLayout mDisplayStack;
    private Composite mStatisticsBase;
    private Table mStatisticsTable;
    private JFreeChart mChart;
    private ChartComposite mChartComposite;
    private Button mGcButton;
    private DefaultCategoryDataset mAllocCountDataSet;
    private Composite mLinearBase;
    private Label mLinearHeapImage;
    private Composite mHilbertBase;
    private Label mHilbertHeapImage;
    private Group mLegend;
    private Combo mZoom;
    private Image mHilbertImage;
    private Image mLinearImage;
    private Composite[] mLayout;
    private static final int HILBERT_DIR_N = 0;
    private static final int HILBERT_DIR_S = 1;
    private static final int HILBERT_DIR_E = 2;
    private static final int HILBERT_DIR_W = 3;

    private static PaletteData createPalette() {
        RGB[] colors = new RGB[10];
        colors[0] = new RGB(192, 192, 192);
        HeapPanel.mMapLegend[0] = "(heap expansion area)";
        colors[1] = new RGB(0, 0, 0);
        HeapPanel.mMapLegend[1] = "free";
        colors[2] = new RGB(0, 0, 255);
        HeapPanel.mMapLegend[2] = "data object";
        colors[3] = new RGB(0, 255, 0);
        HeapPanel.mMapLegend[3] = "class object";
        colors[4] = new RGB(255, 0, 0);
        HeapPanel.mMapLegend[4] = "1-byte array (byte[], boolean[])";
        colors[5] = new RGB(255, 128, 0);
        HeapPanel.mMapLegend[5] = "2-byte array (short[], char[])";
        colors[6] = new RGB(255, 255, 0);
        HeapPanel.mMapLegend[6] = "4-byte array (object[], int[], float[])";
        colors[7] = new RGB(255, 128, 128);
        HeapPanel.mMapLegend[7] = "8-byte array (long[], double[])";
        colors[8] = new RGB(255, 0, 255);
        HeapPanel.mMapLegend[8] = "unknown object";
        colors[9] = new RGB(64, 64, 64);
        HeapPanel.mMapLegend[9] = "non-Java object";
        return new PaletteData(colors);
    }

    @Override
    public void clientChanged(Client client, int changeMask) {
        if (client == this.getCurrentClient() && ((changeMask & 0x20) == 32 || (changeMask & 0x40) == 64)) {
            try {
                this.mTop.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HeapPanel.this.clientSelected();
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    @Override
    public void deviceSelected() {
    }

    @Override
    public void clientSelected() {
        if (this.mTop.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        Log.d("ddms", "HeapPanel: changed " + client);
        if (client != null) {
            ClientData cd = client.getClientData();
            if (client.isHeapUpdateEnabled()) {
                this.mGcButton.setEnabled(true);
                this.mDisplayMode.setEnabled(true);
                this.setUpdateStatus(2);
            } else {
                this.setUpdateStatus(1);
                this.mGcButton.setEnabled(false);
                this.mDisplayMode.setEnabled(false);
            }
            this.fillSummaryTable(cd);
            int mode = this.mDisplayMode.getSelectionIndex();
            if (mode == 0) {
                this.fillDetailedTable(client, false);
            }
        } else {
            this.mGcButton.setEnabled(false);
            this.mDisplayMode.setEnabled(false);
            this.fillSummaryTable(null);
            this.fillDetailedTable(null, true);
            this.setUpdateStatus(0);
        }
        this.mDisplayBase.layout();
    }

    @Override
    protected Control createControl(Composite parent) {
        this.mDisplay = parent.getDisplay();
        this.mTop = new Composite(parent, 0);
        this.mTop.setLayout((Layout)new GridLayout(1, false));
        this.mTop.setLayoutData((Object)new GridData(1808));
        this.mUpdateStatus = new Label(this.mTop, 0);
        this.setUpdateStatus(0);
        Composite summarySection = new Composite(this.mTop, 0);
        GridLayout gl = new GridLayout(2, false);
        summarySection.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mHeapSummary = this.createSummaryTable(summarySection);
        this.mGcButton = new Button(summarySection, 8);
        this.mGcButton.setText("Cause GC");
        this.mGcButton.setEnabled(false);
        this.mGcButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Client client = HeapPanel.this.getCurrentClient();
                if (client != null) {
                    client.executeGarbageCollector();
                }
            }
        });
        Composite comboSection = new Composite(this.mTop, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comboSection.setLayout((Layout)gl);
        Label displayLabel = new Label(comboSection, 0);
        displayLabel.setText("Display: ");
        this.mDisplayMode = new Combo(comboSection, 8);
        this.mDisplayMode.setEnabled(false);
        this.mDisplayMode.add("Stats");
        this.mDisplayBase = new Composite(this.mTop, 0);
        this.mDisplayBase.setLayoutData((Object)new GridData(1808));
        this.mDisplayStack = new StackLayout();
        this.mDisplayBase.setLayout((Layout)this.mDisplayStack);
        this.mStatisticsBase = new Composite(this.mDisplayBase, 0);
        gl = new GridLayout(1, false);
        this.mStatisticsBase.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mDisplayStack.topControl = this.mStatisticsBase;
        this.mStatisticsTable = this.createDetailedTable(this.mStatisticsBase);
        this.mStatisticsTable.setLayoutData((Object)new GridData(1808));
        this.createChart();
        this.mLinearBase = new Composite(this.mDisplayBase, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mLinearBase.setLayout((Layout)gl);
        this.mLinearHeapImage = new Label(this.mLinearBase, 0);
        this.mLinearHeapImage.setLayoutData((Object)new GridData());
        this.mLinearHeapImage.setImage(ImageLoader.createPlaceHolderArt(this.mDisplay, 300, 100, this.mDisplay.getSystemColor(9)));
        Composite bottomSection = new Composite(this.mLinearBase, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        bottomSection.setLayout((Layout)gl);
        this.createLegend(bottomSection);
        this.mHilbertBase = new Composite(this.mDisplayBase, 0);
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.mHilbertBase.setLayout((Layout)gl);
        this.mHilbertBase.pack();
        this.mLayout = new Composite[]{this.mStatisticsBase, this.mLinearBase, this.mHilbertBase};
        this.mDisplayMode.select(0);
        this.mDisplayMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HeapPanel.this.mDisplayMode.getSelectionIndex();
                Client client = HeapPanel.this.getCurrentClient();
                if (client != null) {
                    if (index == 0) {
                        HeapPanel.this.fillDetailedTable(client, true);
                    } else {
                        HeapPanel.this.renderHeapData(client.getClientData(), index - 1, true);
                    }
                }
                ((HeapPanel)HeapPanel.this).mDisplayStack.topControl = HeapPanel.this.mLayout[index];
                HeapPanel.this.mDisplayBase.layout();
            }
        });
        this.mDisplayBase.layout();
        return this.mTop;
    }

    @Override
    public void setFocus() {
        this.mHeapSummary.setFocus();
    }

    private Table createSummaryTable(Composite base) {
        Table tab = new Table(base, 65540);
        tab.setHeaderVisible(true);
        tab.setLinesVisible(true);
        TableColumn col = new TableColumn(tab, 131072);
        col.setText("ID");
        col.pack();
        col = new TableColumn(tab, 131072);
        col.setText("000.000WW");
        col.pack();
        col.setText("Heap Size");
        col = new TableColumn(tab, 131072);
        col.setText("000.000WW");
        col.pack();
        col.setText("Allocated");
        col = new TableColumn(tab, 131072);
        col.setText("000.000WW");
        col.pack();
        col.setText("Free");
        col = new TableColumn(tab, 131072);
        col.setText("000.00%");
        col.pack();
        col.setText("% Used");
        col = new TableColumn(tab, 131072);
        col.setText("000,000,000");
        col.pack();
        col.setText("# Objects");
        TableItem item = new TableItem(tab, 0);
        item.setText("");
        return tab;
    }

    private Table createDetailedTable(Composite base) {
        IPreferenceStore store = DdmUiPreferences.getStore();
        Table tab = new Table(base, 65540);
        tab.setHeaderVisible(true);
        tab.setLinesVisible(true);
        TableHelper.createTableColumn(tab, "Type", 16384, "4-byte array (object[], int[], float[])", PREFS_STATS_COL_TYPE, store);
        TableHelper.createTableColumn(tab, "Count", 131072, "00,000", PREFS_STATS_COL_COUNT, store);
        TableHelper.createTableColumn(tab, "Total Size", 131072, "000.000 WW", PREFS_STATS_COL_SIZE, store);
        TableHelper.createTableColumn(tab, "Smallest", 131072, "000.000 WW", PREFS_STATS_COL_SMALLEST, store);
        TableHelper.createTableColumn(tab, "Largest", 131072, "000.000 WW", PREFS_STATS_COL_LARGEST, store);
        TableHelper.createTableColumn(tab, "Median", 131072, "000.000 WW", PREFS_STATS_COL_MEDIAN, store);
        TableHelper.createTableColumn(tab, "Average", 131072, "000.000 WW", PREFS_STATS_COL_AVERAGE, store);
        tab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Client client = HeapPanel.this.getCurrentClient();
                if (client != null) {
                    Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> heapMap;
                    ArrayList<HeapSegment.HeapSegmentElement> list;
                    int index = HeapPanel.this.mStatisticsTable.getSelectionIndex();
                    TableItem item = HeapPanel.this.mStatisticsTable.getItem(index);
                    if (item != null && (list = (heapMap = client.getClientData().getVmHeapData().getProcessedHeapMap()).get(item.getData())) != null) {
                        HeapPanel.this.showChart(list);
                    }
                }
            }
        });
        return tab;
    }

    private void createChart() {
        this.mAllocCountDataSet = new DefaultCategoryDataset();
        this.mChart = ChartFactory.createBarChart(null, (String)"Size", (String)"Count", (CategoryDataset)this.mAllocCountDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        Font f = this.mStatisticsBase.getFont();
        FontData[] fData = f.getFontData();
        FontData firstFontData = fData[0];
        java.awt.Font awtFont = SWTUtils.toAwtFont((Device)this.mStatisticsBase.getDisplay(), (FontData)firstFontData, (boolean)true);
        this.mChart.setTitle(new TextTitle("Allocation count per size", awtFont));
        Plot plot = this.mChart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            CategoryAxis domainAxis = categoryPlot.getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            CategoryItemRenderer renderer = categoryPlot.getRenderer();
            renderer.setBaseToolTipGenerator(new CategoryToolTipGenerator(){

                public String generateToolTip(CategoryDataset dataset, int row, int column) {
                    ByteLong columnKey = (ByteLong)dataset.getColumnKey(column);
                    String rowKey = (String)((Object)dataset.getRowKey(row));
                    Number value = dataset.getValue((Comparable)((Object)rowKey), (Comparable)columnKey);
                    return String.format("%1$d %2$s of %3$d bytes", value.intValue(), rowKey, columnKey.getValue());
                }
            });
        }
        this.mChartComposite = new ChartComposite(this.mStatisticsBase, 2048, this.mChart, 680, 420, 300, 200, 3000, 3000, true, true, true, true, false, true);
        this.mChartComposite.setLayoutData((Object)new GridData(1808));
    }

    private static String prettyByteCount(long bytes) {
        double fracBytes = bytes;
        String units = " B";
        if (fracBytes < 1024.0) {
            return sByteFormatter.format(fracBytes) + units;
        }
        fracBytes /= 1024.0;
        units = " KB";
        if (fracBytes >= 1024.0) {
            fracBytes /= 1024.0;
            units = " MB";
        }
        if (fracBytes >= 1024.0) {
            fracBytes /= 1024.0;
            units = " GB";
        }
        return sLargeByteFormatter.format(fracBytes) + units;
    }

    private static String approximateByteCount(long bytes) {
        double fracBytes = bytes;
        String units = "";
        if (fracBytes >= 1024.0) {
            fracBytes /= 1024.0;
            units = "K";
        }
        if (fracBytes >= 1024.0) {
            fracBytes /= 1024.0;
            units = "M";
        }
        if (fracBytes >= 1024.0) {
            fracBytes /= 1024.0;
            units = "G";
        }
        return sByteFormatter.format(fracBytes) + units;
    }

    private static String addCommasToNumber(long num) {
        return sCountFormatter.format(num);
    }

    private static String fractionalPercent(long num, long denom) {
        double val = (double)num / (double)denom;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        return nf.format(val *= 100.0) + "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSummaryTable(ClientData cd) {
        if (this.mHeapSummary.isDisposed()) {
            return;
        }
        this.mHeapSummary.setRedraw(false);
        this.mHeapSummary.removeAll();
        int numRows = 0;
        if (cd != null) {
            ClientData clientData = cd;
            synchronized (clientData) {
                Iterator<Integer> iter = cd.getVmHeapIds();
                while (iter.hasNext()) {
                    ++numRows;
                    Integer id = iter.next();
                    Map<String, Long> heapInfo = cd.getVmHeapInfo(id);
                    if (heapInfo == null) continue;
                    long sizeInBytes = heapInfo.get("sizeInBytes");
                    long bytesAllocated = heapInfo.get("bytesAllocated");
                    long objectsAllocated = heapInfo.get("objectsAllocated");
                    TableItem item = new TableItem(this.mHeapSummary, 0);
                    item.setText(0, id.toString());
                    item.setText(1, HeapPanel.prettyByteCount(sizeInBytes));
                    item.setText(2, HeapPanel.prettyByteCount(bytesAllocated));
                    item.setText(3, HeapPanel.prettyByteCount(sizeInBytes - bytesAllocated));
                    item.setText(4, HeapPanel.fractionalPercent(bytesAllocated, sizeInBytes));
                    item.setText(5, HeapPanel.addCommasToNumber(objectsAllocated));
                }
            }
        }
        if (numRows == 0) {
            TableItem item = new TableItem(this.mHeapSummary, 0);
            item.setText("");
        }
        this.mHeapSummary.pack();
        this.mHeapSummary.setRedraw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDetailedTable(Client client, boolean forceRedraw) {
        Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> heapMap;
        ClientData cd;
        if (client == null || !client.isHeapUpdateEnabled()) {
            this.mStatisticsTable.removeAll();
            this.showChart(null);
            return;
        }
        ClientData clientData = cd = client.getClientData();
        synchronized (clientData) {
            if (!this.serializeHeapData(cd.getVmHeapData()) && !forceRedraw) {
                return;
            }
            heapMap = cd.getVmHeapData().getProcessedHeapMap();
        }
        int index = this.mStatisticsTable.getSelectionIndex();
        Integer selectedKey = null;
        if (index != -1) {
            selectedKey = (Integer)this.mStatisticsTable.getItem(index).getData();
        }
        this.mStatisticsTable.setRedraw(false);
        this.mStatisticsTable.removeAll();
        if (heapMap != null) {
            int selectedIndex = -1;
            ArrayList<HeapSegment.HeapSegmentElement> selectedList = null;
            Set<Integer> keys = heapMap.keySet();
            int iter = 0;
            for (Integer key : keys) {
                ArrayList<HeapSegment.HeapSegmentElement> list = heapMap.get(key);
                if (key.equals(selectedKey)) {
                    selectedIndex = iter;
                    selectedList = list;
                }
                ++iter;
                TableItem item = new TableItem(this.mStatisticsTable, 0);
                item.setData((Object)key);
                item.setText(0, mMapLegend[key]);
                int count = list.size();
                item.setText(1, HeapPanel.addCommasToNumber(count));
                if (count <= 0) continue;
                item.setText(3, HeapPanel.prettyByteCount(list.get(0).getLength()));
                item.setText(4, HeapPanel.prettyByteCount(list.get(count - 1).getLength()));
                int median = count / 2;
                HeapSegment.HeapSegmentElement element = list.get(median);
                long size = element.getLength();
                item.setText(5, HeapPanel.prettyByteCount(size));
                long totalSize = 0L;
                for (int i = 0; i < count; ++i) {
                    element = list.get(i);
                    size = element.getLength();
                    totalSize += size;
                }
                item.setText(2, HeapPanel.prettyByteCount(totalSize));
                item.setText(6, HeapPanel.prettyByteCount(totalSize / (long)count));
            }
            this.mStatisticsTable.setRedraw(true);
            if (selectedIndex != -1) {
                this.mStatisticsTable.setSelection(selectedIndex);
                this.showChart(selectedList);
            } else {
                this.showChart(null);
            }
        } else {
            this.mStatisticsTable.setRedraw(true);
        }
    }

    private void showChart(ArrayList<HeapSegment.HeapSegmentElement> list) {
        this.mAllocCountDataSet.clear();
        if (list != null) {
            String rowKey = "Alloc Count";
            long currentSize = -1L;
            int currentCount = 0;
            for (HeapSegment.HeapSegmentElement element : list) {
                if ((long)element.getLength() != currentSize) {
                    if (currentSize != -1L) {
                        ByteLong columnKey = new ByteLong(currentSize);
                        this.mAllocCountDataSet.addValue((double)currentCount, (Comparable)((Object)rowKey), (Comparable)columnKey);
                    }
                    currentSize = element.getLength();
                    currentCount = 1;
                    continue;
                }
                ++currentCount;
            }
            if (currentSize != -1L) {
                ByteLong columnKey = new ByteLong(currentSize);
                this.mAllocCountDataSet.addValue((double)currentCount, (Comparable)((Object)rowKey), (Comparable)columnKey);
            }
        }
    }

    private void createLegend(Composite parent) {
        this.mLegend = new Group(parent, 0);
        this.mLegend.setText(this.getLegendText(0));
        this.mLegend.setLayout((Layout)new GridLayout(2, false));
        RGB[] colors = HeapPanel.mMapPalette.colors;
        for (int i = 0; i < 10; ++i) {
            Image tmpImage = this.createColorRect(parent.getDisplay(), colors[i]);
            Label l = new Label((Composite)this.mLegend, 0);
            l.setImage(tmpImage);
            l = new Label((Composite)this.mLegend, 0);
            l.setText(mMapLegend[i]);
        }
    }

    private String getLegendText(int level) {
        int bytes = 8 * (100 / ZOOMS[level]);
        return String.format("Key (1 pixel = %1$d bytes)", bytes);
    }

    private void setLegendText(int level) {
        this.mLegend.setText(this.getLegendText(level));
    }

    private Image createColorRect(Display display, RGB color) {
        int width = 32;
        int height = 16;
        Image img = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)img);
        gc.setBackground(new Color((Device)display, color));
        gc.fillRectangle(0, 0, width, height);
        gc.dispose();
        return img;
    }

    private void setUpdateStatus(int status) {
        switch (status) {
            case 0: {
                this.mUpdateStatus.setText("Select a client to see heap updates");
                break;
            }
            case 1: {
                this.mUpdateStatus.setText("Heap updates are NOT ENABLED for this client");
                break;
            }
            case 2: {
                this.mUpdateStatus.setText("Heap updates will happen after every GC for this client");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.mUpdateStatus.pack();
    }

    private int nextPow2(int value) {
        for (int i = 31; i >= 0; --i) {
            if ((value & 1 << i) == 0) continue;
            if (i < 31) {
                return 1 << i + 1;
            }
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    private int zOrderData(ImageData id, byte[] pixData) {
        int maxX = 0;
        for (int i = 0; i < pixData.length; ++i) {
            int x = i & 1 | (i >>> 2 & 1) << 1 | (i >>> 4 & 1) << 2 | (i >>> 6 & 1) << 3 | (i >>> 8 & 1) << 4 | (i >>> 10 & 1) << 5 | (i >>> 12 & 1) << 6 | (i >>> 14 & 1) << 7 | (i >>> 16 & 1) << 8 | (i >>> 18 & 1) << 9 | (i >>> 20 & 1) << 10 | (i >>> 22 & 1) << 11 | (i >>> 24 & 1) << 12 | (i >>> 26 & 1) << 13 | (i >>> 28 & 1) << 14 | (i >>> 30 & 1) << 15;
            int y = (i >>> 1 & 1) << 0 | (i >>> 3 & 1) << 1 | (i >>> 5 & 1) << 2 | (i >>> 7 & 1) << 3 | (i >>> 9 & 1) << 4 | (i >>> 11 & 1) << 5 | (i >>> 13 & 1) << 6 | (i >>> 15 & 1) << 7 | (i >>> 17 & 1) << 8 | (i >>> 19 & 1) << 9 | (i >>> 21 & 1) << 10 | (i >>> 23 & 1) << 11 | (i >>> 25 & 1) << 12 | (i >>> 27 & 1) << 13 | (i >>> 29 & 1) << 14 | (i >>> 31 & 1) << 15;
            try {
                id.setPixel(x, y, (int)pixData[i]);
                if (x <= maxX) continue;
                maxX = x;
                continue;
            }
            catch (IllegalArgumentException ex) {
                System.out.println("bad pixels: i " + i + ", w " + id.width + ", h " + id.height + ", x " + x + ", y " + y);
                throw ex;
            }
        }
        return maxX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void hilbertWalk(ImageData id, InputStream pixData, int order, int x, int y, int dir) throws IOException {
        if (x >= id.width || y >= id.height) {
            return;
        }
        if (order == 0) {
            try {
                int p = pixData.read();
                if (p < 0) return;
                id.setPixel(y, x, p);
                if (y > id.x) {
                    id.x = y;
                }
                if (x <= id.y) return;
                id.y = x;
                return;
            }
            catch (IllegalArgumentException ex) {
                System.out.println("bad pixels: order " + order + ", dir " + dir + ", w " + id.width + ", h " + id.height + ", x " + x + ", y " + y);
                throw ex;
            }
        } else {
            int delta = 1 << --order;
            int nextX = x + delta;
            int nextY = y + delta;
            switch (dir) {
                case 2: {
                    this.hilbertWalk(id, pixData, order, x, y, 0);
                    this.hilbertWalk(id, pixData, order, x, nextY, 2);
                    this.hilbertWalk(id, pixData, order, nextX, nextY, 2);
                    this.hilbertWalk(id, pixData, order, nextX, y, 1);
                    return;
                }
                case 0: {
                    this.hilbertWalk(id, pixData, order, x, y, 2);
                    this.hilbertWalk(id, pixData, order, nextX, y, 0);
                    this.hilbertWalk(id, pixData, order, nextX, nextY, 0);
                    this.hilbertWalk(id, pixData, order, x, nextY, 3);
                    return;
                }
                case 1: {
                    this.hilbertWalk(id, pixData, order, nextX, nextY, 3);
                    this.hilbertWalk(id, pixData, order, x, nextY, 1);
                    this.hilbertWalk(id, pixData, order, x, y, 1);
                    this.hilbertWalk(id, pixData, order, nextX, y, 2);
                    return;
                }
                case 3: {
                    this.hilbertWalk(id, pixData, order, nextX, nextY, 1);
                    this.hilbertWalk(id, pixData, order, nextX, y, 3);
                    this.hilbertWalk(id, pixData, order, x, y, 3);
                    this.hilbertWalk(id, pixData, order, x, nextY, 0);
                    return;
                }
                default: {
                    throw new RuntimeException("Unexpected Hilbert direction " + dir);
                }
            }
        }
    }

    private Point hilbertOrderData(ImageData id, byte[] pixData) {
        int order = 0;
        for (int n = 1; n < id.width; n *= 2) {
            ++order;
        }
        Point p = new Point(0, 0);
        int oldIdX = id.x;
        int oldIdY = id.y;
        id.y = 0;
        id.x = 0;
        try {
            this.hilbertWalk(id, new ByteArrayInputStream(pixData), order, 0, 0, 2);
            p.x = id.x;
            p.y = id.y;
        }
        catch (IOException ex) {
            System.err.println("Exception during hilbertWalk()");
            p.x = id.height;
            p.y = id.width;
        }
        id.x = oldIdX;
        id.y = oldIdY;
        return p;
    }

    private ImageData createHilbertHeapImage(byte[] pixData) {
        int w = (int)Math.sqrt(2097152.0);
        int h = w = this.nextPow2(w);
        ImageData id = new ImageData(w, h, 8, mMapPalette);
        Point maxP = this.hilbertOrderData(id, pixData);
        int factor = 100 / ZOOMS[this.mZoom.getSelectionIndex()];
        if (factor != 1) {
            int tmp = maxP.x % factor;
            if (tmp != 0) {
                maxP.x += factor - tmp;
            }
            if ((tmp = maxP.y % factor) != 0) {
                maxP.y += factor - tmp;
            }
        }
        if (maxP.y < id.height) {
            id = new ImageData(id.width, maxP.y, id.depth, id.palette, id.scanlinePad, id.data);
        }
        if (maxP.x < id.width) {
            ImageData croppedId = new ImageData(maxP.x, id.height, id.depth, id.palette);
            int[] buffer = new int[maxP.x];
            for (int l = 0; l < id.height; ++l) {
                id.getPixels(0, l, maxP.x, buffer, 0);
                croppedId.setPixels(0, l, maxP.x, buffer, 0);
            }
            id = croppedId;
        }
        if (factor != 1) {
            id = id.scaledTo(id.width / factor, id.height / factor);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderHeapData(ClientData cd, int mode, boolean forceRedraw) {
        Image image;
        byte[] pixData;
        ClientData clientData = cd;
        synchronized (clientData) {
            if (!this.serializeHeapData(cd.getVmHeapData()) && !forceRedraw) {
                return;
            }
            pixData = this.getSerializedData();
        }
        if (pixData != null) {
            ImageData id = mode == 1 ? this.createHilbertHeapImage(pixData) : this.createLinearHeapImage(pixData, 200, mMapPalette);
            image = new Image((Device)this.mDisplay, id);
        } else {
            int width;
            int height;
            if (mode == 1) {
                height = 200;
                width = 200;
            } else {
                width = 300;
                height = 100;
            }
            image = new Image((Device)this.mDisplay, width, height);
            GC gc = new GC((Drawable)image);
            gc.setForeground(this.mDisplay.getSystemColor(3));
            gc.drawLine(0, 0, width - 1, height - 1);
            gc.dispose();
            gc = null;
        }
        if (mode == 1) {
            if (this.mHilbertImage != null) {
                this.mHilbertImage.dispose();
            }
            this.mHilbertImage = image;
            this.mHilbertHeapImage.setImage(this.mHilbertImage);
            this.mHilbertHeapImage.pack(true);
            this.mHilbertBase.layout();
            this.mHilbertBase.pack(true);
        } else {
            if (this.mLinearImage != null) {
                this.mLinearImage.dispose();
            }
            this.mLinearImage = image;
            this.mLinearHeapImage.setImage(this.mLinearImage);
            this.mLinearHeapImage.pack(true);
            this.mLinearBase.layout();
            this.mLinearBase.pack(true);
        }
    }

    @Override
    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mHeapSummary);
    }

    static {
        sByteFormatter.setMinimumFractionDigits(0);
        sByteFormatter.setMaximumFractionDigits(1);
        sLargeByteFormatter.setMinimumFractionDigits(3);
        sLargeByteFormatter.setMaximumFractionDigits(3);
        sCountFormatter.setGroupingUsed(true);
    }

    private static class ByteLong
    implements Comparable<ByteLong> {
        private long mValue;

        private ByteLong(long value) {
            this.mValue = value;
        }

        public long getValue() {
            return this.mValue;
        }

        public String toString() {
            return HeapPanel.approximateByteCount(this.mValue);
        }

        @Override
        public int compareTo(ByteLong other) {
            if (this.mValue != other.mValue) {
                return this.mValue < other.mValue ? -1 : 1;
            }
            return 0;
        }
    }
}

