/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.menus.ContributionFactoryGenerator;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.MenuPersistence;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;

public class WorkbenchMenuService
implements IMenuService {
    private IEclipseContext e4Context;
    private ExpressionContext legacyContext;
    private MenuPersistence persistence;
    private Map<AbstractContributionFactory, Object> factoriesToContributions = new HashMap<AbstractContributionFactory, Object>();

    public WorkbenchMenuService(ServiceLocator serviceLocator, IEclipseContext e4Context) {
        this.e4Context = e4Context;
        this.persistence = new MenuPersistence((MApplication)e4Context.get(MApplication.class), e4Context);
    }

    public void addSourceProvider(ISourceProvider provider) {
    }

    public void removeSourceProvider(ISourceProvider provider) {
    }

    public void dispose() {
        this.persistence.dispose();
    }

    private boolean inToolbar(MenuLocationURI location) {
        return location.getScheme().startsWith("toolbar");
    }

    public void addContributionFactory(AbstractContributionFactory factory) {
        MenuLocationURI location = new MenuLocationURI(factory.getLocation());
        if (location.getPath() == null || location.getPath().length() == 0) {
            WorkbenchPlugin.log("WorkbenchMenuService.addContributionFactory: Invalid menu URI: " + location);
            return;
        }
        if (this.inToolbar(location)) {
            if (!MenuAdditionCacheEntry.isInWorkbenchTrim(location)) {
                String query = location.getQuery();
                if (query == null || query.length() == 0) {
                    query = "after=additions";
                }
                this.processToolbarChildren(factory, location, location.getPath(), query);
            }
            return;
        }
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.setElementId(String.valueOf(factory.getNamespace()) + ":" + factory.hashCode());
        if ("org.eclipse.ui.popup.any".equals(location.getPath())) {
            menuContribution.setParentId("popup");
        } else {
            menuContribution.setParentId(location.getPath());
        }
        String query = location.getQuery();
        if (query == null || query.length() == 0) {
            query = "after=additions";
        }
        menuContribution.setPositionInParent(query);
        menuContribution.getTags().add("scheme:" + location.getScheme());
        String filter = "menuContribution:menu";
        if ("popup".equals(location.getScheme())) {
            filter = "menuContribution:popup";
        }
        menuContribution.getTags().add(filter);
        ContributionFactoryGenerator generator = new ContributionFactoryGenerator(factory, 0);
        menuContribution.getTransientData().put("ContributionFactory", generator);
        this.factoriesToContributions.put(factory, menuContribution);
        MApplication app = (MApplication)this.e4Context.get(MApplication.class);
        app.getMenuContributions().add(menuContribution);
    }

    private void processToolbarChildren(AbstractContributionFactory factory, MenuLocationURI location, String parentId, String position) {
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        toolBarContribution.setElementId(String.valueOf(factory.getNamespace()) + ":" + factory.hashCode());
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent(position);
        toolBarContribution.getTags().add("scheme:" + location.getScheme());
        ContributionFactoryGenerator generator = new ContributionFactoryGenerator(factory, 1);
        toolBarContribution.getTransientData().put("ToolBarContributionFactory", generator);
        this.factoriesToContributions.put(factory, toolBarContribution);
        MApplication app = (MApplication)this.e4Context.get(MApplication.class);
        app.getToolBarContributions().add(toolBarContribution);
    }

    public void removeContributionFactory(AbstractContributionFactory factory) {
        Object contribution = this.factoriesToContributions.remove(factory);
        if (contribution != null) {
            MApplication app = (MApplication)this.e4Context.get(MApplication.class);
            if (app == null) {
                return;
            }
            if (contribution instanceof MMenuContribution) {
                app.getMenuContributions().remove(contribution);
            } else if (contribution instanceof MToolBarContribution) {
                app.getToolBarContributions().remove(contribution);
            }
        }
    }

    public void populateContributionManager(ContributionManager mgr, String location) {
    }

    public void releaseContributions(ContributionManager mgr) {
    }

    public IEvaluationContext getCurrentState() {
        if (this.legacyContext == null) {
            this.legacyContext = new ExpressionContext(this.e4Context);
        }
        return this.legacyContext;
    }

    public void readRegistry() {
        this.persistence.read();
    }

    public void updateManagers() {
        E4Util.unsupported("WorkbenchMenuService.updateManagers - time to update ... something");
    }

    public void registerVisibleWhen(IContributionItem item, Expression visibleWhen, Set restriction, String createIdentifierId) {
    }

    public void unregisterVisibleWhen(IContributionItem item, Set restriction) {
    }
}

