/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPageService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.SlavePageService;
import org.eclipse.ui.internal.SlavePartService;
import org.eclipse.ui.internal.SlaveSelectionService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.contexts.SlaveContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.progress.WorkbenchSiteProgressService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.testing.WorkbenchPartTestable;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.testing.IWorkbenchPartTestable;

public abstract class PartSite
implements IWorkbenchPartSite {
    private IWorkbenchPartReference partReference;
    private IWorkbenchPart part;
    private ISelectionProvider selectionProvider;
    private SubActionBars actionBars;
    private KeyBindingService keyBindingService;
    private SlavePageService pageService;
    private SlavePartService partService;
    private SlaveSelectionService selectionService;
    private SlaveContextService contextService;
    protected ArrayList menuExtenders;
    private WorkbenchSiteProgressService progressService;
    protected final ServiceLocator serviceLocator;
    protected MPart model;
    private IConfigurationElement element;
    private IEclipseContext e4Context;
    private IWorkbenchWindow workbenchWindow;
    private String extensionId;

    public static final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput, IWorkbenchPart part, IEclipseContext context, Collection menuExtenders) {
        Iterator extenderItr = menuExtenders.iterator();
        boolean foundMatch = false;
        while (extenderItr.hasNext()) {
            PopupMenuExtender existingExtender = (PopupMenuExtender)extenderItr.next();
            if (!existingExtender.matches(menuManager, selectionProvider, part)) continue;
            existingExtender.addMenuId(menuId);
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            menuExtenders.add(new PopupMenuExtender(menuId, menuManager, selectionProvider, part, context, includeEditorInput));
        }
    }

    public PartSite(MPart model, IWorkbenchPart part, IWorkbenchPartReference ref, IConfigurationElement element) {
        this.model = model;
        this.part = part;
        this.partReference = ref;
        this.element = element;
        MElementContainer parent = (MElementContainer)((EObject)model).eContainer();
        while (!(parent instanceof MWindow)) {
            parent = (MElementContainer)((EObject)parent).eContainer();
        }
        this.setWindow((MWindow)parent);
        this.e4Context = model.getContext();
        IServiceLocatorCreator slc = (IServiceLocatorCreator)this.e4Context.get(IServiceLocatorCreator.class.getName());
        IWorkbenchWindow workbenchWindow = this.getWorkbenchWindow();
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(workbenchWindow, null, new IDisposable(){

            public void dispose() {
            }
        }, this.e4Context);
        this.initializeDefaultServices();
    }

    void setExtensionId(String extensionId) {
        this.extensionId = extensionId;
    }

    private void setWindow(MWindow window) {
        MWindow topWindow = this.getTopLevelModelWindow(window);
        MApplication application = (MApplication)topWindow.getContext().get(MApplication.class.getName());
        Workbench workbench = (Workbench)application.getContext().get(IWorkbench.class.getName());
        this.workbenchWindow = workbench.createWorkbenchWindow(workbench.getDefaultPageInput(), workbench.getPerspectiveRegistry().findPerspectiveWithId(workbench.getPerspectiveRegistry().getDefaultPerspective()), topWindow, false);
    }

    private void initializeDefaultServices() {
        LegacyHandlerService handlerService = new LegacyHandlerService(this.e4Context, new ActivePartExpression(this.part));
        this.e4Context.set(IHandlerService.class.getName(), (Object)handlerService);
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.part.IWorkbenchPartSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this, null, null, 2));
        this.serviceLocator.registerService(IWorkbenchPartSite.class, this);
        this.e4Context.set(IWorkbenchSiteProgressService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.progressService == null) {
                    PartSite.this.progressService = new WorkbenchSiteProgressService(PartSite.this);
                }
                return PartSite.this.progressService;
            }
        });
        this.e4Context.set(IProgressService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.progressService == null) {
                    PartSite.this.progressService = new WorkbenchSiteProgressService(PartSite.this);
                }
                return PartSite.this.progressService;
            }
        });
        this.e4Context.set(IKeyBindingService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.keyBindingService == null) {
                    PartSite.this.keyBindingService = new KeyBindingService(PartSite.this);
                }
                return PartSite.this.keyBindingService;
            }
        });
        this.e4Context.set(IPageService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.pageService == null) {
                    PartSite.this.pageService = new SlavePageService((IPageService)context.getParent().get(IPageService.class));
                }
                return PartSite.this.pageService;
            }
        });
        this.e4Context.set(IPartService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.partService == null) {
                    PartSite.this.partService = new SlavePartService((IPartService)context.getParent().get(IPartService.class));
                }
                return PartSite.this.partService;
            }
        });
        this.e4Context.set(ISelectionService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.selectionService == null) {
                    PartSite.this.selectionService = new SlaveSelectionService((ISelectionService)context.getParent().get(ISelectionService.class));
                }
                return PartSite.this.selectionService;
            }
        });
        this.e4Context.set(IContextService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (PartSite.this.contextService == null) {
                    PartSite.this.contextService = new SlaveContextService((IContextService)context.getParent().get(IContextService.class), new ActivePartExpression(PartSite.this.part));
                }
                return PartSite.this.contextService;
            }
        });
    }

    public void dispose() {
        if (this.menuExtenders != null) {
            HashSet<MenuManager> managers = new HashSet<MenuManager>(this.menuExtenders.size());
            int i = 0;
            while (i < this.menuExtenders.size()) {
                PopupMenuExtender ext = (PopupMenuExtender)this.menuExtenders.get(i);
                managers.add(ext.getManager());
                ext.dispose();
                ++i;
            }
            if (managers.size() > 0) {
                for (MenuManager mgr : managers) {
                    mgr.dispose();
                }
            }
            this.menuExtenders = null;
        }
        if (this.keyBindingService != null) {
            this.keyBindingService.dispose();
            this.keyBindingService = null;
        }
        if (this.progressService != null) {
            this.progressService.dispose();
            this.progressService = null;
        }
        if (this.pageService != null) {
            this.pageService.dispose();
        }
        if (this.partService != null) {
            this.partService.dispose();
        }
        if (this.selectionService != null) {
            this.selectionService.dispose();
        }
        if (this.contextService != null) {
            this.contextService.dispose();
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
        }
        this.part = null;
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public String getId() {
        return this.extensionId == null ? (this.element == null ? this.model.getElementId() : this.element.getAttribute("id")) : this.extensionId;
    }

    public String getPluginId() {
        return this.element == null ? this.model.getElementId() : this.element.getNamespaceIdentifier();
    }

    public String getRegisteredName() {
        return this.element == null ? this.model.getLocalizedLabel() : this.element.getAttribute("name");
    }

    public IWorkbenchPage getPage() {
        return this.getWorkbenchWindow().getActivePage();
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay == null) {
            return this.getWorkbenchWindow().getShell();
        }
        Control control = (Control)this.model.getWidget();
        if (control != null && !control.isDisposed()) {
            return control.getShell();
        }
        MWindow window = (MWindow)this.e4Context.get(MWindow.class);
        return window == null ? this.getWorkbenchWindow().getShell() : (Shell)window.getWidget();
    }

    private MWindow getTopLevelModelWindow(MWindow window) {
        EObject previousParent = (EObject)window;
        EObject parent = previousParent.eContainer();
        while (!(parent instanceof MApplication)) {
            previousParent = parent;
            parent = parent.eContainer();
        }
        return (MWindow)previousParent;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.workbenchWindow;
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuID, menuMgr, selProvider, true, this.getPart(), this.e4Context, this.menuExtenders);
    }

    public void registerContextMenu(MenuManager menuMgr, ISelectionProvider selProvider) {
        this.registerContextMenu(this.getId(), menuMgr, selProvider);
    }

    public String[] getContextMenuIds() {
        if (this.menuExtenders == null) {
            return new String[0];
        }
        ArrayList<String> menuIds = new ArrayList<String>(this.menuExtenders.size());
        for (PopupMenuExtender extender : this.menuExtenders) {
            menuIds.addAll(extender.getMenuIds());
        }
        return menuIds.toArray(new String[menuIds.size()]);
    }

    public void setActionBars(SubActionBars bars) {
        this.actionBars = bars;
    }

    public void setPart(IWorkbenchPart newPart) {
        this.part = newPart;
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public IKeyBindingService getKeyBindingService() {
        return (IKeyBindingService)this.e4Context.get(IKeyBindingService.class.getName());
    }

    protected String getInitialScopeId() {
        return null;
    }

    public final Object getAdapter(Class adapter) {
        if (IWorkbenchSiteProgressService.class == adapter) {
            return this.getService(adapter);
        }
        if (IWorkbenchPartTestable.class == adapter) {
            return new WorkbenchPartTestable(this);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void activateActionBars(boolean forceVisibility) {
        if (this.serviceLocator != null) {
            this.serviceLocator.activate();
        }
        if (this.actionBars != null) {
            this.actionBars.activate(forceVisibility);
        }
    }

    public void deactivateActionBars(boolean forceHide) {
        if (this.actionBars != null) {
            this.actionBars.deactivate(forceHide);
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.deactivate();
        }
    }

    WorkbenchSiteProgressService getSiteProgressService() {
        return (WorkbenchSiteProgressService)this.e4Context.get(IWorkbenchSiteProgressService.class.getName());
    }

    public final Object getService(Class key) {
        return this.serviceLocator.getService(key);
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PartSite(id=");
        buffer.append(this.getId());
        buffer.append(",pluginId=");
        buffer.append(this.getPluginId());
        buffer.append(",registeredName=");
        buffer.append(this.getRegisteredName());
        buffer.append(",hashCode=");
        buffer.append(this.hashCode());
        buffer.append(')');
        return buffer.toString();
    }

    public MPart getModel() {
        return this.model;
    }

    public IEclipseContext getContext() {
        return this.e4Context;
    }
}

