/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ddmuilib.AbstractBufferFindTarget;
import com.android.ddmuilib.FindDialog;
import com.android.ddmuilib.IFindTarget;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.GlTracePlugin;
import com.android.ide.eclipse.gltrace.SwtUtils;
import com.android.ide.eclipse.gltrace.TraceFileParserTask;
import com.android.ide.eclipse.gltrace.editors.DurationMinimap;
import com.android.ide.eclipse.gltrace.editors.GLCallGroups;
import com.android.ide.eclipse.gltrace.editors.StateViewPage;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLFrame;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import com.android.ide.eclipse.gltrace.views.FrameSummaryViewPage;
import com.android.ide.eclipse.gltrace.views.detail.DetailsPage;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

public class GLFunctionTraceViewer
extends EditorPart
implements ISelectionProvider {
    public static final String ID = "com.android.ide.eclipse.gltrace.GLFunctionTrace";
    private static final String DEFAULT_FILTER_MESSAGE = "Filter list of OpenGL calls. Accepts Java regexes.";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static Image sExpandAllIcon;
    private static String sLastExportedToFolder;
    private String mFilePath;
    private Scale mFrameSelectionScale;
    private Spinner mFrameSelectionSpinner;
    private GLTrace mTrace;
    private TreeViewer mFrameTreeViewer;
    private List<GLCallGroups.GLCallNode> mTreeViewerNodes;
    private Text mFilterText;
    private GLCallFilter mGLCallFilter;
    private Color mGldrawTextColor;
    private Color mGlCallErrorColor;
    private Job mTreeRefresherJob;
    private final Object mTreeRefresherLock = new Object();
    private static final int TREE_REFRESH_INTERVAL_MS = 250;
    private int mCurrentFrame;
    private int mCallStartIndex;
    private int mCallEndIndex;
    private DurationMinimap mDurationMinimap;
    private ScrollBar mVerticalScrollBar;
    private Combo mContextSwitchCombo;
    private boolean mShowContextSwitcher;
    private int mCurrentlyDisplayedContext = -1;
    private StateViewPage mStateViewPage;
    private FrameSummaryViewPage mFrameSummaryViewPage;
    private DetailsPage mDetailsPage;
    private ToolItem mExpandAllToolItem;
    private ToolItem mCollapseAllToolItem;
    private ToolItem mSaveAsToolItem;
    private FindDialog mFindDialog;
    private TraceViewerFindTarget mFindTarget = new TraceViewerFindTarget();

    public GLFunctionTraceViewer() {
        this.mGldrawTextColor = Display.getDefault().getSystemColor(9);
        this.mGlCallErrorColor = Display.getDefault().getSystemColor(3);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IURIEditorInput)) {
            throw new PartInitException("GL Function Trace View: unsupported input type.");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.mFilePath = ((IURIEditorInput)iEditorInput).getURI().getPath();
        File file = new File(this.mFilePath);
        this.setPartName(file.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.setInput(composite.getShell(), this.mFilePath);
        this.createFrameSelectionControls(composite2);
        this.createOptionsBar(composite2);
        this.createFrameTraceView(composite2);
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFrameTreeViewer);
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action("Copy"){

            public void run() {
                GLFunctionTraceViewer.this.copySelectionToClipboard();
            }
        });
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action("Select All"){

            public void run() {
                GLFunctionTraceViewer.this.selectAll();
            }
        });
        iActionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)new Action("Find"){

            public void run() {
                GLFunctionTraceViewer.this.showFindDialog();
            }
        });
    }

    public void setInput(Shell shell, String string) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        TraceFileParserTask traceFileParserTask = new TraceFileParserTask(this.mFilePath);
        try {
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)traceFileParserTask);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)shell, (String)"Error parsing OpenGL Trace File", (String)invocationTargetException.getCause().getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.mTrace = traceFileParserTask.getTrace();
        boolean bl = this.mTrace == null ? false : (this.mShowContextSwitcher = this.mTrace.getContexts().size() > 1);
        if (this.mStateViewPage != null) {
            this.mStateViewPage.setInput(this.mTrace);
        }
        if (this.mFrameSummaryViewPage != null) {
            this.mFrameSummaryViewPage.setInput(this.mTrace);
        }
        if (this.mDetailsPage != null) {
            this.mDetailsPage.setInput(this.mTrace);
        }
        if (this.mDurationMinimap != null) {
            this.mDurationMinimap.setInput(this.mTrace);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GLFunctionTraceViewer.this.refreshUI();
            }
        });
    }

    private void refreshUI() {
        if (this.mTrace == null || this.mTrace.getGLCalls().size() == 0) {
            this.setFrameCount(0);
            return;
        }
        this.setFrameCount(this.mTrace.getFrames().size());
        this.selectFrame(1);
    }

    private void createFrameSelectionControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Select Frame:");
        this.mFrameSelectionScale = new Scale(composite2, 256);
        this.mFrameSelectionScale.setMinimum(1);
        this.mFrameSelectionScale.setMaximum(1);
        this.mFrameSelectionScale.setSelection(0);
        gridData = new GridData(768);
        this.mFrameSelectionScale.setLayoutData((Object)gridData);
        this.mFrameSelectionScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = GLFunctionTraceViewer.this.mFrameSelectionScale.getSelection();
                GLFunctionTraceViewer.this.mFrameSelectionSpinner.setSelection(n);
                GLFunctionTraceViewer.this.selectFrame(n);
            }
        });
        this.mFrameSelectionSpinner = new Spinner(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = SwtUtils.getApproximateFontWidth((Control)this.mFrameSelectionSpinner) * 6;
        this.mFrameSelectionSpinner.setLayoutData((Object)gridData);
        this.mFrameSelectionSpinner.setMinimum(1);
        this.mFrameSelectionSpinner.setMaximum(1);
        this.mFrameSelectionSpinner.setSelection(0);
        this.mFrameSelectionSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = GLFunctionTraceViewer.this.mFrameSelectionSpinner.getSelection();
                GLFunctionTraceViewer.this.mFrameSelectionScale.setSelection(n);
                GLFunctionTraceViewer.this.selectFrame(n);
            }
        });
    }

    private void setFrameCount(int n) {
        boolean bl = n > 0;
        this.mFrameSelectionScale.setEnabled(bl);
        this.mFrameSelectionSpinner.setEnabled(bl);
        this.mFrameSelectionScale.setMaximum(n);
        this.mFrameSelectionSpinner.setMaximum(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFrame(int n) {
        this.mFrameSelectionScale.setSelection(n);
        this.mFrameSelectionSpinner.setSelection(n);
        Object object = this.mTreeRefresherLock;
        synchronized (object) {
            if (this.mTrace != null) {
                GLFrame gLFrame = this.mTrace.getFrame(n - 1);
                this.mCallStartIndex = gLFrame.getStartIndex();
                this.mCallEndIndex = gLFrame.getEndIndex();
            } else {
                this.mCallEndIndex = 0;
                this.mCallStartIndex = 0;
            }
            this.mCurrentFrame = n - 1;
            this.scheduleNewRefreshJob();
        }
        this.mDurationMinimap.setCallRangeForCurrentFrame(this.mCallStartIndex, this.mCallEndIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectContext(int n) {
        if (this.mCurrentlyDisplayedContext == n) {
            return;
        }
        Object object = this.mTreeRefresherLock;
        synchronized (object) {
            this.mCurrentlyDisplayedContext = n;
            this.scheduleNewRefreshJob();
        }
    }

    private void scheduleNewRefreshJob() {
        if (this.mTreeRefresherJob != null) {
            return;
        }
        this.mTreeRefresherJob = new Job("Refresh GL Trace View Tree"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor iProgressMonitor) {
                int n;
                int n2;
                int n3;
                Object object = GLFunctionTraceViewer.this.mTreeRefresherLock;
                synchronized (object) {
                    n3 = GLFunctionTraceViewer.this.mCallStartIndex;
                    n2 = GLFunctionTraceViewer.this.mCallEndIndex;
                    n = GLFunctionTraceViewer.this.mCurrentlyDisplayedContext;
                    GLFunctionTraceViewer.this.mTreeRefresherJob = null;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GLFunctionTraceViewer.this.refreshTree(n3, n2, n);
                        if (GLFunctionTraceViewer.this.mFrameSummaryViewPage != null) {
                            GLFunctionTraceViewer.this.mFrameSummaryViewPage.setSelectedFrame(GLFunctionTraceViewer.this.mCurrentFrame);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.mTreeRefresherJob.setPriority(20);
        this.mTreeRefresherJob.schedule(250L);
    }

    private void refreshTree(int n, int n2, int n3) {
        this.mTreeViewerNodes = GLCallGroups.constructCallHierarchy(this.mTrace, n, n2, n3);
        this.mFrameTreeViewer.setInput(this.mTreeViewerNodes);
        this.mFrameTreeViewer.refresh();
        this.mFrameTreeViewer.expandAll();
    }

    private void createOptionsBar(Composite composite) {
        Object object;
        int n = this.mShowContextSwitcher ? 4 : 3;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(n, false));
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Filter:");
        this.mFilterText = new Text(composite2, 2944);
        this.mFilterText.setLayoutData((Object)new GridData(768));
        this.mFilterText.setMessage(DEFAULT_FILTER_MESSAGE);
        this.mFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GLFunctionTraceViewer.this.updateAppliedFilters();
            }
        });
        if (this.mShowContextSwitcher) {
            this.mContextSwitchCombo = new Combo(composite2, 2056);
            this.mContextSwitchCombo.add("All Contexts");
            this.mContextSwitchCombo.select(0);
            this.mCurrentlyDisplayedContext = -1;
            int n2 = 0;
            while (n2 < this.mTrace.getContexts().size()) {
                this.mContextSwitchCombo.add("Context " + n2);
                ++n2;
            }
            this.mContextSwitchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    GLFunctionTraceViewer.this.selectContext(GLFunctionTraceViewer.this.mContextSwitchCombo.getSelectionIndex() - 1);
                }
            });
        } else {
            this.mCurrentlyDisplayedContext = 0;
        }
        ToolBar toolBar = new ToolBar(composite2, 0x800800);
        this.mExpandAllToolItem = new ToolItem(toolBar, 8);
        this.mExpandAllToolItem.setToolTipText("Expand All");
        if (sExpandAllIcon == null) {
            object = GlTracePlugin.getImageDescriptor("/icons/expandall.png");
            sExpandAllIcon = object.createImage();
        }
        if (sExpandAllIcon != null) {
            this.mExpandAllToolItem.setImage(sExpandAllIcon);
        }
        this.mCollapseAllToolItem = new ToolItem(toolBar, 8);
        this.mCollapseAllToolItem.setToolTipText("Collapse All");
        this.mCollapseAllToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL"));
        this.mSaveAsToolItem = new ToolItem(toolBar, 8);
        this.mSaveAsToolItem.setToolTipText("Export Trace");
        this.mSaveAsToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVEAS_EDIT"));
        object = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.getSource() == GLFunctionTraceViewer.this.mCollapseAllToolItem) {
                    GLFunctionTraceViewer.this.setTreeItemsExpanded(false);
                } else if (selectionEvent.getSource() == GLFunctionTraceViewer.this.mExpandAllToolItem) {
                    GLFunctionTraceViewer.this.setTreeItemsExpanded(true);
                } else if (selectionEvent.getSource() == GLFunctionTraceViewer.this.mSaveAsToolItem) {
                    GLFunctionTraceViewer.this.exportTrace();
                }
            }
        };
        this.mExpandAllToolItem.addSelectionListener((SelectionListener)object);
        this.mCollapseAllToolItem.addSelectionListener((SelectionListener)object);
        this.mSaveAsToolItem.addSelectionListener((SelectionListener)object);
    }

    private void updateAppliedFilters() {
        this.mGLCallFilter.setFilters(this.mFilterText.getText().trim());
        this.mFrameTreeViewer.refresh();
    }

    private void createFrameTraceView(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        final Tree tree = new Tree(composite2, 67586);
        gridData = new GridData(1808);
        tree.setLayoutData((Object)gridData);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.mFrameTreeViewer = new TreeViewer(tree);
        GLFrameLabelProvider gLFrameLabelProvider = new GLFrameLabelProvider();
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.mFrameTreeViewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)gLFrameLabelProvider);
        TreeColumn treeColumn = treeViewerColumn.getColumn();
        treeColumn.setText("Function");
        treeColumn.setWidth(500);
        treeViewerColumn = new TreeViewerColumn(this.mFrameTreeViewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)gLFrameLabelProvider);
        treeColumn = treeViewerColumn.getColumn();
        treeColumn.setText("Wall Time (ns)");
        treeColumn.setWidth(150);
        treeColumn.setAlignment(131072);
        treeViewerColumn = new TreeViewerColumn(this.mFrameTreeViewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)gLFrameLabelProvider);
        treeColumn = treeViewerColumn.getColumn();
        treeColumn.setText("Thread Time (ns)");
        treeColumn.setWidth(150);
        treeColumn.setAlignment(131072);
        this.mFrameTreeViewer.setContentProvider((IContentProvider)new GLFrameContentProvider());
        this.mGLCallFilter = new GLCallFilter();
        this.mFrameTreeViewer.addFilter((ViewerFilter)this.mGLCallFilter);
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                int n = ((GLFunctionTraceViewer)GLFunctionTraceViewer.this).mFrameTreeViewer.getTree().getClientArea().width;
                if (n > 200) {
                    GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getColumn(2).setWidth(100);
                    GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getColumn(1).setWidth(100);
                    GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getColumn(0).setWidth(n - 200);
                }
            }
        });
        this.mDurationMinimap = new DurationMinimap(composite2, this.mTrace);
        gridData = new GridData(1040);
        gridData.widthHint = gridData.minimumWidth = this.mDurationMinimap.getMinimumWidth();
        this.mDurationMinimap.setLayoutData(gridData);
        this.mDurationMinimap.addCallSelectionListener(new DurationMinimap.ICallSelectionListener(){

            @Override
            public void callSelected(int n) {
                if (n > 0 && n < GLFunctionTraceViewer.this.mTreeViewerNodes.size()) {
                    TreeItem treeItem = tree.getItem(n);
                    tree.select(treeItem);
                    tree.setTopItem(treeItem);
                }
            }
        });
        this.mVerticalScrollBar = tree.getVerticalBar();
        this.mVerticalScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GLFunctionTraceViewer.this.updateVisibleRange();
            }
        });
    }

    private void updateVisibleRange() {
        int n = this.mCallStartIndex;
        int n2 = this.mCallEndIndex;
        if (this.mVerticalScrollBar.isEnabled()) {
            int n3 = this.mVerticalScrollBar.getSelection();
            int n4 = this.mVerticalScrollBar.getThumb();
            int n5 = this.mVerticalScrollBar.getMaximum();
            double d = (double)n3 / (double)n5;
            double d2 = (double)(n3 + n4) / (double)n5;
            int n6 = this.mCallEndIndex - this.mCallStartIndex;
            n = this.mCallStartIndex + (int)Math.floor((double)n6 * d);
            n2 = this.mCallStartIndex + (int)Math.ceil((double)n6 * d2);
        }
        this.mDurationMinimap.setVisibleCallRange(n, n2);
    }

    public void setFocus() {
        this.mFrameTreeViewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.mFrameTreeViewer != null) {
            this.mFrameTreeViewer.addSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        if (this.mFrameTreeViewer != null) {
            return this.mFrameTreeViewer.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (this.mFrameTreeViewer != null) {
            this.mFrameTreeViewer.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public void setSelection(ISelection iSelection) {
        if (this.mFrameTreeViewer != null) {
            this.mFrameTreeViewer.setSelection(iSelection);
        }
    }

    public GLTrace getTrace() {
        return this.mTrace;
    }

    public StateViewPage getStateViewPage() {
        if (this.mStateViewPage == null) {
            this.mStateViewPage = new StateViewPage(this.mTrace);
        }
        return this.mStateViewPage;
    }

    public FrameSummaryViewPage getFrameSummaryViewPage() {
        if (this.mFrameSummaryViewPage == null) {
            this.mFrameSummaryViewPage = new FrameSummaryViewPage(this.mTrace);
        }
        return this.mFrameSummaryViewPage;
    }

    public DetailsPage getDetailsPage() {
        if (this.mDetailsPage == null) {
            this.mDetailsPage = new DetailsPage(this.mTrace);
        }
        return this.mDetailsPage;
    }

    private void copySelectionToClipboard() {
        TreeItem treeItem;
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        TreeItem[] treeItemArray = this.mFrameTreeViewer.getTree().getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            treeItem = treeItemArray[n2];
            Object object = treeItem.getData();
            if (object instanceof GLCallGroups.GLCallNode) {
                stringBuilder.append(((GLCallGroups.GLCallNode)object).getCall());
                stringBuilder.append(NEWLINE);
            }
            ++n2;
        }
        if (stringBuilder.length() > 0) {
            treeItem = new Clipboard(Display.getDefault());
            treeItem.setContents(new Object[]{stringBuilder.toString()}, new Transfer[]{TextTransfer.getInstance()});
            treeItem.dispose();
        }
    }

    private void selectAll() {
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        this.mFrameTreeViewer.getTree().selectAll();
    }

    private void exportTrace() {
        String string;
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        if (this.mCallEndIndex == 0) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this.mFrameTreeViewer.getTree().getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        if (sLastExportedToFolder != null) {
            fileDialog.setFilterPath(sLastExportedToFolder);
        }
        if ((string = fileDialog.open()) == null) {
            return;
        }
        File file = new File(string);
        sLastExportedToFolder = file.getParent();
        try {
            this.exportFrameTo(file);
        }
        catch (IOException iOException) {
            ErrorDialog.openError((Shell)this.mFrameTreeViewer.getTree().getShell(), (String)"Export trace file.", (String)"Unexpected error exporting trace file.", (IStatus)new Status(4, "com.android.ide.eclipse.gldebugger", iOException.toString()));
        }
    }

    private void exportFrameTo(File file) throws IOException {
        String string = this.serializeGlCalls(this.mTrace.getGLCalls(), this.mCallStartIndex, this.mCallEndIndex);
        Files.write((CharSequence)string, (File)file, (Charset)Charsets.UTF_8);
    }

    private String serializeGlCalls(List<GLCall> list, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n < n2) {
            stringBuilder.append(list.get(n).toString());
            stringBuilder.append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    private void setTreeItemsExpanded(boolean bl) {
        if (this.mFrameTreeViewer == null || this.mFrameTreeViewer.getTree().isDisposed()) {
            return;
        }
        if (bl) {
            this.mFrameTreeViewer.expandAll();
        } else {
            this.mFrameTreeViewer.collapseAll();
        }
    }

    private void showFindDialog() {
        if (this.mFindDialog != null) {
            return;
        }
        this.mFindDialog = new FindDialog(Display.getDefault().getActiveShell(), (IFindTarget)this.mFindTarget, 1024);
        this.mFindDialog.open();
        this.mFindDialog = null;
    }

    public String getInputPath() {
        return this.mFilePath;
    }

    private static class GLCallFilter
    extends ViewerFilter {
        private final List<Pattern> mPatterns = new ArrayList<Pattern>();

        private GLCallFilter() {
        }

        public void setFilters(String string) {
            this.mPatterns.clear();
            String[] stringArray = string.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                this.mPatterns.add(Pattern.compile(string2, 2));
                ++n2;
            }
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (!(object2 instanceof GLCallGroups.GLCallNode)) {
                return true;
            }
            String string = this.getTextUnderNode((GLCallGroups.GLCallNode)object2);
            if (this.mPatterns.size() == 0) {
                return true;
            }
            for (Pattern pattern : this.mPatterns) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }

        private String getTextUnderNode(GLCallGroups.GLCallNode gLCallNode) {
            String string = gLCallNode.getCall().getFunction().toString();
            if (!gLCallNode.hasChildren()) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(string);
            for (GLCallGroups.GLCallNode gLCallNode2 : gLCallNode.getChildren()) {
                stringBuilder.append(this.getTextUnderNode(gLCallNode2));
            }
            return stringBuilder.toString();
        }
    }

    private static class GLFrameContentProvider
    implements ITreeContentProvider {
        private GLFrameContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public Object[] getChildren(Object object) {
            if (object instanceof List) {
                return ((List)object).toArray();
            }
            if (!(object instanceof GLCallGroups.GLCallNode)) {
                return null;
            }
            GLCallGroups.GLCallNode gLCallNode = (GLCallGroups.GLCallNode)object;
            if (gLCallNode.hasChildren()) {
                return gLCallNode.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            if (!(object instanceof GLCallGroups.GLCallNode)) {
                return null;
            }
            return ((GLCallGroups.GLCallNode)object).getParent();
        }

        public boolean hasChildren(Object object) {
            if (!(object instanceof GLCallGroups.GLCallNode)) {
                return false;
            }
            return ((GLCallGroups.GLCallNode)object).hasChildren();
        }
    }

    private class GLFrameLabelProvider
    extends ColumnLabelProvider {
        private GLFrameLabelProvider() {
        }

        public void update(ViewerCell viewerCell) {
            Object object = viewerCell.getElement();
            if (!(object instanceof GLCallGroups.GLCallNode)) {
                return;
            }
            GLCall gLCall = ((GLCallGroups.GLCallNode)object).getCall();
            if (gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glDrawArrays || gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glDrawElements) {
                viewerCell.setForeground(GLFunctionTraceViewer.this.mGldrawTextColor);
            }
            if (gLCall.hasErrors()) {
                viewerCell.setForeground(GLFunctionTraceViewer.this.mGlCallErrorColor);
            }
            viewerCell.setText(this.getColumnText(gLCall, viewerCell.getColumnIndex()));
        }

        private String getColumnText(GLCall gLCall, int n) {
            switch (n) {
                case 0: {
                    Object object;
                    if (gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glPushGroupMarkerEXT && (object = gLCall.getProperty(0)) instanceof String) {
                        return (String)object;
                    }
                    return gLCall.toString();
                }
                case 1: {
                    return this.formatDuration(gLCall.getWallDuration());
                }
                case 2: {
                    return this.formatDuration(gLCall.getThreadDuration());
                }
            }
            return Integer.toString(gLCall.getContextId());
        }

        private String formatDuration(int n) {
            return String.format("%,10d", n);
        }
    }

    private class TraceViewerFindTarget
    extends AbstractBufferFindTarget {
        private TraceViewerFindTarget() {
        }

        public int getItemCount() {
            return GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getItemCount();
        }

        public String getItem(int n) {
            Object object = GLFunctionTraceViewer.this.mFrameTreeViewer.getTree().getItem(n).getData();
            if (object instanceof GLCallGroups.GLCallNode) {
                return ((GLCallGroups.GLCallNode)object).getCall().toString();
            }
            return null;
        }

        public void selectAndReveal(int n) {
            Tree tree = GLFunctionTraceViewer.this.mFrameTreeViewer.getTree();
            tree.deselectAll();
            tree.select(tree.getItem(n));
            tree.showSelection();
        }

        public int getStartingIndex() {
            return 0;
        }
    }
}

