/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.Return;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableReference;

public class SharedPrefsDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "Looks for code editing a `SharedPreference` but forgetting to call `commit()` on it", "After calling `edit()` on a `SharedPreference`, you must call `commit()` or `apply()` on the editor to save the results.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(SharedPrefsDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("edit");
    }

    @Nullable
    private static NormalTypeBody findSurroundingTypeBody(Node scope) {
        while (scope != null) {
            Class<?> type = scope.getClass();
            if (type == NormalTypeBody.class) {
                return (NormalTypeBody)scope;
            }
            scope = scope.getParent();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        boolean allowCommitBeforeTarget;
        assert (node.astName().astValue().equals("edit"));
        Expression operand = node.astOperand();
        if (operand == null) {
            return;
        }
        Node parent = node.getParent();
        VariableDefinition definition = SharedPrefsDetector.getLhs(parent);
        if (definition == null) {
            if (!(operand instanceof VariableReference)) return;
            NormalTypeBody body = SharedPrefsDetector.findSurroundingTypeBody(parent);
            if (body == null) {
                return;
            }
            String variableName = ((VariableReference)operand).astIdentifier().astValue();
            String type = SharedPrefsDetector.getFieldType(body, variableName);
            if (type == null || !type.equals("SharedPreferences")) {
                return;
            }
            allowCommitBeforeTarget = true;
        } else {
            String type = definition.astTypeReference().toString();
            if (!(type.endsWith("SharedPreferences.Editor") || type.equals("Editor") && LintUtils.isImported(context.compilationUnit, "android.content.SharedPreferences.Editor"))) {
                return;
            }
            allowCommitBeforeTarget = false;
        }
        Node method = JavaContext.findSurroundingMethod(parent);
        if (method == null) {
            return;
        }
        CommitFinder finder = new CommitFinder(node, allowCommitBeforeTarget);
        method.accept((AstVisitor)finder);
        if (finder.isCommitCalled()) return;
        context.report(ISSUE, method, context.getLocation((Node)node), "SharedPreferences.edit() without a corresponding commit() or apply() call", null);
    }

    @Nullable
    private static String getFieldType(@NonNull NormalTypeBody cls, @NonNull String name) {
        List children = cls.getChildren();
        for (Node child : children) {
            if (child.getClass() != VariableDeclaration.class) continue;
            VariableDeclaration declaration = (VariableDeclaration)child;
            VariableDefinition definition = declaration.astDefinition();
            return definition.astTypeReference().toString();
        }
        return null;
    }

    @Nullable
    private static VariableDefinition getLhs(@NonNull Node node) {
        while (node != null) {
            Class<?> type = node.getClass();
            if (type == MethodDeclaration.class || type == ConstructorDeclaration.class) {
                return null;
            }
            if (type == VariableDefinition.class) {
                return (VariableDefinition)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private static class CommitFinder
    extends ForwardingAstVisitor {
        private final MethodInvocation mTarget;
        private final boolean mAllowCommitBeforeTarget;
        private boolean mFound;
        private boolean mSeenTarget;

        private CommitFinder(MethodInvocation target, boolean allowCommitBeforeTarget) {
            this.mTarget = target;
            this.mAllowCommitBeforeTarget = allowCommitBeforeTarget;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            String name;
            if (node == this.mTarget) {
                this.mSeenTarget = true;
            } else if ((this.mAllowCommitBeforeTarget || this.mSeenTarget || node.astOperand() == this.mTarget) && ("commit".equals(name = node.astName().astValue()) || "apply".equals(name))) {
                this.mFound = true;
            }
            return super.visitMethodInvocation(node);
        }

        public boolean visitReturn(Return node) {
            if (node.astValue() == this.mTarget) {
                this.mFound = true;
            }
            return super.visitReturn(node);
        }

        boolean isCommitCalled() {
            return this.mFound;
        }
    }
}

